# makefile.rb
# @Author:      Thomas Link (micathom AT gmail com)
# @Website:     http://deplate.sf.net/
# @License:     GPL (see http://www.gnu.org/licenses/gpl.txt)
# @Created:     28-Aug-2005.
# @Last Change: 2008-04-13.
# @Revision:    0.168
#
# = Description
# Create a standard makefile.

# require ''

class Deplate::Core
    def deplate_initialize_makefile
        options      = @@command_line_args
        for f in @options.files.reverse
            if options.last == f
                options.pop
            else
                log(['Internal error', 'Makefile', @@command_line_args], :error)
                options = []
                break
            end
        end
        unless options.empty?
            options.each_with_index do |e,i|
                if e == 'makefile'
                    o = options[i - 1]
                    if o == '-m' or o == '--module'
                        options.slice!(i-1 .. i)
                        break
                    end
                end
            end
        end

        base, *files = @options.files
        base0        = File.basename(base, '.*')
        suffix       = File.extname(base)

        if @variables['genericViewer']
            genericViewer = @variables['genericViewer']
        elsif ENV['genericViewer']
            genericViewer = ENV['genericViewer']
        elsif ENV['GNOME_DESKTOP_SESSION_ID']
            genericViewer = 'gnome-open'
        elsif ENV['KDEDIR']
            genericViewer = 'kfmclient'
        elsif ENV['CYGWIN'] || ENV['CYGWIN_PATH'] || ENV['CYGWIN_HOME']
            genericViewer = 'cygstart'
        else
            genericViewer = 'echo Not supported: genericViewer '
        end

        config = <<MAKEFILE
BASE=#{base0}
FILE=#{base}
OTHER=#{files.join(' ') if files}

DEPLATE=deplate

OFLAGS=
DFLAGS=#{options.join(' ')}

HTML_DIR=html
HTML_DFLAGS=-d ${HTML_DIR} -f html

XHTML_DIR=html
XHTML_DFLAGS=-d ${XHTML_DIR} -f xhtml10t

WEBSITE_DIR=website
WEBSITE_DFLAGS=-d ${WEBSITE_DIR} -f htmlsite

PHP_DIR=php
PHP_DFLAGS=-d ${PHP_DIR} -f phpsite

TEX_DIR=tex
TEX_DFLAGS=-d ${TEX_DIR} -f latex

TEXT_DIR=plain
TEXT_DFLAGS=-d ${TEXT_DIR} -f plain

DBK_DIR=docbook
DBK_DFLAGS=-d ${DBK_DIR} -f dbk-article

REF_DIR=${DBK_DIR}
REF_DFLAGS=-d ${REF_DIR} -f dbk-ref

MAKEFILE
        
        makefile = <<MAKEFILE
include Makefile.config

all: dbk html pdf tex text man

dvi: ${BASE}.dvi
dbk: ${BASE}.dbk
html: ${BASE}.html
xhtml: ${BASE}.xhtml
pdf:
	make DFLAGS="${DFLAGS} ${OFLAGS} --pdf" "${BASE}.pdf"
php: ${BASE}.php
tex: ${BASE}.tex
text: ${BASE}.text
man: ${BASE}.1

pdfclean: pdf cleantex
dviclean: dvi cleantex

makefile:
	${DEPLATE} -m makefile ${DFLAGS} ${OFLAGS} ${BASE}#{suffix} ${OTHER}

website:
	make prepare_website
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${WEBSITE_DFLAGS} ${FILE} ${OTHER}
	echo ${WEBSITE_DIR}/${BASE}.html > .last_output

%.html: %#{suffix}
	make prepare_html
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${HTML_DFLAGS} $< ${OTHER}
	echo ${HTML_DIR}/$@ > .last_output

%.xhtml: %#{suffix}
	make prepare_xhtml
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${XHTML_DFLAGS} $< ${OTHER}
	echo ${XHTML_DIR}/$@ > .last_output

%.text: %#{suffix}
	make prepare_text
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${TEXT_DFLAGS} $< ${OTHER}
	echo ${TEXT_DIR}/$@ > .last_output

%.php: %#{suffix}
	make prepare_php
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${PHP_DFLAGS} $< ${OTHER}
	echo ${PHP_DIR}/$@ > .last_output

%.dbk: %#{suffix}
	make prepare_dbk
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${DBK_DFLAGS} $< ${OTHER}
	echo ${DBK_DIR}/$@ > .last_output

%.tex: %#{suffix}
	make prepare_tex
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${TEX_DFLAGS} $< ${OTHER}
	echo ${TEX_DIR}/$@ > .last_output

%.ref: %#{suffix}
	make prepare_ref
	${DEPLATE} ${DFLAGS} ${OFLAGS} ${REF_DFLAGS} -o $@ $< ${OTHER}
	echo ${REF_DIR}/$@ > .last_output

%.dvi: %.tex
	make prepare_dvi
	cd ${TEX_DIR}; \\
	latex ${LATEX_FLAGS} $<; \\
	bibtex ${BIBTEX_FLAGS} $*; \\
	latex ${LATEX_FLAGS} $<; \\
	latex ${LATEX_FLAGS} $<;
	echo ${TEX_DIR}/$@ > .last_output

%.pdf: %.tex
	make prepare_pdf
	cd ${TEX_DIR}; \\
	pdflatex ${PDFLATEX_FLAGS} $<; \\
	bibtex ${BIBTEX_FLAGS} $*; \\
	pdflatex ${PDFLATEX_FLAGS} $<; \\
	pdflatex ${PDFLATEX_FLAGS} $<
	echo ${TEX_DIR}/$@ > .last_output

%.1: %.ref
	cd ${REF_DIR}; \\
	xmlto man $<
	echo ${REF_DIR}/$@ > .last_output

view: show
show:
	#{genericViewer} `cat .last_output`

cleantex:
	cd ${TEX_DIR}; \\
	rm -f *.toc *.aux *.log *.cp *.fn *.tp *.vr *.pg *.ky \\
	*.blg *.bbl *.out *.lot *.ind *.4tc *.4ct \\
	*.ilg *.idx *.idv *.lg *.xref || echo Nothing to be done!

MAKEFILE

        log('Writing Makefile', :anyway)
        File.open(Deplate::Core.file_join(@options.dir, 'Makefile'), 'w') do |io|
            io.puts makefile
        end
        if File.exist?('Makefile.config')
            log('Makefile.config already exists', :anyway)
        else
            log('Writing Makefile.config', :anyway)
            fname = find_in_lib('Makefile.config', :pwd => true)
            if fname
                log(['Makefile.config', fname])
                cfg  = File.open(fname) {|io| io.read}
                tmpl = Deplate::Template.new(:template  => cfg)
                args = {
                    'base0'   => base0,
                    'base'    => base,
                    'files'   => files ? files.join(' ') : nil,
                    'options' => options.join(' '),
                }
                Deplate::Define.let_variables(self, args) do
                    config = tmpl.fill_in(self)
                end
            else
                log(['File not found', 'Makefile.config'], :error)
            end
            File.open(Deplate::Core.file_join(@options.dir, 'Makefile.config'), 'w') do |io|
                io.puts config
            end
        end
        exit 0
    end
end

