require 'cast_256'

def print_block(b)
   for i in 0..(b.length-1)
      if i % 4 == 0 then
         print " "
      end
      x = b[i].to_i
      printf("%X%X", Integer(x/16), x%16)
   end
   print "\n"
end


a = CAST_256.new
a.set_key("2342bb9efa38542cbed0ac83940ac2988d7c47ce264908461cc1b5137ae6b604")


# plain text
original = b = "\0"*16
print 'plain text : '
print_block(b)




# cipher text
b = a.encrypt_block(b)
print 'cipher text: '
print_block(b)


# plain text
b = a.decrypt_block(b)
print 'plain text : '
print_block(b)


if original == b then
   print "\nCAST_256 works correct!\n"
end

readline
