/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.ant;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import net.sf.sahi.ant.Mailer;
import net.sf.sahi.test.TestRunner;

public class Scheduler {
    private Properties properties;
    private TestRunner runner;
    private int successiveFailureCount;
    private int repeatCount;
    private int repeatInterval;
    private int failureRepeatInterval;

    public static void main(String[] args) throws IOException, InterruptedException {
        String filePath = "";
        if (args.length == 0) {
            System.out.println("Usage: java net.sf.sahi.ant.Scheduler [path to scheduler.properties]");
            System.out.println("No scheduler.properties specified. Using ../config/scheduler.properties");
            filePath = "../config/scheduler.properties";
        } else {
            filePath = args[1];
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filePath));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Scheduler scheduler = new Scheduler(properties);
        scheduler.execute();
    }

    public String g(String key) {
        String value = this.properties.getProperty(key);
        System.out.println(key + " " + value);
        return value;
    }

    public Scheduler(Properties properties) {
        this.properties = properties;
        this.runner = new TestRunner(this.g("suite_path"), this.g("browser_exe"), this.g("base_url"), this.g("sahi_host"), this.g("sahi_port"), this.g("threads"), this.g("browser_option"), this.g("browser_process_name"));
        this.repeatCount = this.i("retry_count_on_failure");
        this.successiveFailureCount = this.i("successive_failures");
        this.repeatInterval = this.i("repeat_interval_in_minutes") * 60000;
        this.failureRepeatInterval = this.i("repeat_interval_on_failure_in_seconds") * 1000;
    }

    private int i(String key) {
        return Integer.parseInt(this.g(key));
    }

    public String execute() throws InterruptedException {
        while (true) {
            try {
                String status = "FAILURE";
                status = this.runner.execute();
                System.out.println(status);
                if (!status.trim().equals("SUCCESS")) {
                    this.rapidTest();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Retrying in " + this.repeatInterval + " milliseconds");
            Thread.sleep(this.repeatInterval);
        }
    }

    public void rapidTest() throws InterruptedException {
        int consecutiveFailures = 1;
        for (int i = 1; i < this.repeatCount; ++i) {
            System.out.println("Retrying in " + this.failureRepeatInterval + " milliseconds");
            Thread.sleep(this.failureRepeatInterval);
            try {
                String status = this.runner.execute();
                System.out.println(status);
                if (status.trim().equals("SUCCESS")) {
                    consecutiveFailures = 0;
                    continue;
                }
                if (++consecutiveFailures != this.successiveFailureCount) continue;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (consecutiveFailures >= this.successiveFailureCount) {
            this.onError();
        }
    }

    private void onError() {
        try {
            this.sendMail();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMail() throws AddressException, MessagingException {
        System.out.println("Sending out email ...");
        Mailer mailer = new Mailer(this.g("smtp_host"), this.i("smtp_port"), this.g("smtp_user"), this.g("smtp_password"));
        mailer.send(this.g("email_from"), this.g("email_to"), this.g("email_subject"), this.g("email_content"));
    }
}

