/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.sahi.ant.CreateIssue;
import net.sf.sahi.ant.Report;
import net.sf.sahi.test.ShutDownHook;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner {
    private final String suiteName;
    private final String browser;
    private final String base;
    protected final String sahiHost;
    protected final String port;
    private final String threads;
    protected String sessionId = null;
    private String browserOption;
    private CreateIssue createIssue;
    private List<Report> listReport;
    private String browserProcessName;
    private String extraInfo;
    private String initJS;
    private String browserType;
    private boolean isSingleSession;

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                TestRunner.help();
            }
            if (TestRunner.mainCLIParams(args)) {
                return;
            }
            String suiteName = args[0];
            String base = TestRunner.getBase(args);
            String browser = TestRunner.getBrowser(args);
            String logDir = args[3];
            if ("default".equalsIgnoreCase(logDir)) {
                logDir = "";
            }
            String sahiHost = args[4];
            String port = args[5];
            String threads = args[6];
            String browserOption = "";
            String browserProcessName = args[7];
            if (args.length == 9) {
                browserOption = args[8];
            }
            TestRunner testRunner = new TestRunner(suiteName, browser, base, sahiHost, port, threads, browserOption, browserProcessName);
            testRunner.addReport(new Report("html", logDir));
            String status = testRunner.execute();
            System.out.println("Status:" + status);
        }
        catch (ConnectException ce) {
            System.err.println(ce.getMessage());
            System.err.println("Could not connect to Sahi Proxy.\nVerify that the Sahi Proxy is running on the specified host and port.");
            TestRunner.help();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestRunner.help();
        }
    }

    public static boolean mainCLIParams(String[] args) throws IOException, InterruptedException {
        String logDir;
        String browserType2;
        HashMap<String, String> map = Utils.parseCLInput(args);
        String testName = TestRunner.getTestName(map);
        if (testName == null) {
            return false;
        }
        String host = map.get("host");
        String port2 = map.get("port");
        if (host == null) {
            host = "localhost";
        }
        if (port2 == null) {
            port2 = "9999";
        }
        TestRunner testRunner = (browserType2 = map.get("browserType")) != null ? new TestRunner(testName, browserType2, map.get("baseURL"), host, port2, map.get("threads")) : new TestRunner(testName, map.get("browser"), map.get("baseURL"), host, port2, map.get("threads"), map.get("browserOption"), map.get("browserProcessName"));
        if ("true".equals(map.get("htmlLog"))) {
            logDir = map.get("htmlLogDir");
            if (logDir == null || "default".equals(logDir)) {
                logDir = "";
            }
            testRunner.addReport(new Report("html", logDir));
        }
        if ("true".equals(map.get("tm6Log"))) {
            logDir = map.get("tm6LogDir");
            if (logDir == null || "default".equals(logDir)) {
                logDir = "";
            }
            testRunner.addReport(new Report("tm6", logDir));
        }
        if ("true".equals(map.get("junitLog"))) {
            logDir = map.get("junitLogDir");
            if (logDir == null || "default".equals(logDir)) {
                logDir = "";
            }
            testRunner.addReport(new Report("junit", logDir));
        }
        if (map.get("initJS") != null) {
            testRunner.setInitJS(map.get("initJS"));
        }
        if (map.get("extraInfo") != null) {
            testRunner.setInitJS(map.get("extraInfo"));
        }
        if (map.get("useSingleSession") != null) {
            testRunner.setIsSingleSession("true".equals(map.get("useSingleSession")));
        }
        System.out.println(testRunner.execute());
        return true;
    }

    public void setIsSingleSession(boolean isSingleSession) {
        this.isSingleSession = isSingleSession;
    }

    private static String getTestName(HashMap<String, String> map) {
        String testName = map.get("test");
        if (testName == null) {
            testName = map.get("suite");
        }
        return testName;
    }

    private static String guessBrowserProcessName(String browser2) {
        browser2 = browser2.replace('\\', '/');
        int lastIx = browser2.lastIndexOf(47);
        String executable = "";
        if (lastIx >= 0) {
            executable = browser2.substring(lastIx + 1);
        }
        return executable;
    }

    protected static void help() {
        System.out.println("------------------------");
        System.out.println("New Usage 1: java -cp /path/to/ant-sahi.jar net.sf.sahi.test.TestRunner -test <test_or_suite_name> -browserType <browser_type> -baseURL <start_url> -threads <number_of_threads>");
        System.out.println("--- More options ---");
        System.out.println(" -test \t\t\tpath to test or suite");
        System.out.println(" -baseURL \t\tbaseURL for all tests");
        System.out.println(" -threads \t\tno. of browser instances to run in parallel");
        System.out.println(" -browserType \t\tbrowserType as specified in sahi/userdata/config/browser_types.xml");
        System.out.println(" -browser \t\tfull browser to browser. Ignored if browserType specified.");
        System.out.println(" -browserProcessName \tbrowser process name used to find the pid when using ps or tasklist commands. Ignored if browserType specified.");
        System.out.println(" -browserOption \tOptions to be passed to browser. Ignored if browserType specified.");
        System.out.println(" -junitLog \t\ttrue or false. Enable or disable junit logs");
        System.out.println(" -junitLogDir \t\tpath to junit log dir. If not specified, uses default location in userdata/logs");
        System.out.println(" -htmlLog \t\ttrue or false. Enable or disable html logs");
        System.out.println(" -htmlLogDir \t\tpath to html log dir. If not specified, uses default location in userdata/logs");
        System.out.println(" -initJS \t\tAny javascript which would be executed before every script");
        System.out.println(" -useSingSession \t\ttrue or false. Execute all scripts sequentially in a single browser session. Default is false.");
        System.out.println(" -extraInfo \t\tAny extra info that may be accessed using _extraInfo()");
        System.out.println("--- OR ---");
        System.out.println("Usage: java -cp /path/to/ant-sahi.jar net.sf.sahi.test.TestRunner <test_or_suite_name> <browser_executable> <start_url> <log_dir> <sahi_host> <sahi_port> <number_of_threads> <browser_executable> [<browser_option>]");
        System.out.println("Set log_dir to \"default\" to log to the default log dir");
        System.out.println("Set number_of_threads to a number which is compatible with your machine CPU and RAM.");
        System.out.println("Look at http://sahi.co.in/w/Running+multiple+tests+in+batch+mode for details on browser options for various browsers.");
        System.out.println("------------------------");
        System.exit(-1);
    }

    public void addReport(Report report) {
        if (this.listReport == null) {
            this.listReport = new ArrayList<Report>();
        }
        this.listReport.add(report);
    }

    public TestRunner(String suiteName, String browser, String base, String sahiHost, String port, String threads, String browserOption, String browserProcessName) {
        this.suiteName = suiteName;
        this.browser = browser;
        this.base = base;
        this.sahiHost = sahiHost;
        this.port = port;
        this.threads = threads;
        this.browserOption = browserOption;
        this.browserProcessName = browserProcessName;
        if (browserProcessName == null) {
            this.browserProcessName = TestRunner.guessBrowserProcessName(browser);
        }
        System.out.println(this.toString());
    }

    public TestRunner(String suiteName, String browserType, String base, String threads) {
        this(suiteName, browserType, base, "localhost", "9999", threads);
    }

    public TestRunner(String suiteName, String browserType, String base, String sahiHost, String port, String threads) {
        this.suiteName = suiteName;
        this.browser = null;
        this.browserType = browserType;
        this.base = base;
        this.sahiHost = sahiHost;
        this.port = port;
        this.threads = threads;
        System.out.println(this.toString());
    }

    public TestRunner(String suiteName, String browser, String base, String sahiHost, String port, String threads, String browserOption, String browserProcessName, List<Report> listReporter, CreateIssue createIssue) {
        this(suiteName, browser, base, sahiHost, port, threads, browserOption, browserProcessName);
        this.listReport = listReporter;
        this.createIssue = createIssue;
    }

    public TestRunner(String suiteName, String browserType, String base, String sahiHost, String port, String threads, List<Report> listReporter, CreateIssue createIssue) {
        this(suiteName, browserType, base, sahiHost, port, threads);
        this.listReport = listReporter;
        this.createIssue = createIssue;
    }

    public TestRunner(String suiteName, String browserType, String base, String sahiHost, String port, String threads, String initJS) {
        this(suiteName, browserType, base, sahiHost, port, threads);
        this.initJS = initJS;
    }

    public String execute() throws IOException, InterruptedException {
        return this.execute("start");
    }

    public String execute(String command) throws IOException, InterruptedException {
        if (this.sessionId == null) {
            this.sessionId = Utils.generateId();
        }
        String urlStr = this.buildURL(command);
        try {
            Thread thread = new Thread(new ShutDownHook(this.sahiHost, this.port, this.sessionId));
            Runtime.getRuntime().addShutdownHook(thread);
            System.out.println("Added shutdown hook.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(urlStr);
        URL url = new URL(urlStr);
        InputStream in = url.openStream();
        in.close();
        return this.getStatus();
    }

    protected String getStatus() throws InterruptedException {
        String status;
        block1: {
            int retries = 0;
            do {
                Thread.sleep(2000L);
                status = this.getSuiteStatus(this.sessionId);
                if ("SUCCESS".equals(status) || "FAILURE".equals(status)) break block1;
            } while (!"RETRY".equals(status) || retries++ != 10);
            status = "FAILURE";
        }
        return status;
    }

    protected String buildURL(String command) throws UnsupportedEncodingException {
        StringBuffer urlStr = new StringBuffer(200).append("http://").append(this.sahiHost).append(":").append(this.port).append("/_s_/dyn/Suite_" + command + "?suite=").append(TestRunner.encode(this.suiteName)).append("&base=").append(TestRunner.encode(this.base)).append("&threads=").append(TestRunner.encode(this.threads)).append("&sahisid=").append(TestRunner.encode(this.sessionId));
        if (this.browserType != null) {
            urlStr.append("&browserType=").append(TestRunner.encode(this.browserType));
        } else {
            urlStr.append("&browser=").append(TestRunner.encode(this.browser));
            urlStr.append("&browserProcessName=").append(TestRunner.encode(this.browserProcessName));
            if (this.browserOption != null) {
                urlStr.append("&browserOption=").append(TestRunner.encode(this.browserOption));
            }
        }
        if (this.extraInfo != null) {
            urlStr.append("&extraInfo=").append(TestRunner.encode(this.extraInfo));
        }
        if (this.initJS != null) {
            urlStr.append("&initJS=").append(TestRunner.encode(this.initJS));
        }
        System.out.println("this.isSingleSession == " + this.isSingleSession);
        if (this.isSingleSession) {
            urlStr.append("&useSingleSession=").append(this.isSingleSession);
        }
        if (this.listReport == null || this.listReport.size() == 0) {
            this.addReport(new Report("html", null));
        }
        for (Report report : this.listReport) {
            urlStr.append("&").append(TestRunner.encode(report.getType())).append("=").append(report.getLogDir() != null ? TestRunner.encode(report.getLogDir()) : "");
        }
        if (this.createIssue != null) {
            urlStr.append("&").append(TestRunner.encode(this.createIssue.getTool())).append("=");
            if (this.createIssue.getPropertiesFile() != null) {
                urlStr.append(TestRunner.encode(this.createIssue.getPropertiesFile()));
            }
        }
        return urlStr.toString();
    }

    private String getSuiteStatus(String sessionId) {
        String status;
        try {
            String urlStr = "http://" + this.sahiHost + ":" + this.port + "/_s_/dyn/Suite_status?s" + "&sahisid=" + TestRunner.encode(sessionId);
            URL url = new URL(urlStr);
            InputStream in = url.openStream();
            StringBuffer sb = new StringBuffer();
            int c = 32;
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
            status = sb.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception while connecting to Sahi proxy to check status. Retrying ...");
            status = "RETRY";
        }
        return status;
    }

    protected static String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF8");
    }

    protected static String getBase(String[] args) {
        String base = "";
        try {
            base = args[2];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base;
    }

    protected static String getBrowser(String[] args) {
        String browser = "";
        try {
            browser = args[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return browser;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nsuiteName = " + this.suiteName);
        sb.append("\nbase = " + this.base);
        sb.append("\nsahiHost = " + this.sahiHost);
        sb.append("\nport = " + this.port);
        sb.append("\nthreads = " + this.threads);
        if (this.browserType != null) {
            sb.append("\nbrowserType = " + this.browserType);
        } else {
            sb.append("\nbrowser = " + this.browser);
            sb.append("\nbrowserOption = " + this.browserOption);
            sb.append("\nbrowserProcessName = " + this.browserProcessName);
        }
        return sb.toString();
    }

    public void setInitJS(String initJS) {
        this.initJS = initJS;
    }

    public void setInitJS(HashMap<String, Object> variableHashMap) {
        StringBuilder sb = new StringBuilder();
        for (String key : variableHashMap.keySet()) {
            sb.append("var " + key).append(" = ").append(this.getJSValue(variableHashMap.get(key))).append(";");
        }
        System.out.println(sb.toString());
        this.initJS = sb.toString();
    }

    private Object getJSValue(Object object) {
        if (object instanceof String) {
            return "\"" + Utils.escapeDoubleQuotesAndBackSlashes((String)object) + "\"";
        }
        return object.toString();
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }
}

