/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.client;

import java.util.ArrayList;
import java.util.List;
import net.sf.sahi.client.Browser;
import net.sf.sahi.client.ExecutionException;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementStub {
    private final String elementType;
    private Object[] identifiers;
    private final Browser browser;
    private int index = -1;

    public ElementStub(String elementType, Browser browser, Object ... args) {
        this.elementType = elementType;
        this.browser = browser;
        this.identifiers = args;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean start = true;
        for (Object o : this.identifiers) {
            if (!start) {
                sb.append(", ");
                sb.append(this.getArgument(o, -1));
            } else {
                sb.append(this.getArgument(o, this.index));
            }
            start = false;
        }
        return "_sahi._" + this.elementType + "(" + sb.toString() + ")";
    }

    private Object getArgument(Object o, int ix) {
        String s = o.toString();
        if (o instanceof String) {
            if (ix != -1) {
                s = s + "[" + ix + "]";
            }
            if (s.length() <= 1 || !s.startsWith("/") || !s.endsWith("/")) {
                return "\"" + Utils.escapeDoubleQuotesAndBackSlashes(s) + "\"";
            }
        }
        return s;
    }

    public void click() throws ExecutionException {
        this.browser.click(this);
    }

    public void doubleClick() throws ExecutionException {
        this.browser.doubleClick(this);
    }

    public void rightClick() throws ExecutionException {
        this.browser.rightClick(this);
    }

    public void check() throws ExecutionException {
        this.browser.check(this);
    }

    public void uncheck() throws ExecutionException {
        this.browser.uncheck(this);
    }

    public void focus() throws ExecutionException {
        this.browser.focus(this);
    }

    public void removeFocus() throws ExecutionException {
        this.browser.removeFocus(this);
    }

    public void dragAndDropOn(ElementStub dropElement) throws ExecutionException {
        this.browser.dragDrop(this, dropElement);
    }

    public void dragAndDropOn(int x, int y) throws ExecutionException {
        this.browser.dragDropXY(this, x, y);
    }

    public void mouseOver() throws ExecutionException {
        this.browser.mouseOver(this);
    }

    public void mouseDown() throws ExecutionException {
        this.browser.mouseDown(this);
    }

    public void mouseUp() throws ExecutionException {
        this.browser.mouseUp(this);
    }

    public void hover() throws ExecutionException {
        this.mouseOver();
    }

    public void setValue(String value) throws ExecutionException {
        this.browser.setValue(this, value);
    }

    public void setFile(String value) throws ExecutionException {
        this.browser.setFile(this, value);
    }

    public void choose(String value) throws ExecutionException {
        this.choose(value, false);
    }

    public void choose(String value, boolean append) throws ExecutionException {
        this.browser.choose(this, value, append);
    }

    public void choose(String[] values) throws ExecutionException {
        this.choose(values, false);
    }

    public void choose(String[] values, boolean append) throws ExecutionException {
        this.browser.choose(this, values, append);
    }

    public String text() throws ExecutionException {
        return this.getText();
    }

    public String getText() throws ExecutionException {
        return this.browser.getText(this);
    }

    public void rteWrite(String value) throws ExecutionException {
        this.browser.rteWrite(this, value);
    }

    public String rteText() {
        return this.browser.fetch("_sahi._rteText(" + this + ")");
    }

    public String rteHTML() {
        return this.browser.fetch("_sahi._rteHTML(" + this + ")");
    }

    public String fetch() throws ExecutionException {
        return this.fetch(null);
    }

    public boolean exists() {
        return this.browser.exists(this);
    }

    public boolean exists(boolean optimistic) {
        return this.browser.exists(this, optimistic);
    }

    public String value() throws ExecutionException {
        return this.getValue();
    }

    public String getValue() throws ExecutionException {
        return this.browser.getValue(this);
    }

    public String selectedText() throws ExecutionException {
        return this.getSelectedText();
    }

    public boolean isVisible() throws ExecutionException {
        return this.browser.isVisible(this, false);
    }

    public boolean isVisible(boolean optimistic) throws ExecutionException {
        return this.browser.isVisible(this, optimistic);
    }

    public String getSelectedText() throws ExecutionException {
        return this.browser.getSelectedText(this);
    }

    public boolean containsText(String text) {
        return this.browser.containsText(this, text);
    }

    public boolean containsHTML(String html) {
        return this.browser.containsHTML(this, html);
    }

    public String style(String html) {
        return this.browser.style(this, html);
    }

    public ElementStub in(ElementStub inEl) {
        return this.relation("in", inEl);
    }

    public ElementStub under(ElementStub underEl) {
        return this.relation("under", underEl);
    }

    public ElementStub near(ElementStub nearEl) {
        return this.relation("near", nearEl);
    }

    private ElementStub relation(String relationType, ElementStub inEl) {
        Object[] newArray = new Object[this.identifiers.length + 1];
        System.arraycopy(this.identifiers, 0, newArray, 0, this.identifiers.length);
        newArray[this.identifiers.length] = new ElementStub(relationType, this.browser, inEl);
        this.identifiers = newArray;
        return this;
    }

    public String fetch(String string) throws ExecutionException {
        String value = this.browser.fetch(string = string != null ? this + "." + string : this.toString());
        if (value.equals("undefined") || value.equals("null")) {
            return null;
        }
        return value;
    }

    public boolean checked() throws ExecutionException {
        return this.browser.checked(this);
    }

    public ElementStub parentNode() {
        return new ElementStub("parentNode", this.browser, this);
    }

    public ElementStub parentNode(String tagName) {
        return new ElementStub("parentNode", this.browser, this, tagName);
    }

    private ElementStub parentNode(String tagName, String occurrence) {
        return new ElementStub("parentNode", this.browser, this, tagName, occurrence);
    }

    public ElementStub parentNode(String tagName, int occurrence) {
        return this.parentNode(tagName, "" + occurrence);
    }

    public List<ElementStub> collectSimilar() {
        int count = this.countSimilar();
        ArrayList<ElementStub> els = new ArrayList<ElementStub>();
        for (int i = 0; i < count; ++i) {
            ElementStub el = new ElementStub(this.elementType, this.browser, this.identifiers);
            el.setIndex(i);
            els.add(el);
        }
        return els;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int countSimilar() {
        StringBuffer sb = new StringBuffer();
        boolean start = true;
        for (Object o : this.identifiers) {
            if (!start) {
                sb.append(", ");
            }
            start = false;
            sb.append(this.getArgument(o, -1));
        }
        String toFetch = "_sahi._count(\"_" + this.elementType + "\", " + sb.toString() + ")";
        String countStr = this.browser.fetch(toFetch);
        try {
            return Integer.parseInt(countStr);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void keyUp(int keyCode, int charCode) {
        this.browser.keyUp(this, keyCode, charCode);
    }

    public void keyDown(int keyCode, int charCode) {
        this.browser.keyDown(this, keyCode, charCode);
    }
}

