/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.util.ClassLoadHelper;
import net.sf.sahi.util.Utils;

public class CommandExecuter {
    private static final Logger logger = Logger.getLogger("net.sf.sahi.command.CommandExecuter");
    private String commandMethod;
    private String commandClass;
    private final HttpRequest request;
    private static String DELIMITER = "_";

    public CommandExecuter(String cmd, HttpRequest request, boolean isPro) {
        this.request = request;
        this.commandClass = cmd;
        this.commandMethod = "execute";
        if (cmd.indexOf(DELIMITER) != -1) {
            this.commandClass = cmd.substring(0, cmd.indexOf(DELIMITER));
            this.commandMethod = cmd.substring(cmd.indexOf(DELIMITER) + 1);
        }
        if (this.commandClass.indexOf(46) == -1) {
            this.commandClass = "net.sf.sahi.command." + this.commandClass;
        }
    }

    public HttpResponse execute() {
        try {
            Class clazz = ClassLoadHelper.getClass(this.commandClass);
            Method method = clazz.getDeclaredMethod(this.commandMethod, HttpRequest.class);
            Object returned = method.invoke(clazz.newInstance(), this.request);
            return returned == null ? new NoCacheHttpResponse() : (HttpResponse)returned;
        }
        catch (Exception e) {
            logger.warning("commandClass = >" + this.commandClass + "< commandMethod = >" + this.commandMethod + "<");
            logger.warning(Utils.getStackTraceString(e));
            return new NoCacheHttpResponse("SAHI_ERROR");
        }
    }

    String getCommandClass() {
        return this.commandClass;
    }

    String getCommandMethod() {
        return this.commandMethod;
    }
}

