/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpModifiedResponse2;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.util.Utils;

public class Cookies {
    public HttpResponse showAll(HttpRequest request) {
        String cookies = this.getCookies(request);
        Properties props = new Properties();
        props.setProperty("cookies", cookies);
        return new HttpModifiedResponse2(new HttpFileResponse(Utils.concatPaths(Configuration.getHtdocsRoot(), "spr/cookies.htm"), props, false, false), request.isSSL(), "htm");
    }

    public HttpResponse read(HttpRequest request) {
        String name = request.getParameter("name");
        String cookieValue = this.readCookie(name, request);
        cookieValue = cookieValue == null ? "null" : Utils.makeString(cookieValue);
        return new SimpleHttpResponse(cookieValue);
    }

    private String readCookie(String name, HttpRequest request) {
        String cookieString = this.getCookies(request);
        if (cookieString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(cookieString, ";");
        while (tokenizer.hasMoreTokens()) {
            String keyVal = tokenizer.nextToken();
            int eqIx = keyVal.indexOf(61);
            if (eqIx == -1) continue;
            String key = keyVal.substring(0, eqIx).trim();
            String value = "";
            if (eqIx + 1 <= keyVal.length()) {
                value = keyVal.substring(eqIx + 1).trim();
            }
            if (!key.equals(name)) continue;
            return value;
        }
        return null;
    }

    private String getCookies(HttpRequest request) {
        return request.headers().getLastHeader("Cookie");
    }

    public HttpResponse create(HttpRequest request) {
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        String path = request.getParameter("path");
        String domain = request.getParameter("domain");
        String expires = request.getParameter("expires");
        SimpleHttpResponse response = new SimpleHttpResponse("");
        String cookieStr = name + "=" + value + "; ";
        if (expires != null) {
            cookieStr = cookieStr + "expires=" + expires + "; ";
        }
        if (path != null) {
            cookieStr = cookieStr + "path=" + path + "; ";
        }
        if (domain != null) {
            cookieStr = cookieStr + "domain=" + domain + ";";
        }
        response.addHeader("Set-Cookie", cookieStr);
        return response;
    }

    public HttpResponse delete(HttpRequest request) {
        String name = request.getParameter("name");
        String path = request.getParameter("path");
        if (path == null) {
            path = "/";
        }
        String domain = request.host();
        SimpleHttpResponse response = new SimpleHttpResponse("");
        if (this.readCookie(name, request) != null) {
            response.addHeader("Set-Cookie", name + "=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=" + path + ";");
            response.addHeader("Set-Cookie", name + "=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=" + path + "; domain=" + domain + ";");
            response.addHeader("Set-Cookie", name + "=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=" + path + "; domain=." + domain + ";");
            response.addHeader("Set-Cookie", name + "=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=" + path + "; domain=" + domain + "; secure");
            response.addHeader("Set-Cookie", name + "=; expires=Thu, 01 Jan 1970 00:00:01 GMT; path=" + path + "; domain=." + domain + "; secure");
        }
        return response;
    }
}

