/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.sahi.RemoteRequestProcessor;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.request.MultiPartRequest;
import net.sf.sahi.request.MultiPartSubRequest;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.MimeType;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.session.Session;
import net.sf.sahi.util.FileNotFoundRuntimeException;
import net.sf.sahi.util.Utils;

public class FileUpload {
    private static Logger logger = Configuration.getLogger("net.sf.sahi.command.FileUpload");

    public HttpResponse setFile(HttpRequest request) {
        String key;
        Session session = request.session();
        ArrayList<String> list = (ArrayList<String>)session.getObject(key = "file:" + request.getParameter("n"));
        if (list == null) {
            list = new ArrayList<String>();
        }
        String filePath = request.getParameter("v");
        list.add(filePath);
        session.setObject(key, list);
        session.mockResponder().add(request.getParameter("action").replaceAll("[.]", "[.]") + ".*", "FileUpload_appendFiles");
        if (new File(Configuration.getAbsoluteUserPath(filePath)).exists()) {
            return new SimpleHttpResponse("true");
        }
        return new SimpleHttpResponse("File not found: " + filePath + "; Base directory is userdata directory: " + Configuration.getUserDataDir());
    }

    public HttpResponse appendFiles(HttpRequest request) {
        HttpRequest rebuiltRequest = request;
        if (request.isMultipart()) {
            MultiPartRequest multiPartRequest;
            Session session = request.session();
            try {
                multiPartRequest = new MultiPartRequest(request);
            }
            catch (IOException e) {
                return null;
            }
            List<MultiPartSubRequest> parts = multiPartRequest.getMultiPartSubRequests();
            for (MultiPartSubRequest part : parts) {
                ArrayList fileNames = (ArrayList)session.getObject("file:" + part.name());
                if (fileNames == null || fileNames.size() == 0) continue;
                String fileName = (String)fileNames.remove(0);
                String absolutePath = Configuration.getAbsoluteUserPath(fileName);
                logger.info("Uploading: fileName = " + fileName + " resolved to " + absolutePath);
                part.setHeader("Content-Type", MimeType.getMimeTypeOfFile(fileName, "application/octet-stream"));
                byte[] fileContent = new byte[]{};
                try {
                    fileContent = Utils.readFile(absolutePath);
                }
                catch (FileNotFoundRuntimeException e) {
                    logger.warning(Utils.getStackTraceString(e));
                }
                part.setData(fileContent);
                part.removeHeader("Content-Length");
                part.setFileName(new File(fileName).getName());
            }
            rebuiltRequest = multiPartRequest.getRebuiltRequest();
            session.mockResponder().remove(request.url().replaceAll("[.]", "[.]"));
        }
        return new RemoteRequestProcessor().processHttp(rebuiltRequest);
    }
}

