/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.io.UnsupportedEncodingException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.playback.ScriptFactory;
import net.sf.sahi.report.LogViewer;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.NoCacheHttpResponse;
import net.sf.sahi.response.SimpleHttpResponse;
import net.sf.sahi.util.FileNotFoundRuntimeException;
import net.sf.sahi.util.URLParser;
import net.sf.sahi.util.Utils;

public class Log {
    public HttpResponse viewLogs(HttpRequest request) {
        String fileName = URLParser.logFileNamefromURI(request.uri());
        if ("".equals(fileName)) {
            String logsList = LogViewer.getLogsList(Configuration.getPlayBackLogsRoot());
            NoCacheHttpResponse response = new NoCacheHttpResponse(logsList);
            return response;
        }
        return new HttpFileResponse(fileName, null, false, false);
    }

    public HttpResponse getBrowserScript(HttpRequest request) {
        String scriptPath = request.getParameter("href");
        SahiScript script = new ScriptFactory().getScript(scriptPath);
        SimpleHttpResponse httpResponse = script != null ? new SimpleHttpResponse(LogViewer.highlight(script.getBrowserJSWithLineNumbers(), this.getLineNumber(request))) : new SimpleHttpResponse("No Script has been set for playback.");
        return httpResponse;
    }

    public HttpResponse highlight(HttpRequest request) {
        String content;
        int lineNumber = this.getLineNumber(request);
        String href = request.getParameter("href");
        if (href.startsWith("http://") || href.startsWith("https://")) {
            content = new String(Utils.readURL(href));
        } else {
            try {
                content = Utils.readFileAsString(Configuration.getAbsoluteUserPath(href));
            }
            catch (FileNotFoundRuntimeException e) {
                content = "File [" + href + "] not found";
            }
        }
        content = content.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        SimpleHttpResponse response = new SimpleHttpResponse("");
        String highlighted = LogViewer.highlight(content, lineNumber);
        highlighted = ("<h4>" + href.replace("\\\\", "\\") + "</h4>").concat(highlighted);
        try {
            response.setData(highlighted.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            response.setData(highlighted.getBytes());
        }
        response.resetRawHeaders();
        return response;
    }

    private int getLineNumber(HttpRequest req) {
        String p = req.getParameter("n");
        int i = -1;
        try {
            i = Integer.parseInt(p);
        }
        catch (Exception e) {
            // empty catch block
        }
        return i;
    }
}

