/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import net.sf.sahi.RemoteRequestProcessor;
import net.sf.sahi.command.CommandExecuter;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpModifiedResponse2;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.util.Utils;

public class MockResponder {
    private HashMap<String, String> map = new HashMap();

    public void add(String urlPattern, String className) {
        this.map.put(urlPattern, className);
    }

    public void remove(String urlPattern) {
        this.map.remove(urlPattern);
    }

    String getCommand(String url) {
        for (String pattern : this.map.keySet()) {
            if (!url.matches(pattern)) continue;
            return this.map.get(pattern);
        }
        return null;
    }

    public HttpResponse getResponse(HttpRequest request) throws Exception {
        String url = request.url();
        String command = this.getCommand(url);
        if (command == null) {
            return null;
        }
        System.out.println("url: " + url);
        System.out.println("command: " + command);
        return new CommandExecuter(command, request, false).execute();
    }

    public void remove(HttpRequest request) {
        request.session().mockResponder().remove(request.getParameter("pattern"));
    }

    public void add(HttpRequest request) {
        request.session().mockResponder().add(request.getParameter("pattern"), request.getParameter("class"));
    }

    public HttpResponse mockImage(HttpRequest request) throws IOException {
        return new HttpFileResponse(Utils.concatPaths(Configuration.getHtdocsRoot(), "spr/mock.gif"), null, true, true);
    }

    public HttpResponse simple(HttpRequest request) throws IOException {
        Properties props = new Properties();
        props.put("url", request.url());
        HttpFileResponse mockResponse = new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/simpleMock.htm", props, false, false);
        HttpModifiedResponse2 response = new HttpModifiedResponse2(mockResponse, request.isSSL(), request.fileExtension());
        return response;
    }

    public HttpResponse fileUpload(HttpRequest request) {
        return new RemoteRequestProcessor().processHttp(request);
    }
}

