/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.command;

import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.SahiScript;
import net.sf.sahi.report.LogViewer;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.response.HttpFileResponse;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.util.Utils;

public class Script {
    public HttpResponse view(HttpRequest request) {
        String file = request.getParameter("script");
        return this.view(file);
    }

    public HttpResponse view(String file) {
        String js = Script.makeIncludeALink(file);
        Properties props = new Properties();
        props.setProperty("name", file.replaceAll("\\\\", "/"));
        props.setProperty("js", js);
        props.setProperty("script", js);
        return new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/script.htm", props, false, true);
    }

    public static String makeIncludeALink(String baseFile) {
        String inputStr = Utils.readFileAsString(baseFile);
        inputStr = inputStr.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        inputStr = LogViewer.highlight(inputStr, -1);
        String patternStr = "[\"'](.*[.]sah)[\"']";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String includedScriptName = matcher.group(1);
            String scriptPath = Utils.concatPaths(baseFile, includedScriptName).replaceAll("\\\\", "/");
            String replaceStr = "";
            replaceStr = includedScriptName.startsWith("http://") || includedScriptName.startsWith("https://") ? "<a href='" + includedScriptName + "'>" + includedScriptName + "</a>" : "<a href='/_s_/dyn/Script_view?script=" + scriptPath + "'>" + includedScriptName + "</a>";
            matcher.appendReplacement(sb, replaceStr);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    HttpResponse dummyFunctions(HttpRequest request) {
        ArrayList<String> words = SahiScript.getKeyWords();
        StringBuffer sb = new StringBuffer();
        for (String word : words) {
            sb.append("var " + word + " = b;\n");
            sb.append("var _" + word + " = b;\n");
        }
        String functions = sb.toString();
        Properties props = new Properties();
        props.setProperty("dummyFunctions", functions);
        return new HttpFileResponse(Configuration.getHtdocsRoot() + "spr/dummyFunctions.js", props, false, true);
    }
}

