/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.sahi.util.FileUtils;
import net.sf.sahi.util.Utils;

public class Configuration {
    static Properties userProperties;
    private static final String HTDOCS_ROOT = "htdocs/";
    private static final String SAHI_PROPERTIES = "config/sahi.properties";
    private static final String SAHI_USER_PROPERTIES = "config/userdata.properties";
    private static final String LOG_PROPERITES = "config/log.properties";
    private static final String TMP_DOWNLOAD_DIR = "temp/download";
    public static final String PLAYBACK_LOG_ROOT = "playback";
    private static String userDataDir;
    private static String basePath;
    private static String[] exclusionList;
    private static String keytoolPath;
    private static boolean keytoolFound;
    static int enableKeepAlive;
    private static String overriddenControllerMode;
    private static String[] downloadURLList;
    private static String[] blockableSSLDomainList;
    private static String domainFixInfo;

    public static void init() {
        Configuration.init(".", "userdata");
    }

    public static void init(String basePath1, String userDataDirectory) {
        try {
            basePath = basePath1;
            userDataDir = userDataDirectory;
            String propsPath = Utils.concatPaths(basePath, SAHI_PROPERTIES);
            System.out.println("Sahi properties file = " + propsPath);
            String userPropsPath = Utils.concatPaths(userDataDir, SAHI_USER_PROPERTIES);
            System.out.println("Sahi user properties file = " + userPropsPath);
            Properties properties = new Properties();
            Configuration.loadProperties(propsPath, properties);
            userProperties = new Properties(properties);
            Configuration.loadProperties(userPropsPath, userProperties);
            System.setProperty("java.util.logging.config.file", LOG_PROPERITES);
            Configuration.createFolders(new File(Configuration.getPlayBackLogsRoot()));
            Configuration.createFolders(new File(Configuration.getCertsPath()));
            Configuration.createFolders(new File(Configuration.tempDownloadDir()));
            Configuration.copyProfiles();
            Utils.BUFFER_SIZE = Configuration.getBufferSize();
            System.setProperty("java.util.logging.config.file", Configuration.getLogPropertyFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getLogPropertyFile() {
        return Utils.concatPaths(userDataDir, "/config/log.properties");
    }

    private static int getBufferSize() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("io.buffer_size"));
        }
        catch (Exception e) {
            return 4096;
        }
    }

    public static void loadProperties(String sahiProperties, Properties props) throws FileNotFoundException, IOException {
        FileInputStream inStream = new FileInputStream(sahiProperties);
        props.load(inStream);
        inStream.close();
    }

    public static void initJava() {
        Configuration.initJava(".", "userdata");
    }

    public static void initJava(String basePath, String userDataDirectory) {
        Configuration.init(basePath, userDataDirectory);
        Configuration.setControllerMode("java");
    }

    public static void copyProfiles() throws IOException {
        String templateDir = Utils.concatPaths(basePath, Configuration.getUserProperty("ff.profiles.template"));
        String profilesDirPath = Utils.concatPaths(userDataDir, Configuration.getUserProperty("ff.profiles.dir"));
        File profileDir = new File(profilesDirPath);
        profileDir.mkdirs();
        String prefix = Configuration.getUserProperty("ff.profiles.prefix");
        String profile0 = Utils.concatPaths(profileDir.getCanonicalPath(), prefix + 0);
        if (!new File(profile0).exists()) {
            try {
                FileUtils.copyDir(templateDir, profile0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int maxProfiles = Integer.parseInt(Configuration.getUserProperty("ff.profiles.max_number", "10"));
        for (int i = 1; i < maxProfiles; ++i) {
            String profileN = Utils.concatPaths(profileDir.getCanonicalPath(), prefix + i);
            Configuration.copyFile(profile0, profileN, "prefs.js");
            Configuration.copyFile(profile0, profileN, "cert8.db");
            Configuration.copyFile(profile0, profileN, "key3.db");
            Configuration.copyFile(profile0, profileN, "cert_override.txt");
        }
    }

    public static void copyFile(String origDir, String destDir, String fileName) {
        try {
            File src = new File(origDir, fileName);
            if (src.exists()) {
                FileUtils.copyFile(src, new File(destDir, fileName));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createFolders(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static int getPort() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("proxy.port"));
        }
        catch (Exception e) {
            return 9999;
        }
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public static String getLogsRoot() {
        String fileName = Utils.concatPaths(userDataDir, Configuration.getUserProperty("logs.dir", "logs"));
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return fileName;
    }

    public static String getSSLPassword() {
        return Configuration.getUserProperty("ssl.password");
    }

    public static String[] getScriptRoots() {
        String[] propertyArray = Configuration.getPropertyArray("scripts.dir", userProperties, "scripts");
        for (int i = 0; i < propertyArray.length; ++i) {
            propertyArray[i] = Utils.getAbsolutePath(Utils.concatPaths(userDataDir, propertyArray[i])) + System.getProperty("file.separator");
        }
        return propertyArray;
    }

    public static String[] getScriptExtensions() {
        return Configuration.getPropertyArray("script.extension", userProperties, "sah;sahi;inc");
    }

    private static String[] getPropertyArray(String key, Properties props, String defaultValue) {
        String property = props.getProperty(key, defaultValue);
        String[] tokens = property.split(";");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    public static String getPlayBackLogsRoot() {
        String fileName = Utils.concatPaths(Configuration.getLogsRoot(), PLAYBACK_LOG_ROOT);
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return fileName;
    }

    public static String getHtdocsRoot() {
        return Utils.concatPaths(basePath, HTDOCS_ROOT) + "/";
    }

    public static String getPlaybackLogCSSFileName(boolean addHtdocsRoot) {
        String path = "spr/css/playback_log_format.css";
        return addHtdocsRoot ? Utils.concatPaths(Configuration.getHtdocsRoot(), "spr/css/playback_log_format.css") : "spr/css/playback_log_format.css";
    }

    public static String getConsolidatedLogCSSFileName(boolean addHtdocsRoot) {
        String path = "spr/css/consolidated_log_format.css";
        return addHtdocsRoot ? Utils.concatPaths(Configuration.getHtdocsRoot(), "spr/css/consolidated_log_format.css") : "spr/css/consolidated_log_format.css";
    }

    public static String getRhinoLibJS() {
        return new String(Utils.readFileAsString(Utils.concatPaths(Configuration.getHtdocsRoot(), "spr/lib.js")));
    }

    public static boolean isKeepAliveEnabled() {
        return enableKeepAlive > 0 || enableKeepAlive <= 0 && "true".equalsIgnoreCase(Configuration.getUserProperty("http.keep_alive"));
    }

    public static int getTimeBetweenTestsInSuite() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("suite.time_between_tests"));
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public static int getMaxInactiveTimeForScript() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("suite.max_inactive_time_for_script")) * 1000;
        }
        catch (Exception e) {
            return 20000;
        }
    }

    public static void createScriptsDirIfNeeded() {
        String[] scriptRoots = Configuration.getScriptRoots();
        for (int i = 0; i < scriptRoots.length; ++i) {
            String scriptRoot = scriptRoots[i];
            File file = new File(scriptRoot);
            file.mkdirs();
        }
    }

    public static String getHotKey() {
        String hotkey = Configuration.getUserProperty("controller.hotkey");
        if ("SHIFT".equals(hotkey) || "ALT".equals(hotkey) || "CTRL".equals(hotkey) || "META".equals(hotkey)) {
            return hotkey;
        }
        return "ALT";
    }

    public static String appendLogsRoot(String fileName) {
        return Utils.concatPaths(Configuration.getPlayBackLogsRoot(), fileName);
    }

    public static boolean isDevMode() {
        return "true".equals(System.getProperty("sahi.mode.dev"));
    }

    public static boolean autoCreateSSLCertificates() {
        return "true".equals(Configuration.getUserProperty("ssl.auto_create_keystore"));
    }

    public static boolean isStrictVisibilityCheckEnabled() {
        return "true".equals(Configuration.getUserProperty("element.visibility_check.strict"));
    }

    public static String xhrReadyStatesToWaitFor() {
        return Configuration.getUserProperty("xhr.wait_ready_states", "2");
    }

    public static String getCertsPath() {
        return Utils.concatPaths(userDataDir, Configuration.getUserProperty("certs.dir", "certs"));
    }

    public static String getConfigPath() {
        return Utils.concatPaths(basePath, "config/");
    }

    public static String getToolsPath() {
        return Utils.concatPaths(basePath, "tools/");
    }

    public static String getKeytoolPath() {
        if (keytoolPath == null) {
            keytoolPath = Configuration.fixKeytoolPath();
        }
        return keytoolPath;
    }

    private static String fixKeytoolPath() {
        keytoolFound = true;
        String keytoolPath = Configuration.getUserProperty("keytool.path", "keytool");
        if (Configuration.isExecutable(keytoolPath)) {
            return keytoolPath;
        }
        keytoolPath = Utils.concatPaths(System.getProperty("java.home"), "bin/keytool");
        if (Configuration.isExecutable(keytoolPath)) {
            return keytoolPath;
        }
        keytoolFound = false;
        return keytoolPath;
    }

    public static boolean isKeytoolFound() {
        Configuration.getKeytoolPath();
        return keytoolFound;
    }

    private static boolean isExecutable(String keytoolPath) {
        try {
            Utils.executeCommand(new String[]{keytoolPath});
            System.out.println("Keytool command found at: " + keytoolPath);
            return true;
        }
        catch (Exception e) {
            System.out.println("Keytool command not found at: " + keytoolPath);
            return false;
        }
    }

    public static int getTimeBetweenSteps() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("script.time_between_steps"));
        }
        catch (Exception e) {
            return 100;
        }
    }

    public static void setTimeBetweenSteps(int speed) {
        userProperties.setProperty("script.time_between_steps", "" + speed);
    }

    public static int getTimeBetweenStepsOnError() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("script.time_between_steps_on_error"));
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public static int getMaxReAttemptsOnError() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("script.max_reattempts_on_error"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    public static int getMaxCyclesForPageLoad() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("script.max_cycles_for_page_load"));
        }
        catch (Exception e) {
            return 10;
        }
    }

    public static String[] getExclusionList() {
        if (exclusionList == null) {
            File file = new File(Utils.concatPaths(userDataDir, "config/exclude_inject.txt"));
            exclusionList = file.exists() ? Configuration.getNonBlankLines(Utils.readCachedFile(file)) : new String[]{};
        }
        return exclusionList;
    }

    public static String getDomainFixInfo() {
        if (domainFixInfo == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean start = true;
            File file = new File(Utils.concatPaths(userDataDir, "config/domainfix.txt"));
            String[] lines = file.exists() ? Configuration.getNonBlankLines(Utils.readCachedFile(file)) : new String[]{};
            for (int i = 0; i < lines.length; ++i) {
                String key;
                String line = lines[i];
                if (line.startsWith("#")) continue;
                String[] split = line.split("[\\s]+");
                String value = key = split[0];
                if (split.length == 1) {
                    value = split[1];
                } else {
                    int ix = value.lastIndexOf(".", value.lastIndexOf(".") - 1);
                    if (ix != -1) {
                        value = value.substring(ix + 1);
                    }
                }
                if (start) {
                    start = false;
                } else {
                    sb.append(",");
                }
                key = key.replace(".", "[.]").replace("*", ".*");
                sb.append("'" + key + "': '" + value + "'");
            }
            sb.append("}");
            domainFixInfo = sb.toString();
        }
        return domainFixInfo;
    }

    public static void enableKeepAlive() {
        ++enableKeepAlive;
    }

    public static void disableKeepAlive() {
        --enableKeepAlive;
    }

    public static int getRemoteSocketTimeout() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("proxy.remote_socket_timeout"));
        }
        catch (Exception e) {
            return 120000;
        }
    }

    public static boolean modifyActiveX() {
        return "true".equals(Configuration.getUserProperty("response.modify_activex"));
    }

    public static boolean spanVariablesAcrossSuite() {
        return "true".equals(Configuration.getUserProperty("suite.global_variables"));
    }

    public static int getMaxReAttemptsOnNotMyWindowError() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("script.max_reattempts_on_window_not_found_error"));
        }
        catch (Exception e) {
            return 30;
        }
    }

    public static Pattern getDownloadContentTypesRegExp() {
        String[] downloadables = Configuration.getNonBlankLines(Utils.readCachedFile(Utils.concatPaths(userDataDir, "config/download_contenttypes.txt")));
        if (downloadables.length != 0) {
            try {
                StringBuilder sb = new StringBuilder("(?:.*");
                for (int i = 0; i < downloadables.length; ++i) {
                    sb.append(downloadables[i]);
                    if (i == downloadables.length - 1) continue;
                    sb.append(".*)|(?:");
                }
                sb.append(".*)");
                return Pattern.compile(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Pattern.compile("");
    }

    public static String[] getDownloadURLList() {
        if (downloadURLList == null) {
            downloadURLList = Configuration.getNonBlankLines(Utils.readCachedFileIfExists(Utils.concatPaths(userDataDir, "config/download_urls.txt")));
        }
        return downloadURLList;
    }

    public static String[] getBlockableSSLDomainsList() {
        if (blockableSSLDomainList == null) {
            blockableSSLDomainList = Configuration.getNonBlankLines(Utils.readCachedFileIfExists(Utils.concatPaths(userDataDir, "config/block_ssl_domains.txt")));
        }
        return blockableSSLDomainList;
    }

    protected static String[] getNonBlankLines(byte[] b) {
        return Configuration.getNonBlankLines(new String(b));
    }

    protected static String[] getNonBlankLines(String s) {
        s = s.trim().replaceAll("\\\r", "");
        String[] tokens = s.split("\n");
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            if (token.equals("")) continue;
            l.add(token);
        }
        return l.toArray(new String[0]);
    }

    public static String tempDownloadDir() {
        return Utils.concatPaths(userDataDir, TMP_DOWNLOAD_DIR);
    }

    public static String getPIDListCommand() {
        return Configuration.getUserProperty("processhelper.pid_list_cmd", "");
    }

    public static String getPIDKillCommand() {
        return Configuration.getUserProperty("processhelper.pid_kill_cmd", "");
    }

    public static int getPIDListColumnNo() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("processhelper.pid_list_pid_column_no"));
        }
        catch (Exception e) {
            return 2;
        }
    }

    public static int getScriptMaxIdleTime() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("script.max_idle_time"));
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public static void setProxyProperties() {
        Properties systemProperties = System.getProperties();
        if (Configuration.isHttpProxyEnabled()) {
            systemProperties.setProperty("http.proxyHost", Configuration.getHttpProxyHost());
            systemProperties.setProperty("http.proxyPort", "" + Configuration.getHttpProxyPort());
            systemProperties.setProperty("http.nonProxyHosts", "" + Configuration.getHttpNonProxyHosts());
        }
        if (Configuration.isHttpsProxyEnabled()) {
            systemProperties.setProperty("https.proxyHost", Configuration.getHttpsProxyHost());
            systemProperties.setProperty("https.proxyPort", "" + Configuration.getHttpsProxyPort());
            systemProperties.setProperty("http.nonProxyHosts", "" + Configuration.getHttpsNonProxyHosts());
            systemProperties.setProperty("https.nonProxyHosts", "" + Configuration.getHttpsNonProxyHosts());
        }
    }

    public static boolean isHttpProxyEnabled() {
        return "true".equals(Configuration.getUserProperty("ext.http.proxy.enable"));
    }

    public static boolean isHttpsProxyEnabled() {
        return "true".equals(Configuration.getUserProperty("ext.https.proxy.enable"));
    }

    public static String getHttpProxyHost() {
        return Configuration.getUserProperty("ext.http.proxy.host");
    }

    public static String getHttpProxyPort() {
        return Configuration.getUserProperty("ext.http.proxy.port");
    }

    public static String getHttpNonProxyHosts() {
        return Configuration.getUserProperty("ext.http.both.proxy.bypass_hosts");
    }

    public static String getHttpProxyAuthName() {
        return Configuration.getUserProperty("ext.http.proxy.auth.name");
    }

    public static String getHttpProxyAuthPassword() {
        return Configuration.getUserProperty("ext.http.proxy.auth.password");
    }

    public static String getHttpsProxyPort() {
        return Configuration.getUserProperty("ext.https.proxy.port");
    }

    public static String getHttpsProxyHost() {
        return Configuration.getUserProperty("ext.https.proxy.host");
    }

    static String getHttpsNonProxyHosts() {
        return Configuration.getUserProperty("ext.http.both.proxy.bypass_hosts");
    }

    public static String getHttpsProxyAuthName() {
        return Configuration.getUserProperty("ext.https.proxy.auth.name");
    }

    public static String getHttpsProxyAuthPassword() {
        return Configuration.getUserProperty("ext.https.proxy.auth.password");
    }

    public static boolean isHttpProxyAuthEnabled() {
        return "true".equals(Configuration.getUserProperty("ext.http.proxy.auth.enable"));
    }

    public static boolean isHttpsProxyAuthEnabled() {
        return "true".equals(Configuration.getUserProperty("ext.https.proxy.auth.enable"));
    }

    public static boolean isModifiedTrafficLoggingOn() {
        return "true".equals(Configuration.getUserProperty("debug.traffic.log.modified"));
    }

    public static boolean isUnmodifiedTrafficLoggingOn() {
        return "true".equals(Configuration.getUserProperty("debug.traffic.log.unmodified"));
    }

    public static void setModifiedTrafficLogging(boolean flag) {
        userProperties.setProperty("debug.traffic.log.modified", "" + flag);
    }

    public static void setUnmodifiedTrafficLogging(boolean flag) {
        userProperties.setProperty("debug.traffic.log.unmodified", "" + flag);
    }

    public static void main(String[] args) {
        String[] scriptRoots = Configuration.getScriptRoots();
        System.out.println(scriptRoots[0]);
    }

    public static boolean downloadIfContentDispositionIsAttachment() {
        return "true".equals(Configuration.getUserProperty("download.download_if_contentdisposition_is_attachment"));
    }

    public static String getMimeTypesMappingFile() {
        return Utils.concatPaths(basePath, "config/mime-types.mapping");
    }

    public static String getAbsolutePath(String relPath) {
        return Utils.concatPaths(basePath, relPath);
    }

    public static String getAbsoluteTestDataPath(String relPath) {
        String testDataPath = Utils.concatPaths(basePath, "testdata");
        return Utils.concatPaths(testDataPath, relPath);
    }

    public static String getAbsoluteUserPath(String relPath) {
        return Utils.concatPaths(userDataDir, relPath);
    }

    public static int sampleLength() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("response.sample_length"));
        }
        catch (Exception e) {
            return 500;
        }
    }

    public static String getSSLClientCertPath() {
        String path = Configuration.getUserProperty("ssl.client.cert.path");
        if (path == null) {
            return null;
        }
        return Configuration.getAbsoluteUserPath(path);
    }

    private static String getUserProperty(String key) {
        return userProperties.getProperty(key);
    }

    private static String getUserProperty(String key, String defaultValue) {
        return userProperties.getProperty(key, defaultValue);
    }

    public static String getSSLClientCertPassword() {
        return Configuration.getUserProperty("ssl.client.cert.password");
    }

    public static String getSSLClientKeyStoreType() {
        return Configuration.getUserProperty("ssl.client.keystore.type", "JKS");
    }

    public static String getControllerMode() {
        if (overriddenControllerMode == null) {
            return Configuration.getUserProperty("controller.mode", "sahi");
        }
        return overriddenControllerMode;
    }

    public static void setControllerMode(String mode) {
        overriddenControllerMode = mode;
    }

    public static String getSSLAlgorithm() {
        return Configuration.getUserProperty("ssl.algorithm", "SunX509").trim();
    }

    public static String getInjectTop() {
        return Configuration.getAbsolutePath("config/inject_top.txt");
    }

    public static String getInjectBottom() {
        return Configuration.getAbsolutePath("config/inject_bottom.txt");
    }

    public static String getSSLCommandFile() {
        return Utils.concatPaths(Configuration.getConfigPath(), "ssl.txt");
    }

    public static String getJiraPropertyPath() {
        return Utils.concatPaths(userDataDir, "config/jira.properties");
    }

    public static String getUserDataDir() {
        return Utils.getAbsolutePath(userDataDir);
    }

    public static String getChangeLogFilePath() {
        return Utils.concatPaths(Configuration.getConfigPath(), "../docs/changelog.txt");
    }

    public static String getOSPropertiesFile() throws Exception {
        return Utils.concatPaths(Configuration.getConfigPath(), "os.properties");
    }

    public static String getVersion() {
        String path = Utils.concatPaths(Configuration.getConfigPath(), "version.txt");
        return new String(Utils.readCachedFile(path));
    }

    public static int getRhinoOptimizationLevel() {
        try {
            return Integer.parseInt(Configuration.getUserProperty("rhino.optimization_level"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getStabilityIndex() {
        try {
            int i = Integer.parseInt(Configuration.getUserProperty("script.stability_index"));
            if (i < 1) {
                i = 1;
            }
            return i;
        }
        catch (Exception e) {
            return 5;
        }
    }

    public static boolean getEscapeUnicode() {
        return "true".equals(Configuration.getUserProperty("script.escape_unicode"));
    }

    public static boolean addJSModifierFilter() {
        return !"false".equals(Configuration.getUserProperty("filters.addJSModifierFilter"));
    }

    public static boolean addHTMLModifierFilter() {
        return !"false".equals(Configuration.getUserProperty("filters.addHTMLModifierFilter"));
    }

    public static boolean addCharacterFilter() {
        return !"false".equals(Configuration.getUserProperty("filters.addCharacterFilter"));
    }

    public static String getCommonDomain() {
        return Configuration.getUserProperty("sahi.common_domain", "sahi.example.com").trim();
    }

    public static String getBrowserTypesPath() {
        return Configuration.getAbsoluteUserPath("config/browser_types.xml");
    }

    public static boolean getChromeExplicitCheckboxRadioToggle() {
        return "true".equals(Configuration.getUserProperty("simulation.chrome.explicit_checkbox_radio_toggle"));
    }

    public static String getIgnorableIdsPattern() {
        return Configuration.getUserProperty("recorder.ignorable_ids.pattern", "^z_").trim();
    }

    public static boolean forceTreatAsXHTML() {
        return "true".equals(Configuration.getUserProperty("sahi.inject.force_treat_as_xhtml"));
    }

    static {
        userDataDir = null;
        basePath = null;
        enableKeepAlive = 0;
    }
}

