/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.config;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.logging.Logger;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.RequestCredentials;
import net.sf.sahi.session.Session;
import net.sf.sahi.util.ThreadLocalMap;

public class SahiAuthenticator
extends Authenticator {
    private static final Logger logger = Logger.getLogger("net.sf.sahi.config.SahiAuthenticator");

    protected PasswordAuthentication getPasswordAuthentication() {
        logger.info("getRequestingProtocol() = " + this.getRequestingProtocol());
        String host = this.getRequestingHost();
        int port = this.getRequestingPort();
        if (this.getRequestingProtocol().startsWith("http") && Configuration.isHttpProxyEnabled() && Configuration.isHttpProxyAuthEnabled() && host.equals(Configuration.getHttpProxyHost()) && ("" + port).equals(Configuration.getHttpProxyPort())) {
            return new PasswordAuthentication(Configuration.getHttpProxyAuthName(), Configuration.getHttpProxyAuthPassword().toCharArray());
        }
        if (this.getRequestingProtocol().startsWith("http") && Configuration.isHttpsProxyEnabled() && Configuration.isHttpsProxyAuthEnabled() && host.equals(Configuration.getHttpsProxyHost()) && ("" + port).equals(Configuration.getHttpsProxyPort())) {
            return new PasswordAuthentication(Configuration.getHttpsProxyAuthName(), Configuration.getHttpsProxyAuthPassword().toCharArray());
        }
        Session session = (Session)ThreadLocalMap.get("session");
        if (session != null) {
            String realm = this.getRequestingPrompt();
            String scheme = this.getRequestingScheme();
            logger.info("realm=" + realm + "; getRequestingScheme()=" + scheme);
            RequestCredentials credentials = session.getMatchingCredentials(realm, scheme);
            if (credentials != null) {
                logger.info("Using credentials supplied: " + credentials);
                return new PasswordAuthentication(credentials.username(), credentials.password().toCharArray());
            }
            logger.fine("No credentials found. Should get prompt on browser.");
        }
        return null;
    }
}

