/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.playback;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.playback.SahiScriptHTMLAdapter;
import net.sf.sahi.playback.ScriptFactory;
import net.sf.sahi.report.LogViewer;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SahiScript {
    private static Logger logger = Configuration.getLogger("net.sf.sahi.playback.SahiScript");
    private static ArrayList<String> actionKeywords;
    private static ArrayList<String> normalKeywords;
    private static Pattern pattern_set;
    private static Pattern pattern_popup_set;
    protected String script;
    private static final String PREFIX = "_sahi.schedule(\"";
    private static final String CONJUNCTION = "\", \"";
    private static final String SUFFIX = "\");";
    private String filePath;
    protected String scriptName;
    protected ArrayList<String> parents;
    private String original = "";
    private static final Pattern REG_EXP_FOR_ADDING;
    private static final Pattern REG_EXP_FOR_STRIPPING;
    private static final Pattern REG_EXP_FOR_ACTIONS;
    protected String path;
    private String jsString;
    private String browserJS;
    private String browserJSWithLineNumbers;
    private ArrayList<String> lineDebugInfo = new ArrayList();

    public SahiScript(String filePath, ArrayList<String> parents, String scriptName) {
        this.filePath = filePath;
        this.scriptName = scriptName;
        this.parents = parents;
        this.init(filePath);
    }

    protected void setScript(String s) {
        this.original = s;
        this.browserJS = SahiScript.modifyFunctionNames(this.extractBrowserJS(s, false));
        this.browserJSWithLineNumbers = SahiScript.modifyFunctionNames(this.extractBrowserJS(s, true));
        this.script = this.jsString = this.modify(this.removeBrowserJS(s));
    }

    String removeBrowserJS(String s) {
        StringBuffer sb = new StringBuffer(s);
        int startIx = s.indexOf("<browser>");
        while (startIx != -1) {
            int endIx = s.indexOf("</browser>", startIx);
            endIx = endIx == -1 ? s.length() : (endIx += 10);
            String browserJSSnippet = s.substring(startIx, endIx);
            browserJSSnippet = browserJSSnippet.replaceAll("[^\\n]", " ");
            sb.replace(startIx, endIx, browserJSSnippet);
            startIx = s.indexOf("<browser>", endIx);
        }
        return sb.toString();
    }

    String extractBrowserJS(String s, boolean addLineNumberInfo) {
        StringBuffer sb = new StringBuffer(s);
        int startIx = 0;
        while (startIx != -1) {
            int endIx = s.indexOf("<browser>", startIx);
            endIx = endIx == -1 ? s.length() : (endIx += 9);
            String nonBrowserJSSnippet = s.substring(startIx, endIx);
            nonBrowserJSSnippet = nonBrowserJSSnippet.replaceAll("[^\\n]", " ");
            sb.replace(startIx, endIx, nonBrowserJSSnippet);
            startIx = s.indexOf("</browser>", endIx);
        }
        String js = sb.toString();
        if (!addLineNumberInfo) {
            return this.stripBlankLines(js);
        }
        return LogViewer.addLineNumbers(js, this.filePath);
    }

    private String stripBlankLines(String js) {
        String[] lines = js.split("\n");
        StringBuffer sb2 = new StringBuffer();
        for (String line : lines) {
            if ("".equals(line.trim())) continue;
            sb2.append(line + "\n");
        }
        return sb2.toString();
    }

    String extractBrowserJS2(String s, boolean addLineNumberInfo) {
        StringBuffer sb = new StringBuffer();
        int startIx = s.indexOf("<browser>");
        while (startIx != -1) {
            int endIx = s.indexOf("</browser>", startIx);
            if (endIx == -1) {
                endIx = s.length();
            }
            sb.append(s.substring(startIx + 9, endIx));
            sb.append("\n");
            startIx = s.indexOf("<browser>", endIx + 10);
        }
        String withoutLineNumbers = sb.toString();
        return withoutLineNumbers;
    }

    public String jsString() {
        return this.jsString;
    }

    static String addJSEvalCode(String str) {
        StringBuffer sb = new StringBuffer();
        sb.append("_sahi.execSteps = \"");
        sb.append(Utils.makeString(str));
        sb.append("\";\neval(_sahi.execSteps);");
        return sb.toString();
    }

    public String modifiedScript() {
        return this.script == null ? "" : this.script;
    }

    String modify(String s) {
        StringBuffer sb = new StringBuffer();
        s = this.normalizeNewLinesForOSes(s);
        Iterator<String> tokens = Utils.getTokens(s).iterator();
        int lineNumber = 0;
        while (tokens.hasNext()) {
            ++lineNumber;
            String line = tokens.next();
            if ("".equals(line)) continue;
            boolean isInclude = false;
            if ((line = line.trim()).startsWith("_include")) {
                SahiScript included = this.processInclude(line);
                if (included != null) {
                    sb.append(included.jsString);
                    this.browserJS = this.browserJS + included.browserJS;
                    this.browserJSWithLineNumbers = this.browserJSWithLineNumbers + included.browserJSWithLineNumbers;
                    this.lineDebugInfo.addAll(included.lineDebugInfo);
                    isInclude = true;
                }
            } else if (line.contains("_condition")) {
                sb.append(this.modifyCondition(line, lineNumber));
            } else if (line.startsWith("_wait")) {
                sb.append(this.modifyWait(line, lineNumber));
            } else if (this.isSet(line)) {
                sb.append(this.processSet(line, lineNumber));
            } else if (line.startsWith("_") && SahiScript.lineStartsWithActionKeyword(line)) {
                sb.append(this.scheduleLine(line, lineNumber));
            } else {
                sb.append(this.modifyLine(line));
            }
            if (isInclude) continue;
            this.lineDebugInfo.add(this.getDebugInfo(lineNumber));
        }
        String toString = sb.toString();
        logger.fine(toString);
        return toString;
    }

    String normalizeNewLinesForOSes(String s) {
        return s.replace("\r\n", "\n").replace("\r", "\n");
    }

    boolean isSet(String line) {
        return pattern_set.matcher(line).matches() || pattern_popup_set.matcher(line).matches();
    }

    String processSet(String line, int lineNumber) {
        String patternStr = "(.*)_set\\s*\\(\\s*([^,]*),\\s*(.*)\\)";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(line);
        boolean matchFound = matcher.find();
        if (!matchFound) {
            return this.modifyLine(line);
        }
        String popupPrefix = matcher.group(1);
        String varName = matcher.group(2);
        String varValue = matcher.group(3);
        StringBuffer sb = new StringBuffer();
        String tempVarName = varName.replaceAll("[$]", "\\\\\\$");
        sb.append(this.scheduleLine(popupPrefix + "_sahi.setServerVar('" + tempVarName + "', " + varValue + ");", lineNumber, true));
        sb.append(this.modifyLine(varName + " = _sahi.getServerVar('" + tempVarName + "');"));
        return sb.toString();
    }

    String modifyWait(String line, int lineNumber) {
        int comma = line.indexOf(",");
        if (comma == -1) {
            return this.convertToExecuteWait(this.scheduleLine(line, lineNumber));
        }
        StringBuffer sb = new StringBuffer();
        sb.append(line.substring(0, comma));
        sb.append(", ");
        int close = line.lastIndexOf(")");
        if (close == -1) {
            close = line.length();
        }
        sb.append("\"");
        sb.append(SahiScript.separateVariables(line.substring(comma + 1, close).trim()));
        sb.append(SUFFIX);
        return this.convertToExecuteWait(this.scheduleLine(sb.toString(), lineNumber));
    }

    private String convertToExecuteWait(String s) {
        return s.replaceFirst("_sahi[.]schedule", "_sahi.executeWait");
    }

    private String modifyLine(String line) {
        StringBuffer sb = new StringBuffer();
        sb.append(SahiScript.modifyFunctionNames(line));
        sb.append("\r\n");
        return sb.toString();
    }

    private String scheduleLine(String line, int lineNumber) {
        return this.scheduleLine(line, lineNumber, true);
    }

    private String scheduleLine(String line, int lineNumber, boolean separate) {
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX);
        if (separate) {
            line = SahiScript.separateVariables(line);
        }
        sb.append(SahiScript.modifyFunctionNames(line));
        sb.append(CONJUNCTION);
        sb.append(this.getDebugInfo(lineNumber));
        sb.append(SUFFIX);
        sb.append("\r\n");
        return sb.toString();
    }

    public String getDebugInfo(int lineNumber) {
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.escapeDoubleQuotesAndBackSlashes(this.getDebugFilePath()));
        sb.append("&n=");
        sb.append(lineNumber);
        return sb.toString();
    }

    protected String getDebugFilePath() {
        return this.filePath;
    }

    public String getLineDebugInfo(int lineNumber) {
        return lineNumber != -1 && lineNumber < this.lineDebugInfo.size() ? this.lineDebugInfo.get(lineNumber) : "";
    }

    public static boolean lineStartsWithActionKeyword(String line) {
        return REG_EXP_FOR_ACTIONS.matcher(line).matches();
    }

    public static String modifySingleLine(String line) {
        if (line.startsWith("_") && SahiScript.lineStartsWithActionKeyword(line)) {
            StringBuilder sb = new StringBuilder();
            sb.append(PREFIX);
            sb.append(SahiScript.modifyFunctionNames(SahiScript.separateVariables(line)));
            sb.append(SUFFIX);
            return sb.toString();
        }
        return SahiScript.modifyFunctionNames(line);
    }

    private SahiScript processInclude(String line) {
        String include = SahiScript.getInclude(line);
        if (include != null && !this.isRecursed(include)) {
            ArrayList clone = (ArrayList)this.parents.clone();
            clone.add(this.path);
            return new ScriptFactory().getScript(this.getFQN(include), clone);
        }
        return null;
    }

    private boolean isRecursed(String include) {
        return this.parents.contains(this.getFQN(include));
    }

    abstract String getFQN(String var1);

    static String getInclude(String line) {
        String re = ".*_include[\\s]*\\([\"|'](.*)[\"|']\\).*";
        Pattern p = Pattern.compile(".*_include[\\s]*\\([\"|'](.*)[\"|']\\).*");
        Matcher m = p.matcher(line.trim());
        if (m.matches()) {
            return line.substring(m.start(1), m.end(1));
        }
        return null;
    }

    static String getActionRegExp() {
        ArrayList<String> keywords = SahiScript.getActionKeyWords();
        return SahiScript.getActionRegExp(keywords);
    }

    static String getActionRegExp(ArrayList<String> keywords) {
        StringBuffer sb = new StringBuffer();
        int size = keywords.size();
        sb.append("^(?:");
        for (int i = 0; i < size; ++i) {
            String keyword = keywords.get(i);
            sb.append(keyword);
            if (i == size - 1) continue;
            sb.append("|");
        }
        sb.append(")\\s*\\(.*");
        return sb.toString();
    }

    public static String modifyFunctionNames(String unmodified) {
        unmodified = SahiScript.stripSahiFromFunctionNames(unmodified);
        return REG_EXP_FOR_ADDING.matcher(unmodified).replaceAll("_sahi.$1$2");
    }

    public static String stripSahiFromFunctionNames(String unmodified) {
        if (unmodified == null) {
            return "";
        }
        return REG_EXP_FOR_STRIPPING.matcher(unmodified).replaceAll("$1$2");
    }

    static String getRegExp(boolean isForStripping) {
        ArrayList<String> keywords = SahiScript.getKeyWords();
        return SahiScript.getRegExp(isForStripping, keywords);
    }

    static String getRegExp(boolean isForStripping, ArrayList<String> keywords) {
        StringBuffer sb = new StringBuffer();
        int size = keywords.size();
        if (isForStripping) {
            sb.append("_sahi.");
        }
        sb.append("_?(");
        for (int i = 0; i < size; ++i) {
            String keyword = keywords.get(i);
            sb.append(keyword);
            if (i == size - 1) continue;
            sb.append("|");
        }
        sb.append(")(\\s*\\()");
        return sb.toString();
    }

    public static ArrayList<String> getActionKeyWords() {
        if (actionKeywords == null) {
            actionKeywords = SahiScript.loadActionKeyWords();
        }
        return actionKeywords;
    }

    static ArrayList<String> loadActionKeyWords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.addAll(SahiScript.loadKeyWords("scheduler"));
        return keywords;
    }

    public static ArrayList<String> getKeyWords() {
        if (normalKeywords == null) {
            normalKeywords = SahiScript.loadKeyWords();
        }
        return normalKeywords;
    }

    static ArrayList<String> loadKeyWords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.addAll(SahiScript.loadKeyWords("scheduler"));
        keywords.addAll(SahiScript.loadKeyWords("normal"));
        return keywords;
    }

    static ArrayList<String> loadKeyWords(String type) {
        ArrayList<String> keywords = new ArrayList<String>();
        Properties fns = new Properties();
        try {
            String typePath = Utils.concatPaths(Configuration.getConfigPath(), type + "_functions.txt");
            fns.load(new FileInputStream(typePath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        keywords.addAll(fns.keySet());
        return keywords;
    }

    static String separateVariables(String s) {
        StringBuffer sb = new StringBuffer();
        char c = ' ';
        boolean isVar = false;
        boolean escaped = false;
        boolean doubleQuoted = false;
        boolean quoted = false;
        int len = s.length();
        int bracket = 0;
        int square = 0;
        for (int i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c == '\\') {
                escaped = !escaped;
            } else if (c == '\"') {
                if (!escaped && !quoted) {
                    doubleQuoted = !doubleQuoted;
                }
            } else if (c == '\'') {
                if (!escaped && !doubleQuoted) {
                    quoted = !quoted;
                }
            } else if (!(c != '$' || isVar || escaped || quoted || doubleQuoted || i + 1 >= len || !Character.isJavaIdentifierStart(s.charAt(i + 1)))) {
                isVar = true;
                bracket = 0;
                square = 0;
                sb.append("\"+s_v(");
            } else if (isVar && !escaped && !Character.isJavaIdentifierPart(c) && c != '.') {
                boolean append = false;
                if (!(escaped || quoted || doubleQuoted)) {
                    if (c == '(') {
                        ++bracket;
                    } else if (c == ')') {
                        if (--bracket < 0) {
                            append = true;
                        }
                    } else if (c == '[') {
                        ++square;
                    } else if (c == ']') {
                        if (--square < 0) {
                            append = true;
                        }
                    } else {
                        append = bracket <= 0 || c != ',' && !Character.isWhitespace(c) && c != '/';
                    }
                }
                if (append) {
                    sb.append(")+\"");
                    isVar = false;
                }
            }
            if (!(isVar || c != '\\' && c != '\"')) {
                sb.append('\\');
            }
            sb.append(c);
            if (c == 92) continue;
            escaped = false;
        }
        if (isVar) {
            sb.append(")+\"");
            isVar = false;
        }
        return sb.toString();
    }

    String findCondition(String s) {
        char c = ' ';
        boolean escaped = false;
        boolean doubleQuoted = false;
        boolean quoted = false;
        int len = s.length();
        int bracket = 0;
        int i = 0;
        i = s.indexOf("_condition");
        if ((i = s.indexOf("(", i) + 1) == 0) {
            return null;
        }
        int start = i;
        int end = -1;
        while (i < len) {
            c = s.charAt(i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
            }
            if (!escaped && !Character.isJavaIdentifierPart(c) && c != '.') {
                if (c == '\"') {
                    if (!escaped && !quoted) {
                        doubleQuoted = !doubleQuoted;
                    }
                } else if (c == '\'') {
                    if (!escaped && !doubleQuoted) {
                        quoted = !quoted;
                    }
                } else if (!(escaped || quoted || doubleQuoted)) {
                    if (c == '(') {
                        ++bracket;
                    } else if (c == ')' && --bracket < 0) {
                        end = i;
                        break;
                    }
                }
            }
            if (c != '\\') {
                escaped = false;
            }
            ++i;
        }
        if (end == -1) {
            return null;
        }
        return s.substring(start, end);
    }

    public String modifyCondition(String s, int lineNumber) {
        if (s.indexOf("_condition") == -1) {
            return this.modifyLine(s);
        }
        String condition = this.findCondition(s);
        if (condition == null) {
            return this.modifyLine(s);
        }
        StringBuffer sb = new StringBuffer();
        String prefix = s.substring(0, s.indexOf(condition));
        String suffix = s.substring(s.indexOf(condition) + condition.length());
        sb.append(prefix);
        String separated = "\"" + SahiScript.separateVariables(condition) + "\"";
        sb.append(separated);
        sb.append(", \"" + this.getDebugInfo(lineNumber) + "\"");
        sb.append(suffix);
        return SahiScript.modifyFunctionNames(sb.toString());
    }

    protected String read(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int c = 32;
        try {
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        catch (IOException ste) {
            ste.printStackTrace();
        }
        return new String(out.toByteArray());
    }

    public String getScriptName() {
        return this.scriptName;
    }

    protected void init(String url) {
        this.path = url;
        this.loadScript(url);
    }

    protected abstract void loadScript(String var1);

    public String getOriginal() {
        return this.original;
    }

    public String getOriginalInHTML() {
        return SahiScriptHTMLAdapter.createHTML(this.original);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getBrowserJS() {
        return this.browserJS;
    }

    public void addIncludeInfo(SahiScript included) {
        this.browserJS = this.browserJS + included.browserJS;
        this.browserJSWithLineNumbers = this.browserJSWithLineNumbers + included.browserJSWithLineNumbers;
        this.lineDebugInfo.addAll(included.lineDebugInfo);
    }

    public static void main(String[] args) {
        System.out.println("x" + "<browser>aaa\nbb\ncc\n</browser>".replaceAll("[^\\n]", "") + "y");
    }

    public String getBrowserJSWithLineNumbers() {
        return this.browserJSWithLineNumbers;
    }

    static {
        REG_EXP_FOR_ADDING = Pattern.compile(SahiScript.getRegExp(false));
        REG_EXP_FOR_STRIPPING = Pattern.compile(SahiScript.getRegExp(true));
        REG_EXP_FOR_ACTIONS = Pattern.compile(SahiScript.getActionRegExp());
        pattern_set = Pattern.compile("_set\\s*\\(.*");
        pattern_popup_set = Pattern.compile("_popup\\s*\\(.*\\)\\s*[.]\\s*_set\\s*\\(.*");
    }
}

