/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.record;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.sahi.config.Configuration;

public class Recorder {
    private FileOutputStream out;
    boolean isStarted = false;
    private static Logger logger = Configuration.getLogger("net.sf.sahi.record.Recorder");
    private File file = null;
    private String dir;

    public void start(String fileName) {
        logger.fine("Starting to write  to " + fileName + ".");
        if (this.isStarted) {
            return;
        }
        Configuration.createScriptsDirIfNeeded();
        this.file = new File(fileName).getAbsoluteFile();
        try {
            this.file.createNewFile();
            this.isStarted = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        logger.fine("Stopping.");
        if (!this.isStarted) {
            return;
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
            this.isStarted = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isRecording() {
        return this.isStarted;
    }

    public void record(String cmd) {
        if (!this.isStarted) {
            return;
        }
        if (cmd == null) {
            return;
        }
        if (this.file == null) {
            return;
        }
        logger.fine("Record:" + cmd);
        try {
            this.out = new FileOutputStream(this.file, true);
            this.out.write(cmd.getBytes("UTF8"));
            this.out.write("\n".getBytes());
            this.out.close();
            this.out = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDir() {
        return this.dir;
    }
}

