/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.sahi.request.HttpRequest;
import net.sf.sahi.request.MultiPartSubRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPartRequest {
    private final HttpRequest httpRequest;
    List<MultiPartSubRequest> subRequests;
    public String delimiter;

    public MultiPartRequest(HttpRequest httpRequest) throws IOException {
        this.httpRequest = httpRequest;
        this.populateSubParts();
    }

    private void populateSubParts() throws IOException {
        int nextIx;
        String dataStr = new String(this.httpRequest.data()).trim();
        this.delimiter = this.getDelimiter(dataStr);
        int prevIx = this.delimiter.length();
        this.subRequests = new ArrayList<MultiPartSubRequest>();
        while (prevIx + 1 < dataStr.length() && (nextIx = dataStr.indexOf(this.delimiter, prevIx + 1)) != -1) {
            String subReqStr = dataStr.substring(prevIx, nextIx).trim();
            MultiPartSubRequest multiPartSubRequest = new MultiPartSubRequest(new ByteArrayInputStream(subReqStr.getBytes()));
            this.subRequests.add(multiPartSubRequest);
            prevIx = nextIx + this.delimiter.length();
        }
    }

    private String getDelimiter(String dataStr) {
        return dataStr.substring(0, dataStr.indexOf("\n")).trim();
    }

    public HttpRequest getSimpleHttpRequest() {
        return this.httpRequest;
    }

    public List<MultiPartSubRequest> getMultiPartSubRequests() {
        return this.subRequests;
    }

    public final int contentLength() {
        return this.httpRequest.contentLength();
    }

    public final byte[] rawHeaders() {
        return this.httpRequest.rawHeaders();
    }

    public byte[] rawHeaders(byte[] bytes) {
        return this.httpRequest.setRawHeaders(bytes);
    }

    public String host() {
        return this.httpRequest.host();
    }

    public int port() {
        return this.httpRequest.port();
    }

    public boolean isPost() {
        return this.httpRequest.isPost();
    }

    public boolean isSSL() {
        return this.httpRequest.isSSL();
    }

    public String method() {
        return this.httpRequest.method();
    }

    public String uri() {
        return this.httpRequest.uri();
    }

    public String protocol() {
        return this.httpRequest.protocol();
    }

    public HttpRequest getRebuiltRequest() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] delimBytes = (this.delimiter + "\r\n").getBytes();
        try {
            Iterator<MultiPartSubRequest> iterator = this.subRequests.iterator();
            while (iterator.hasNext()) {
                out.write(delimBytes);
                MultiPartSubRequest part = iterator.next();
                part.resetRawHeaders();
                out.write(part.rawHeaders());
                out.write(part.data());
                out.write("\r\n".getBytes());
            }
            out.write((this.delimiter + "--\r\n").getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.httpRequest.setData(out.toByteArray());
        return this.httpRequest;
    }
}

