/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.response.MimeType;
import net.sf.sahi.util.Utils;

public class HttpFileResponse
extends HttpResponse {
    private String fileName;
    boolean addCacheHeader = false;

    public HttpFileResponse(String fileName, Properties substitutions, boolean addCacheHeader, boolean cacheFileInMemory) {
        this.fileName = fileName;
        byte[] bytes = cacheFileInMemory && !Configuration.isDevMode() ? Utils.readCachedFile(fileName) : Utils.readFile(fileName);
        this.setData(bytes);
        if (substitutions != null) {
            this.setData(Utils.substitute(new String(this.data()), substitutions).getBytes());
        }
        this.addCacheHeader = addCacheHeader;
        this.setHeaders();
    }

    public HttpFileResponse(String fileName) {
        this(fileName, null, false, false);
    }

    private void setHeaders() {
        this.setFirstLine("HTTP/1.1 200 OK");
        this.removeHeader("Content-Type");
        this.setHeader("Content-Type", MimeType.getMimeTypeOfFile(this.fileName));
        if (this.addCacheHeader) {
            this.setHeader("Expires", HttpFileResponse.formatForExpiresHeader(new Date(System.currentTimeMillis() + 600000L)));
        }
        this.setHeader("Content-Length", "" + this.data().length);
        this.setRawHeaders(this.getRebuiltHeaderBytes());
    }

    static String formatForExpiresHeader(Date date) {
        return new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss z").format(date);
    }
}

