/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.response;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.stream.filter.ReadWriteThread;
import net.sf.sahi.stream.filter.StreamFilter;
import net.sf.sahi.stream.filter.StreamFilterInputStream;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingHttpResponse
extends HttpResponse {
    protected BufferedInputStream in;
    private List<StreamFilter> filters = new ArrayList<StreamFilter>();
    private static ExecutorService pool = Executors.newCachedThreadPool();

    StreamingHttpResponse() {
    }

    public StreamingHttpResponse(InputStream in, HttpURLConnection connection) throws IOException {
        this.in = !(in instanceof BufferedInputStream) ? new BufferedInputStream(in, Utils.BUFFER_SIZE) : (BufferedInputStream)in;
        Map<String, List<String>> connheaders = connection.getHeaderFields();
        this.setHeaders(connection);
        List<String> firstLines = connheaders.get(null);
        if (firstLines != null) {
            for (String line : firstLines) {
                if (line.indexOf("HTTP") == -1) continue;
                this.firstLine = line;
            }
        }
        this.setContentLength(connection.getContentLength());
    }

    public StreamingHttpResponse(HttpResponse response) {
        this.copyFrom(response);
        this.in = new BufferedInputStream(new ByteArrayInputStream(response.data()), Utils.BUFFER_SIZE);
    }

    private void setHeaders(HttpURLConnection connection) {
        String key;
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            this.addHeader(key, connection.getHeaderField(i));
            ++i;
        }
    }

    @Override
    public byte[] data() {
        return new byte[0];
    }

    @Override
    int getModifiedContentLength() {
        return this.contentLength();
    }

    @Override
    public void modifyHeaders(boolean isKeepAlive) {
        this.proxyKeepAlive(isKeepAlive);
        this.modifyHeadersViaFilters(this);
        this.resetRawHeaders();
    }

    @Override
    public void sendBody(OutputStream out) throws IOException {
        BufferedOutputStream outputStreamToBrowser = new BufferedOutputStream(out, Utils.BUFFER_SIZE);
        int length = this.contentLength();
        this.pipe(this.in, outputStreamToBrowser, length);
        ((OutputStream)outputStreamToBrowser).flush();
    }

    public void copyFrom(StreamingHttpResponse orig) {
        this.in = orig.in;
        super.copyFrom(orig);
    }

    private InputStream applyFilters(InputStream in) {
        for (StreamFilter filter : this.filters) {
            in = new StreamFilterInputStream(in, filter);
        }
        return in;
    }

    private void modifyHeadersViaFilters(HttpResponse response) {
        for (StreamFilter filter : this.filters) {
            try {
                filter.modifyHeaders(response);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addFilter(StreamFilter filter) {
        this.filters.add(filter);
    }

    public List<StreamFilter> getFilters() {
        return this.filters;
    }

    private void pipe(InputStream in, OutputStream out, int contentLength) throws IOException {
        InputStream pin = new PipedInputStream();
        PipedOutputStream pout = new PipedOutputStream((PipedInputStream)pin);
        pin = this.applyFilters(pin);
        pool.execute(new ReadWriteThread(in, pout, contentLength, true, "Reader"));
        Future<?> future = pool.submit(new ReadWriteThread(pin, out, "Writer"));
        try {
            future.get();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void cleanUp() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

