/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.session;

import java.util.HashMap;
import java.util.Map;
import net.sf.sahi.util.Utils;

public class Status {
    private String name = null;
    private static final Map<String, Status> mapStatus = new HashMap<String, Status>();
    public static final Status RUNNING = new Status("RUNNING");
    public static final Status SUCCESS = new Status("SUCCESS");
    public static final Status FAILURE = new Status("FAILURE");
    public static final Status ABORTED = new Status("ABORTED");
    public static final Status ERROR = new Status("ERROR");
    public static final Status RETRY = new Status("RETRY");
    public static final Status INITIAL = new Status("INITIAL");
    public static final Status NOT_SUPPORTED = new Status("NOT_SUPPORTED");

    public String getName() {
        return this.name;
    }

    private Status(String name) {
        this.name = name;
        mapStatus.put(name, this);
    }

    public boolean isDone() {
        return this == FAILURE || this == SUCCESS || this == ERROR || this == ABORTED;
    }

    public boolean equals(String name) {
        return !Utils.isBlankOrNull(name) && this.name.equalsIgnoreCase(name);
    }

    public boolean equals(Object obj) {
        return obj != null && this.equals(((Status)obj).getName());
    }

    public String toString() {
        return this.name;
    }

    public static Status getStatus(String name) {
        return mapStatus.get(name.toUpperCase());
    }
}

