/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.stream.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.stream.filter.StreamFilter;

public class ChunkedFilter
extends StreamFilter {
    public byte[] modify(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return data;
        }
        ByteArrayOutputStream ar = new ByteArrayOutputStream();
        ar.write((Integer.toHexString(data.length) + "\r\n").getBytes());
        ar.write(data);
        ar.write("\r\n".getBytes());
        return ar.toByteArray();
    }

    public void modifyHeaders(HttpResponse response) throws IOException {
        response.removeHeader("Transfer-encoding");
        response.removeHeader("Content-Length");
        response.removeHeader("Content-length");
        response.setHeader("Transfer-Encoding", "chunked");
    }

    public byte[] getRemaining() {
        return (Integer.toHexString(0) + "\r\n\r\n").getBytes();
    }
}

