/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.stream.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.response.HttpResponse;
import net.sf.sahi.stream.filter.StreamFilter;

public class JSModifierFilter
extends StreamFilter {
    String last2Words = "";
    private final String charset;

    public JSModifierFilter(String charset) {
        this.charset = charset;
    }

    public byte[] modify(byte[] data) throws IOException {
        return this.substituteIEActiveX(data);
    }

    public String modify(String dataStr) {
        return this.replace(dataStr);
    }

    public void modifyHeaders(HttpResponse response) throws IOException {
    }

    byte[] substituteIEActiveX(byte[] data) {
        if (!Configuration.modifyActiveX()) {
            return data;
        }
        try {
            String dataStr = this.last2Words + new String(data, this.charset);
            dataStr = this.replace(dataStr);
            String dataStrCopy = dataStr.replace('\t', ' ');
            String newLast2Words = "";
            int ix1 = dataStrCopy.lastIndexOf(" ");
            int ix2 = -1;
            if (ix1 != -1 && (ix2 = dataStrCopy.lastIndexOf(" ", ix1 - 1)) == ix1 - 1) {
                while (true) {
                    int temp;
                    if ((temp = dataStrCopy.lastIndexOf(" ", ix2 - 1)) != ix2 - 1) {
                        ix2 = temp;
                        break;
                    }
                    ix2 = temp;
                }
            }
            if (ix2 != -1) {
                newLast2Words = dataStr.substring(ix2 + 1);
                dataStr = dataStr.substring(0, ix2 + 1);
            } else {
                newLast2Words = dataStr;
                dataStr = "";
            }
            this.last2Words = newLast2Words;
            byte[] modifiedBytes = dataStr.getBytes(this.charset);
            return modifiedBytes;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.last2Words = "";
            return data;
        }
    }

    public byte[] getRemaining() {
        try {
            return this.replace(this.last2Words).getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.last2Words.getBytes();
        }
    }

    private String replace(String toModify) {
        return toModify.replaceAll("new[\\s]*ActiveXObject", "new_ActiveXObject");
    }
}

