/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.issue.IssueCreator;
import net.sf.sahi.issue.IssueReporter;
import net.sf.sahi.report.Report;
import net.sf.sahi.report.SahiReporter;
import net.sf.sahi.rhino.RhinoScriptRunner;
import net.sf.sahi.rhino.ScriptRunner;
import net.sf.sahi.session.Session;
import net.sf.sahi.session.Status;
import net.sf.sahi.test.BrowserLauncher;
import net.sf.sahi.test.Culler;
import net.sf.sahi.test.SuiteLoader;
import net.sf.sahi.test.TestLauncher;
import net.sf.sahi.util.ProxySwitcher;
import net.sf.sahi.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SahiTestSuite {
    private final String suitePath;
    private final String base;
    private List<TestLauncher> tests = new ArrayList<TestLauncher>();
    private Map<String, TestLauncher> testsMap = new HashMap<String, TestLauncher>();
    private int currentTestIndex = 0;
    private final String sessionId;
    private final String browser;
    private String suiteName;
    private List<TestLauncher> finishedTests = new ArrayList<TestLauncher>();
    private List<SahiReporter> listReporter = new ArrayList<SahiReporter>();
    private IssueReporter issueReporter;
    private String browserOption;
    private int availableThreads = 0;
    private volatile boolean[] freeThreads;
    private boolean killed = false;
    private boolean isMultiThreaded;
    private String browserProcessName;
    private static HashMap<String, SahiTestSuite> suites = new HashMap();
    private HashMap<TestLauncher, TestLauncher> completed = new HashMap();
    private Map<String, String> variables;
    private long lastGenerationTime = 0L;
    private Semaphore lock = new Semaphore(1, true);
    private String extraInfo;
    private String initJS;
    private boolean useSystemProxy;
    private boolean isSingleSession;
    private String logFolderName;
    private String junitLogDir;
    private String htmlLogDir;
    private String tm6LogDir;
    private String singleSessionChildSessionId;
    private BrowserLauncher singleSessionBrowserLauncher;

    public SahiTestSuite(String suitePath, String base, String browser, String sessionId, String browseroption, String browserProcessName, boolean isSingleSession) {
        this.suitePath = suitePath;
        this.base = base;
        this.browser = browser;
        this.sessionId = Utils.stripChildSessionId(sessionId);
        this.singleSessionChildSessionId = Utils.addChildSessionId(sessionId);
        this.browserOption = browseroption;
        this.browserProcessName = browserProcessName;
        this.isSingleSession = isSingleSession;
        this.variables = new HashMap<String, String>();
        this.setSuiteName();
        this.logFolderName = Utils.createLogFileName(this.suiteName);
        suites.put(this.sessionId, this);
    }

    public Map<String, String> getInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("suitePath", this.suitePath);
        info.put("base", this.base);
        info.put("browser", this.browser);
        info.put("sessionId", this.sessionId);
        info.put("browserOption", this.browserOption);
        info.put("browserProcessName", this.browserProcessName);
        info.put("suiteName", this.suiteName);
        return info;
    }

    public String getInfoJSON() {
        Map<String, String> info = this.getInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int count = 0;
        Iterator<String> iterator = info.keySet().iterator();
        while (iterator.hasNext()) {
            if (count++ != 0) {
                sb.append(",");
            }
            String key = iterator.next();
            sb.append(key);
            sb.append(":");
            sb.append("\"" + Utils.makeString(info.get(key)) + "\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public void loadScripts() {
        this.tests = new SuiteLoader(this.suitePath, this.base).getListTest();
        System.out.println(">>>>>>                Tests size = " + this.tests.size());
        for (TestLauncher launcher : this.tests) {
            this.prepareTestLauncher(launcher);
            this.testsMap.put(launcher.getChildSessionId(), launcher);
        }
    }

    private void prepareTestLauncher(TestLauncher launcher) {
        launcher.setSessionId(this.sessionId, this.isSingleSession ? this.singleSessionChildSessionId : Utils.addChildSessionId(this.sessionId));
        launcher.setBrowser(this.browser);
        launcher.setBrowserOption(this.browserOption);
        launcher.setBrowserProcessName(this.browserProcessName);
        launcher.setIsSingleSession(this.isSingleSession);
    }

    public List<SahiReporter> getListReporter() {
        return this.listReporter;
    }

    public static SahiTestSuite getSuite(String sessionId) {
        return suites.get(Utils.stripChildSessionId(sessionId));
    }

    private void executeTest(int threadNo) throws Exception {
        TestLauncher test = this.tests.get(this.currentTestIndex);
        test.setThreadNo(threadNo, this.isMultiThreaded);
        Session session = Session.getInstance(test.getChildSessionId());
        session.touch();
        test.execute(session);
        ++this.currentTestIndex;
    }

    public void notifyComplete(TestLauncher launcher) {
        if (this.completed.containsKey(launcher)) {
            return;
        }
        try {
            Thread.sleep(Configuration.getTimeBetweenTestsInSuite());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.notifyComplete2(launcher);
        try {
            this.generateSuiteReport(this.finishedTests, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyComplete2(TestLauncher launcher) {
        if (this.completed.containsKey(launcher)) {
            return;
        }
        launcher.kill();
        SahiTestSuite sahiTestSuite = this;
        synchronized (sahiTestSuite) {
            try {
                this.completed.put(launcher, launcher);
                this.finishedTests.add(launcher);
                ++this.availableThreads;
                this.freeThreads[launcher.getThreadNo()] = true;
            }
            finally {
                this.notify();
            }
        }
    }

    private void setSuiteName() {
        this.suiteName = Utils.makePathOSIndependent(this.suitePath);
        int lastIndexOfSlash = this.suiteName.lastIndexOf("/");
        if (lastIndexOfSlash != -1) {
            this.suiteName = this.suiteName.substring(lastIndexOfSlash + 1);
        }
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    private void markSuiteStatus() {
        Status status = this.finishedTests.size() > 0 ? Status.SUCCESS : Status.FAILURE;
        for (TestLauncher testLauncher : this.tests) {
            RhinoScriptRunner scriptRunner = testLauncher.getScriptRunner();
            if (scriptRunner != null && !scriptRunner.hasErrors()) continue;
            status = Status.FAILURE;
            break;
        }
        Session session = Session.getInstance(this.sessionId);
        session.setStatus(status);
    }

    public void run() {
        Session session = Session.getInstance(this.sessionId);
        session.setStatus(Status.RUNNING);
        if (this.useSystemProxy) {
            ProxySwitcher.setSahiAsProxy();
        }
        new Thread(new Culler(this)).start();
        this.executeSuite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCallBack() {
        try {
            this.markSuiteStatus();
            this.generateSuiteReport(this.tests, true);
            this.createIssues();
            this.cullInactiveTests();
        }
        finally {
            if (this.useSystemProxy) {
                ProxySwitcher.revertSystemProxy();
            }
            suites.remove(this.sessionId);
        }
    }

    void cullInactiveTests() {
        Iterator<String> keys = this.testsMap.keySet().iterator();
        long now = System.currentTimeMillis();
        long inactivityLimit = Configuration.getMaxInactiveTimeForScript();
        while (keys.hasNext()) {
            String sessionId = keys.next();
            Session session = Session.getExistingInstance(sessionId);
            if (session == null) continue;
            long lastActiveTime = session.lastActiveTime();
            Status status = session.getStatus();
            if (status == Status.SUCCESS || status == Status.FAILURE || status == Status.INITIAL || now - lastActiveTime <= inactivityLimit) continue;
            String message = "*** Forcefully terminating script. \nNo response from browser within expected time (" + inactivityLimit / 1000L + " seconds).";
            System.out.println(message);
            ScriptRunner scriptRunner = session.getScriptRunner();
            scriptRunner.setStatus(Status.FAILURE);
            Report report = scriptRunner.getReport();
            if (report == null) continue;
            report.addResult(message, "ERROR", "", "");
        }
    }

    private void createIssues() {
        Session session = Session.getInstance(this.sessionId);
        if (Status.FAILURE.equals(session.getStatus()) && this.issueReporter != null) {
            this.issueReporter.reportIssue(this.tests);
        }
    }

    private synchronized void executeSuite() {
        try {
            this.launchBrowserForSingleSession();
        }
        catch (Exception e1) {
            this.abort();
            return;
        }
        while (this.currentTestIndex < this.tests.size()) {
            if (this.killed) {
                return;
            }
            while (this.availableThreads > 0 && this.currentTestIndex < this.tests.size()) {
                int freeThreadNo = this.getFreeThreadNo();
                if (freeThreadNo != -1) {
                    this.freeThreads[freeThreadNo] = false;
                    try {
                        this.executeTest(freeThreadNo);
                    }
                    catch (Exception e) {
                        this.abort();
                        return;
                    }
                }
                --this.availableThreads;
            }
            try {
                this.wait(600000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.killBrowserForSingleSession(false);
    }

    private void abort() {
        this.kill();
        this.finishCallBack();
    }

    public void launchBrowserForSingleSession() throws Exception {
        if (this.isSingleSession) {
            this.singleSessionBrowserLauncher = new BrowserLauncher(this.browser, this.browserProcessName, this.browserOption, this.useSystemProxy);
            this.singleSessionBrowserLauncher.openURL(this.singleSessionBrowserLauncher.getPlayerAutoURL(this.singleSessionChildSessionId, this.base, this.isSingleSession));
        }
    }

    public Status executeTestForSingleSession(String testName, String startURL) throws Exception {
        TestLauncher testLauncher = new TestLauncher(testName, startURL);
        this.prepareTestLauncher(testLauncher);
        testLauncher.setThreadNo(0, this.isMultiThreaded);
        Session session = Session.getInstance(testLauncher.getChildSessionId());
        session.touch();
        this.tests.add(testLauncher);
        testLauncher.execute(session, false, true);
        return testLauncher.getStatus();
    }

    public void killBrowserForSingleSession(boolean isSingleTest) {
        if (this.isSingleSession) {
            this.singleSessionBrowserLauncher.kill();
            if (isSingleTest) {
                this.finishCallBack();
            }
        }
    }

    private int getFreeThreadNo() {
        for (int i = 0; i < this.freeThreads.length; ++i) {
            if (!this.freeThreads[i]) continue;
            return i;
        }
        return -1;
    }

    private void generateSuiteReport(List<TestLauncher> listOfTests, boolean force) {
        try {
            if (force) {
                this.lock.acquire();
            } else {
                long now = System.currentTimeMillis();
                if (now - this.lastGenerationTime < 5000L) {
                    return;
                }
                this.lastGenerationTime = now;
                if (!this.lock.tryAcquire()) {
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            for (SahiReporter reporter : this.listReporter) {
                reporter.generateSuiteReport(listOfTests);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lock.release();
    }

    public void setAvailableThreads(int availableThreads) {
        this.availableThreads = availableThreads;
        this.isMultiThreaded = availableThreads > 1;
        this.freeThreads = new boolean[availableThreads];
        int len = this.freeThreads.length;
        for (int i = 0; i < len; ++i) {
            this.freeThreads[i] = true;
        }
    }

    public void addReporter(SahiReporter reporter) {
        reporter.setSuiteName(this.suiteName);
        this.listReporter.add(reporter);
    }

    public void addIssueCreator(IssueCreator issueCreator) {
        if (this.issueReporter == null) {
            this.issueReporter = new IssueReporter(this.suiteName);
        }
        this.issueReporter.addIssueCreator(issueCreator);
    }

    synchronized boolean isRunning() {
        return this.finishedTests.size() < this.tests.size() && !this.killed;
    }

    public void kill() {
        System.out.println("Shutting down ...");
        this.killed = true;
    }

    public String getVariable(String name) {
        return this.variables.get(name);
    }

    public void removeVariables(String pattern) {
        Iterator<String> iterator = this.variables.keySet().iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.matches(pattern)) continue;
            iterator.remove();
        }
    }

    public void setVariable(String name, String value) {
        this.variables.put(name, value);
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setInitJS(String initJS) {
        this.initJS = initJS;
    }

    public String getInitJS() {
        return this.initJS;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
    }

    public String getLogFolderName() {
        return this.logFolderName;
    }

    public void setJunitLogDir(String logDir) {
        this.junitLogDir = logDir;
    }

    public String getJunitLogDir() {
        return this.junitLogDir;
    }

    public void setHtmlLogDir(String logDir) {
        this.htmlLogDir = logDir;
    }

    public String getHtmlLogDir() {
        return this.htmlLogDir;
    }

    public void setTM6LogDir(String logDir) {
        this.tm6LogDir = logDir;
    }

    public String getTM6LogDir() {
        return this.tm6LogDir;
    }
}

