/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;

public class SocketPool {
    private final List<Integer> unused = new LinkedList<Integer>();
    private static int START_PORT = 13300;
    private int lastPort;

    public SocketPool(int size) {
        for (int i = 0; i < size; ++i) {
            this.returnToPool(START_PORT + i);
        }
        this.lastPort = START_PORT + size;
    }

    private Socket createSocket(int port) throws IOException {
        Socket socket = new Socket();
        try {
            socket.setSoLinger(true, 0);
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress(port));
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket get() throws IOException {
        Socket socket;
        List<Integer> list = this.unused;
        synchronized (list) {
            while (this.unused.isEmpty()) {
                try {
                    System.out.println("Waiting for socket");
                    this.unused.wait();
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted!");
                }
            }
            int port = this.unused.remove(0);
            socket = this.createSocket(port);
        }
        return socket;
    }

    public Socket get(String host, int port) throws IOException {
        Socket socket = this.get();
        try {
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (BindException e) {
            e.printStackTrace();
            ++this.lastPort;
            System.out.println("### Creating New Socket : " + this.lastPort);
            socket = this.createSocket(this.lastPort);
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            System.out.println("Error while connecting to " + host + ":" + port);
            this.release(socket);
            throw e;
        }
        return socket;
    }

    public void release(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.returnToPool(socket.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnToPool(int port) {
        List<Integer> list = this.unused;
        synchronized (list) {
            this.unused.add(new Integer(port));
            this.unused.notifyAll();
        }
    }
}

