/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.sf.sahi.config.Configuration;
import net.sf.sahi.util.Utils;

public class URLParser {
    public static String logFileNamefromURI(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String fileName = URLParser.getRelativeLogFile(uri);
        if ("".equals(fileName)) {
            return "";
        }
        return Configuration.appendLogsRoot(fileName);
    }

    static String getRelativeLogFile(String uri) {
        String fileName = uri.substring(uri.indexOf("Log_viewLogs") + "Log_viewLogs".length());
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    public static String fileNamefromURI(String uri) {
        int questionIndex = uri.indexOf("?");
        if (questionIndex == -1) {
            questionIndex = uri.length();
        }
        return Utils.concatPaths(Configuration.getHtdocsRoot(), uri.substring(uri.indexOf("_s_/") + 4, questionIndex));
    }

    public static String scriptFileNamefromURI(String uri, String token) {
        int endIndex = uri.indexOf("?");
        endIndex = endIndex == -1 ? uri.length() : endIndex;
        String fileName = uri.substring(uri.lastIndexOf(token) + token.length(), endIndex);
        return Utils.concatPaths(Configuration.getScriptRoots()[0], fileName);
    }

    public static String getCommandFromUri(String uri, String initialToken) {
        int ix1 = uri.indexOf(initialToken);
        if (ix1 == -1) {
            return null;
        }
        int ix2 = uri.indexOf("/", ix1 += initialToken.length());
        int ix3 = uri.indexOf("?", ix1);
        int endIx = -1;
        if (ix2 > -1 && ix3 == -1) {
            endIx = ix2;
        } else if (ix3 > -1 && ix2 == -1) {
            endIx = ix3;
        } else {
            int n = endIx = ix3 < ix2 ? ix3 : ix2;
        }
        if (endIx == -1) {
            endIx = uri.length();
        }
        return uri.substring(ix1, endIx);
    }
}

