/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLDelete
extends ExtensionInstruction {
    Expression connection;
    String table;
    Expression where;

    public void prepareAttributes() throws XPathException {
        String string;
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        this.where = (string = this.getAttributeList().getValue("", "where")) == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(string);
        String string2 = this.getAttributeList().getValue("", "connection");
        if (string2 == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string2);
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable executable) throws XPathException {
        return new DeleteInstruction(this.connection, "DELETE FROM " + this.table, this.where);
    }

    private static class DeleteInstruction
    extends SimpleExpression {
        private static final long serialVersionUID = -4234440812734827279L;
        public static final int CONNECTION = 0;
        public static final int WHERE = 1;
        String statement;

        public DeleteInstruction(Expression expression, String string, Expression expression2) {
            Expression[] expressionArray = new Expression[]{expression, expression2};
            this.statement = string;
            this.setArguments(expressionArray);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:delete";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            Item item = this.arguments[0].evaluateItem(xPathContext);
            if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", xPathContext);
            }
            Connection connection = (Connection)((ObjectValue)item).getObject();
            PreparedStatement preparedStatement = null;
            String string = this.arguments[1].evaluateAsString(xPathContext);
            String string2 = this.statement;
            if (!string.equals("")) {
                string2 = string2 + " WHERE " + string;
            }
            try {
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException sQLException) {
                this.dynamicError("SQL DELETE failed: " + sQLException.getMessage(), "SXSQ0004", xPathContext);
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return null;
        }
    }
}

