/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xom.DocumentWrapper;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;

public class XomUriResolver
extends StandardURIResolver {
    public XomUriResolver(Configuration configuration) {
        super(configuration);
    }

    public Source resolve(String string, String string2) throws XPathException {
        URI uRI;
        String string3 = string;
        String string4 = null;
        int n = string.indexOf(35);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        try {
            string3 = ResolveURI.escapeSpaces((String)string3);
            URI uRI2 = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DynamicError("Invalid relative URI " + Err.wrap((CharSequence)string3), (Throwable)uRISyntaxException);
        }
        JavaPlatform javaPlatform = JavaPlatform.getInstance();
        try {
            uRI = javaPlatform.makeAbsolute(string3, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string5 = ResolveURI.tryToExpand((String)string2);
            if (!string5.equals(string2)) {
                return this.resolve(string, string5);
            }
            throw new DynamicError("Invalid URI " + Err.wrap((CharSequence)string3) + " - base " + Err.wrap((CharSequence)string2), (Throwable)uRISyntaxException);
        }
        try {
            Builder builder = new Builder();
            Document document = builder.build(uRI.toString());
            if (this.getConfiguration() == null) {
                throw new DynamicError("XomUriResolver requires access to the Configuration");
            }
            DocumentWrapper documentWrapper = new DocumentWrapper((Node)document, uRI.toString(), this.getConfiguration());
            return documentWrapper;
        }
        catch (IOException iOException) {
            throw new DynamicError((Throwable)iOException);
        }
        catch (ParsingException parsingException) {
            throw new DynamicError((Throwable)parsingException);
        }
    }

    protected Source getPTreeSource(String string, String string2) throws XPathException {
        return null;
    }
}

