/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.dom.DOMWriter;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMObjectModel
implements ExternalObjectModel,
Serializable {
    private static DOMObjectModel THE_INSTANCE = new DOMObjectModel();
    private static Method nextSiblingMethod;
    private static boolean nextSiblingMethodUnavailable;

    public static DOMObjectModel getInstance() {
        return THE_INSTANCE;
    }

    public String getIdentifyingURI() {
        return "http://java.sun.com/jaxp/xpath/dom";
    }

    public PJConverter getPJConverter(Class targetClass) {
        if (Node.class.isAssignableFrom(targetClass) && !NodeOverNodeInfo.class.isAssignableFrom(targetClass)) {
            return new PJConverter(){

                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMObjectModel.this.convertXPathValueToObject(Value.asValue((ValueRepresentation)value), targetClass, context);
                }
            };
        }
        if (NodeList.class == targetClass) {
            return new PJConverter(){

                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMObjectModel.this.convertXPathValueToObject(Value.asValue((ValueRepresentation)value), targetClass, context);
                }
            };
        }
        return null;
    }

    public JPConverter getJPConverter(Class targetClass) {
        if (Node.class.isAssignableFrom(targetClass) && !NodeOverNodeInfo.class.isAssignableFrom(targetClass)) {
            return new JPConverter(){

                public ValueRepresentation convert(Object obj, XPathContext context) throws XPathException {
                    return DOMObjectModel.this.wrapOrUnwrapNode((Node)obj, context.getConfiguration());
                }

                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        if (NodeList.class.isAssignableFrom(targetClass)) {
            return new JPConverter(){

                public ValueRepresentation convert(Object obj, XPathContext context) throws XPathException {
                    Configuration config = context.getConfiguration();
                    NodeList list = (NodeList)obj;
                    int len = list.getLength();
                    NodeInfo[] nodes = new NodeInfo[len];
                    for (int i = 0; i < len; ++i) {
                        nodes[i] = DOMObjectModel.this.wrapOrUnwrapNode(list.item(i), config);
                    }
                    return new SequenceExtent((Item[])nodes);
                }

                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }

                public int getCardinality() {
                    return 57344;
                }
            };
        }
        return null;
    }

    public PJConverter getNodeListCreator(Object node) {
        if (node == null || node instanceof Node || node instanceof DOMSource || node instanceof VirtualNode && ((VirtualNode)node).getUnderlyingNode() instanceof Node) {
            return new PJConverter(){

                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMObjectModel.this.convertXPathValueToObject(Value.asValue((ValueRepresentation)value), class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = DOMObjectModel.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList, context);
                }
            };
        }
        return null;
    }

    public Receiver getDocumentBuilder(Result result) throws XPathException {
        if (result instanceof DOMResult) {
            DOMWriter emitter = new DOMWriter();
            Node root = ((DOMResult)result).getNode();
            Node nextSibling = null;
            if (!nextSiblingMethodUnavailable) {
                try {
                    nextSibling = (Node)nextSiblingMethod.invoke((Object)result, new Object[0]);
                }
                catch (IllegalAccessException err) {
                }
                catch (InvocationTargetException err) {
                    // empty catch block
                }
            }
            if (root == null) {
                try {
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                    Document out = docBuilder.newDocument();
                    ((DOMResult)result).setNode(out);
                    emitter.setNode(out);
                }
                catch (ParserConfigurationException e) {
                    throw new XPathException((Throwable)e);
                }
            } else {
                emitter.setNode(root);
                emitter.setNextSibling(nextSibling);
            }
            return emitter;
        }
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        if (source instanceof DOMSource) {
            Node startNode = ((DOMSource)source).getNode();
            DOMSender driver = new DOMSender();
            driver.setStartNode(startNode);
            driver.setReceiver(receiver);
            driver.setPipelineConfiguration(pipe);
            driver.setSystemId(source.getSystemId());
            driver.send();
            return true;
        }
        return false;
    }

    public NodeInfo unravel(Source source, Configuration config) {
        Node dsnode;
        if (source instanceof DOMSource && !((dsnode = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo)) {
            Document dom = dsnode.getNodeType() == 9 ? (Document)dsnode : dsnode.getOwnerDocument();
            DocumentWrapper docWrapper = new DocumentWrapper((Node)dom, source.getSystemId(), config);
            return docWrapper.wrap(dsnode);
        }
        return null;
    }

    private NodeInfo wrapOrUnwrapNode(Node node, Configuration config) throws XPathException {
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        DocumentInfo doc = this.wrapDocument(node, "", config);
        return this.wrapNode(doc, node);
    }

    private Object convertXPathValueToObject(Value value, Object targetClass, XPathContext context) throws XPathException {
        Item item;
        boolean allowDOM;
        Class target;
        boolean requireDOM = Node.class.isAssignableFrom(target = (Class)targetClass) || target == NodeList.class || target.isArray() && Node.class.isAssignableFrom(target.getComponentType());
        boolean bl = target == Object.class || target.isAssignableFrom(ArrayList.class) || target.isAssignableFrom(HashSet.class) || target.isArray() && target.getComponentType() == Object.class ? true : (allowDOM = false);
        if (!requireDOM && !allowDOM) {
            return null;
        }
        ArrayList<Object> nodes = new ArrayList<Object>(20);
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getUnderlyingNode();
                if (o instanceof Node) {
                    nodes.add(o);
                    continue;
                }
                if (!requireDOM) continue;
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                err.setXPathContext(context);
                throw err;
            }
            if (requireDOM) {
                if (item instanceof NodeInfo) {
                    nodes.add(NodeOverNodeInfo.wrap((NodeInfo)item));
                    continue;
                }
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                err.setXPathContext(context);
                throw err;
            }
            return null;
        }
        if (nodes.isEmpty() && !requireDOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(target)) {
            if (nodes.size() != 1) {
                XPathException err = new XPathException("Extension function requires a single DOM Node; supplied value contains " + nodes.size() + " nodes");
                err.setXPathContext(context);
                throw err;
            }
            return nodes.get(0);
        }
        if (target == NodeList.class) {
            return new DOMNodeList(nodes);
        }
        if (target.isArray() && target.getComponentType() == Node.class) {
            Node[] array = new Node[nodes.size()];
            nodes.toArray(array);
            return array;
        }
        if (target.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (target.isAssignableFrom(HashSet.class)) {
            return new HashSet(nodes);
        }
        return null;
    }

    private DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        if (node instanceof DocumentOverNodeInfo) {
            return (DocumentInfo)((DocumentOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo().getDocumentRoot();
        }
        if (node instanceof Node) {
            if (((Node)node).getNodeType() == 9) {
                Document doc = (Document)node;
                return new DocumentWrapper((Node)doc, baseURI, config);
            }
            if (((Node)node).getNodeType() == 11) {
                DocumentFragment doc = (DocumentFragment)node;
                return new DocumentWrapper((Node)doc, baseURI, config);
            }
            Document doc = ((Node)node).getOwnerDocument();
            return new DocumentWrapper((Node)doc, baseURI, config);
        }
        throw new IllegalArgumentException("Unknown node class " + node.getClass());
    }

    private NodeInfo wrapNode(DocumentInfo document, Object node) {
        return ((DocumentWrapper)document).wrap((Node)node);
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.newDocument();
        XPathEvaluator xpe = new XPathEvaluator();
        String exp = "ext:sortArrayToNodeList(('fred', 'jane', 'anne', 'sue'))";
        xpe.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                return prefix.equals("ext") ? "java:net.sf.saxon.dom.DOMObjectModel" : null;
            }

            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
        NodeList isList = (NodeList)xpe.evaluate(exp, (Object)doc, XPathConstants.NODESET);
        System.err.println("length " + isList.getLength());
    }

    public static NodeList sortArrayToNodeList(Value source) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.newDocument();
        Object[] items = new String[source.getLength()];
        for (int i = 0; i < source.getLength(); ++i) {
            items[i] = source.itemAt(i).getStringValue();
        }
        Arrays.sort(items);
        ArrayList<Text> list = new ArrayList<Text>();
        for (int i = 0; i < items.length; ++i) {
            list.add(doc.createTextNode((String)items[i]));
        }
        DOMNodeList resultSet = new DOMNodeList(list);
        return resultSet;
    }

    static {
        nextSiblingMethodUnavailable = false;
        try {
            nextSiblingMethod = DOMResult.class.getMethod("getNextSibling", new Class[0]);
        }
        catch (NoSuchMethodException err) {
            nextSiblingMethodUnavailable = true;
        }
    }
}

