/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;

public class ItemType {
    public static ItemType ANY_ITEM = new ItemType((net.sf.saxon.type.ItemType)AnyItemType.getInstance(), null){

        public boolean matches(XdmItem item) {
            return true;
        }

        public boolean subsumes(ItemType other) {
            return true;
        }
    };
    public static ItemType ANY_NODE = new ItemType((net.sf.saxon.type.ItemType)AnyNodeTest.getInstance(), null){

        public boolean matches(XdmItem item) {
            return item.getUnderlyingValue() instanceof NodeInfo;
        }

        public boolean subsumes(ItemType other) {
            return other.getUnderlyingItemType() instanceof NodeTest;
        }
    };
    public static ItemType ANY_ATOMIC_VALUE = new ItemType((net.sf.saxon.type.ItemType)BuiltInAtomicType.ANY_ATOMIC, null){

        public boolean matches(XdmItem item) {
            return item.getUnderlyingValue() instanceof AtomicValue;
        }

        public boolean subsumes(ItemType other) {
            return other.getUnderlyingItemType() instanceof AtomicType;
        }
    };
    private net.sf.saxon.type.ItemType underlyingType;
    private Processor processor;

    protected ItemType(net.sf.saxon.type.ItemType underlyingType, Processor processor) {
        this.processor = processor;
        this.underlyingType = underlyingType;
    }

    public boolean matches(XdmItem item) {
        return this.underlyingType.matchesItem((Item)item.getUnderlyingValue(), false, this.processor.getUnderlyingConfiguration());
    }

    public boolean subsumes(ItemType other) {
        TypeHierarchy th = this.processor.getUnderlyingConfiguration().getTypeHierarchy();
        return th.isSubType(other.getUnderlyingItemType(), this.underlyingType);
    }

    public net.sf.saxon.type.ItemType getUnderlyingItemType() {
        return this.underlyingType;
    }

    protected Processor getProcessor() {
        return this.processor;
    }
}

