/*
 * Decompiled with CFR 0.152.
 */
package scalariform.lexer;

import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.collection.BufferedIterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalariform.lexer.InEndTag$;
import scalariform.lexer.InStartTag$;
import scalariform.lexer.Normal$;
import scalariform.lexer.ScalaLexer;
import scalariform.lexer.ScalaLexerException;
import scalariform.lexer.TagState;
import scalariform.lexer.Tokens$;

public abstract class XmlLexer$class {
    private static boolean tagMode(ScalaLexer $this) {
        return $this.xmlMode().isTagMode();
    }

    private static void tagMode_$eq(ScalaLexer $this, boolean isTagMode) {
        $this.xmlMode().isTagMode_$eq(isTagMode);
    }

    private static boolean moreXmlToCome(ScalaLexer $this) {
        BufferedIterator newReader = $this.reader().copy().buffered();
        while (BoxesRunTime.unboxToChar((Object)newReader.head()) != '\u001a' && $this.isSpace(BoxesRunTime.unboxToChar((Object)newReader.head()))) {
            newReader.next();
        }
        return PartialFunction$.MODULE$.cond((Object)newReader.take(2).toList(), new PartialFunction($this){
            public static final long serialVersionUID;
            private final ScalaLexer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public <A1 extends List<Object>, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                return PartialFunction.class.orElse((PartialFunction)this, that);
            }

            public <C> PartialFunction<List<Object>, C> andThen(Function1<Object, C> k) {
                return PartialFunction.class.andThen((PartialFunction)this, k);
            }

            public Function1<List<Object>, Option<Object>> lift() {
                return PartialFunction.class.lift((PartialFunction)this);
            }

            public boolean apply$mcZD$sp(double v1) {
                return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
            }

            public <A> Function1<A, Object> compose(Function1<A, List<Object>> g) {
                return Function1.class.compose((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcID$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJD$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVD$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcIF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJF$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVF$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcII$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJI$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVI$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcZJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcDJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcFJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcIJ$sp((Function1)this, g);
            }

            public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcJJ$sp((Function1)this, g);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> g) {
                return Function1.class.compose$mcVJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcID$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVD$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcIF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVF$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcII$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVI$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcZJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcDJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcFJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcIJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> g) {
                return Function1.class.andThen$mcJJ$sp((Function1)this, g);
            }

            public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> g) {
                return Function1.class.andThen$mcVJ$sp((Function1)this, g);
            }

            public String toString() {
                return Function1.class.toString((Function1)this);
            }

            public final boolean apply(List<Object> list) {
                List<Object> list2 = list;
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    if (colon2 != null) {
                        char c = BoxesRunTime.unboxToChar((Object)colon2.hd$1());
                        List list3 = colon2.tl$1();
                        if (list3 instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list3;
                            char c2 = BoxesRunTime.unboxToChar((Object)colon3.hd$1());
                            Nil$ nil$ = Nil$.MODULE$;
                            List list4 = colon3.tl$1();
                            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                                return c == '<' && this.$outer.isNameStart(c2);
                            }
                            throw new MatchError(list2);
                        }
                        throw new MatchError(list2);
                    }
                    throw new MatchError(list2);
                }
                throw new MatchError(list2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> list) {
                List<Object> list2 = list;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list2;
                if (colon2 == null) return false;
                List list3 = colon2.tl$1();
                if (!(list3 instanceof .colon.colon)) return false;
                Nil$ nil$ = Nil$.MODULE$;
                List list4 = ((.colon.colon)list3).tl$1();
                if (nil$ != null) {
                    if (!nil$.equals(list4)) return false;
                    return true;
                }
                if (list4 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        });
    }

    public static void fetchXmlToken(ScalaLexer $this) {
        char c = $this.ch();
        switch (c) {
            default: {
                if (XmlLexer$class.tagMode($this) && $this.isNameStart($this.ch())) {
                    XmlLexer$class.getXmlName($this);
                    break;
                }
                if (XmlLexer$class.tagMode($this) && $this.isSpace($this.ch())) {
                    XmlLexer$class.getXmlSpace($this);
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '>': {
                if (XmlLexer$class.tagMode($this)) {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.XML_TAG_CLOSE());
                    $this.xmlMode().isTagMode_$eq(false);
                    TagState tagState = $this.xmlMode().tagState();
                    InStartTag$ inStartTag$ = InStartTag$.MODULE$;
                    TagState tagState2 = tagState;
                    if (!(inStartTag$ != null ? !inStartTag$.equals(tagState2) : tagState2 != null)) {
                        $this.xmlMode().nestTag();
                        break;
                    }
                    InEndTag$ inEndTag$ = InEndTag$.MODULE$;
                    TagState tagState3 = tagState;
                    if (!(inEndTag$ != null ? !inEndTag$.equals(tagState3) : tagState3 != null)) {
                        int nestingLevel = $this.xmlMode().unnestTag();
                        if (nestingLevel != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    Normal$ normal$ = Normal$.MODULE$;
                    TagState tagState4 = tagState;
                    if (!(normal$ != null ? !normal$.equals(tagState4) : tagState4 != null)) {
                        throw new AssertionError((Object)"shouldn't reach here");
                    }
                    throw new MatchError((Object)tagState);
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '/': {
                if (XmlLexer$class.tagMode($this)) {
                    if ($this.ch(1) == '>') {
                        $this.nextChar();
                        $this.nextChar();
                        $this.token(Tokens$.MODULE$.XML_EMPTY_CLOSE());
                        $this.xmlMode().isTagMode_$eq(false);
                        $this.xmlMode().tagState_$eq(Normal$.MODULE$);
                        if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    XmlLexer$class.getXmlCharData($this);
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '\u001a': {
                $this.token(Tokens$.MODULE$.EOF());
                break;
            }
            case '{': {
                if ($this.ch(1) != '{') {
                    $this.switchToScalaModeAndFetchToken();
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '\'': {
                if (XmlLexer$class.tagMode($this)) {
                    XmlLexer$class.getXmlAttributeValue($this, '\'');
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '\"': {
                if (XmlLexer$class.tagMode($this)) {
                    XmlLexer$class.getXmlAttributeValue($this, '\"');
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '<': {
                if ($this.ch(1) == '/') {
                    $this.nextChar();
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.XML_END_OPEN());
                    $this.xmlMode().isTagMode_$eq(true);
                    $this.xmlMode().tagState_$eq(InEndTag$.MODULE$);
                    break;
                }
                if ($this.ch(1) == '!') {
                    if ($this.ch(2) == '-') {
                        XmlLexer$class.getXmlComment($this);
                        if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    if ($this.ch(2) == '[') {
                        XmlLexer$class.getXmlCDATA($this);
                        if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    if ($this.forgiveErrors()) {
                        $this.munch("<!");
                        $this.token(Tokens$.MODULE$.XML_COMMENT());
                        break;
                    }
                    throw new ScalaLexerException("Bad XML");
                }
                if ($this.ch(1) == '?') {
                    XmlLexer$class.getXmlProcessingInstruction($this);
                    if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                    $this.popMode();
                    break;
                }
                if ($this.lookaheadIs("<xml:unparsed")) {
                    XmlLexer$class.getXmlUnparsed($this);
                    if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                    $this.popMode();
                    break;
                }
                $this.nextChar();
                $this.token(Tokens$.MODULE$.XML_START_OPEN());
                $this.xmlMode().isTagMode_$eq(true);
                $this.xmlMode().tagState_$eq(InStartTag$.MODULE$);
                break;
            }
            case '=': {
                if (XmlLexer$class.tagMode($this)) {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.XML_ATTR_EQ());
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
            }
        }
    }

    private static void getXmlCDATA(ScalaLexer $this) {
        $this.munch("<![CDATA[");
        boolean bl = true;
        while (bl) {
            if ($this.lookaheadIs("]]>")) {
                $this.munch("]]>");
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed XML CDATA");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_CDATA());
    }

    private static void getXmlComment(ScalaLexer $this) {
        $this.munch("<!--");
        boolean bl = true;
        while (bl) {
            if ($this.ch() == '-' && $this.ch(1) == '-') {
                $this.nextChar();
                $this.nextChar();
                if ($this.ch() != '>') {
                    if ($this.forgiveErrors()) {
                        bl = false;
                    } else {
                        throw new ScalaLexerException("Malformed XML comment");
                    }
                }
                $this.nextChar();
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed XML comment");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_COMMENT());
    }

    private static void getXmlCharData(ScalaLexer $this) {
        boolean bl = true;
        while (bl) {
            if ($this.ch() == '\u001a' || $this.ch() == '<') {
                bl = false;
                continue;
            }
            if ($this.ch() == '{') {
                if ($this.ch(1) == '{') {
                    $this.nextChar();
                    $this.nextChar();
                    continue;
                }
                bl = false;
                continue;
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_PCDATA());
    }

    private static void getXmlSpace(ScalaLexer $this) {
        Predef$.MODULE$.require($this.isSpace($this.ch()));
        $this.nextChar();
        while ($this.ch() != '\u001a' && $this.isSpace($this.ch())) {
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_WHITESPACE());
    }

    private static void getXmlName(ScalaLexer $this) {
        Predef$.MODULE$.require($this.isNameStart($this.ch()));
        $this.nextChar();
        while ($this.ch() != '\u001a' && $this.isNameChar($this.ch())) {
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_NAME());
    }

    private static void getXmlAttributeValue(ScalaLexer $this, char quote) {
        Predef$.MODULE$.require(quote == '\'' || quote == '\"');
        Predef$.MODULE$.require($this.ch() == quote);
        $this.nextChar();
        while ($this.ch() != quote) {
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    $this.token(Tokens$.MODULE$.XML_ATTR_VALUE());
                    return;
                }
                throw new ScalaLexerException("Unterminated attribute value");
            }
            $this.nextChar();
        }
        Predef$.MODULE$.require($this.ch() == quote);
        $this.nextChar();
        $this.token(Tokens$.MODULE$.XML_ATTR_VALUE());
    }

    private static void getXmlUnparsed(ScalaLexer $this) {
        $this.munch("<xml:unparsed");
        boolean bl = true;
        while (bl) {
            if ($this.lookaheadIs("</xml:unparsed>")) {
                $this.munch("</xml:unparsed>");
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed Unparsed XML");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_UNPARSED());
    }

    private static void getXmlProcessingInstruction(ScalaLexer $this) {
        $this.munch("<?");
        boolean bl = true;
        while (bl) {
            if ($this.lookaheadIs("?>")) {
                $this.munch("?>");
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed XML processing instruction");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_PROCESSING_INSTRUCTION());
    }

    public static void $init$(ScalaLexer $this) {
    }
}

