/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.Supplementer;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingHook;
import org.eclipse.equinox.weaving.hooks.IAdaptorProvider;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplementerRegistry
implements ISupplementerRegistry {
    public static final String SUPPLEMENT_BUNDLE = "Eclipse-SupplementBundle";
    public static final String SUPPLEMENT_EXPORTER = "Eclipse-SupplementExporter";
    public static final String SUPPLEMENT_IMPORTER = "Eclipse-SupplementImporter";
    private final IAdaptorProvider adaptorProvider;
    private BundleContext context;
    private final Set<String> dontWeaveTheseBundles;
    private PackageAdmin packageAdmin;
    private final Map<String, Supplementer> supplementers;
    private final Map<Long, Supplementer[]> supplementersByBundle;

    public SupplementerRegistry(IAdaptorProvider iAdaptorProvider) {
        this.adaptorProvider = iAdaptorProvider;
        this.supplementers = new HashMap<String, Supplementer>();
        this.supplementersByBundle = new HashMap<Long, Supplementer[]>();
        this.dontWeaveTheseBundles = new HashSet<String>();
        this.dontWeaveTheseBundles.add("org.eclipse.osgi");
        this.dontWeaveTheseBundles.add("org.eclipse.update.configurator");
        this.dontWeaveTheseBundles.add("org.eclipse.core.runtime");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.common");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.hook");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.aspectj");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.caching");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.caching.j9");
        this.dontWeaveTheseBundles.add("org.aspectj.runtime");
        this.dontWeaveTheseBundles.add("org.aspectj.weaver");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.simpleconfigurator");
    }

    @Override
    public void addBundle(Bundle bundle) {
        this.addSupplementedBundle(bundle);
        this.addSupplementer(bundle, true);
    }

    @Override
    public void addSupplementedBundle(Bundle bundle) {
        try {
            Dictionary dictionary = bundle.getHeaders();
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Import-Package", (String)((String)dictionary.get("Import-Package")));
            ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)"Export-Package", (String)((String)dictionary.get("Export-Package")));
            List<Supplementer> list = this.getMatchingSupplementers(bundle.getSymbolicName(), manifestElementArray, manifestElementArray2);
            if (list.size() > 0) {
                this.addSupplementedBundle(bundle, list);
            }
            this.supplementersByBundle.put(bundle.getBundleId(), list.toArray(new Supplementer[list.size()]));
        }
        catch (BundleException bundleException) {}
    }

    @Override
    public void addSupplementer(Bundle bundle, boolean bl) {
        try {
            Dictionary dictionary = bundle.getHeaders();
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)SUPPLEMENT_BUNDLE, (String)((String)dictionary.get(SUPPLEMENT_BUNDLE)));
            ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)SUPPLEMENT_IMPORTER, (String)((String)dictionary.get(SUPPLEMENT_IMPORTER)));
            ManifestElement[] manifestElementArray3 = ManifestElement.parseHeader((String)SUPPLEMENT_EXPORTER, (String)((String)dictionary.get(SUPPLEMENT_EXPORTER)));
            if (manifestElementArray != null || manifestElementArray2 != null || manifestElementArray3 != null) {
                Bundle[] bundleArray = this.packageAdmin.getHosts(bundle);
                Bundle bundle2 = bundleArray != null && bundleArray.length == 1 ? bundleArray[0] : null;
                Supplementer supplementer = new Supplementer(bundle, bundle2, manifestElementArray, manifestElementArray2, manifestElementArray3);
                this.supplementers.put(bundle.getSymbolicName(), supplementer);
                if (bl) {
                    this.resupplementInstalledBundles(supplementer);
                }
            }
        }
        catch (BundleException bundleException) {}
    }

    @Override
    public List<Supplementer> getMatchingSupplementers(String string, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2) {
        List<Supplementer> list = Collections.emptyList();
        if (this.supplementers.size() > 0 && !this.dontWeaveTheseBundles.contains(string)) {
            list = new LinkedList<Supplementer>();
            for (Supplementer supplementer : this.supplementers.values()) {
                if (!this.isSupplementerMatching(string, manifestElementArray, manifestElementArray2, supplementer)) continue;
                list.add(supplementer);
            }
        }
        return list;
    }

    @Override
    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    @Override
    public Supplementer[] getSupplementers(Bundle bundle) {
        return this.getSupplementers(bundle.getBundleId());
    }

    @Override
    public Supplementer[] getSupplementers(long l) {
        if (this.supplementersByBundle.containsKey(l)) {
            return this.supplementersByBundle.get(l);
        }
        return new Supplementer[0];
    }

    @Override
    public void refreshBundles(Bundle[] bundleArray) {
        if (this.packageAdmin != null) {
            if (AbstractWeavingHook.verbose) {
                int n = 0;
                while (n < bundleArray.length) {
                    System.out.println("refresh bundle: " + bundleArray[n].getSymbolicName());
                    ++n;
                }
            }
            this.packageAdmin.refreshPackages(bundleArray);
        }
    }

    @Override
    public void removeBundle(Bundle bundle) {
        this.removeSupplementedBundle(bundle);
        this.supplementersByBundle.remove(bundle.getBundleId());
        this.adaptorProvider.resetAdaptor(bundle.getBundleId());
        if (this.supplementers.containsKey(bundle.getSymbolicName())) {
            Bundle[] bundleArray;
            Supplementer supplementer = this.supplementers.get(bundle.getSymbolicName());
            this.supplementers.remove(bundle.getSymbolicName());
            if (AbstractWeavingHook.verbose) {
                System.err.println("[org.eclipse.equinox.weaving.hook] info removing supplementer " + bundle.getSymbolicName());
            }
            if ((bundleArray = supplementer.getSupplementedBundles()) != null && bundleArray.length > 0) {
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundleArray.length);
                Bundle[] bundleArray2 = bundleArray;
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle2 = bundleArray2[n2];
                    if (this.adaptorProvider.getAdaptor(bundle2.getBundleId()) != null) {
                        arrayList.add(bundle2);
                    }
                    ++n2;
                }
                if (arrayList.size() > 0) {
                    this.refreshBundles(arrayList.toArray(new Bundle[arrayList.size()]));
                }
            }
            int n = 0;
            while (n < bundleArray.length) {
                long l = bundleArray[n].getBundleId();
                ArrayList<Supplementer> arrayList = new ArrayList<Supplementer>(Arrays.asList(this.supplementersByBundle.get(l)));
                arrayList.remove(supplementer);
                this.supplementersByBundle.put(l, arrayList.toArray(new Supplementer[0]));
                ++n;
            }
        }
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    @Override
    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    private void addSupplementedBundle(Bundle bundle, List<Supplementer> list) {
        for (Supplementer supplementer : list) {
            supplementer.addSupplementedBundle(bundle);
        }
    }

    private boolean isSupplementerMatching(String string, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, Supplementer supplementer) {
        String string2 = supplementer.getSymbolicName();
        return !string2.equals(string) && (supplementer.matchSupplementer(string) || manifestElementArray != null && supplementer.matchesSupplementImporter(manifestElementArray) || manifestElementArray2 != null && supplementer.matchesSupplementExporter(manifestElementArray2));
    }

    private void removeSupplementedBundle(Bundle bundle) {
        for (Supplementer supplementer : this.supplementers.values()) {
            supplementer.removeSupplementedBundle(bundle);
        }
    }

    private void resupplementInstalledBundles(Supplementer supplementer) {
        Bundle[] bundleArray = this.context.getBundles();
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        int n = 0;
        while (n < bundleArray.length) {
            try {
                Bundle bundle = bundleArray[n];
                if (!bundle.getSymbolicName().equals(supplementer.getSymbolicName()) && !this.dontWeaveTheseBundles.contains(bundle.getSymbolicName())) {
                    Dictionary dictionary = bundle.getHeaders();
                    ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Import-Package", (String)((String)dictionary.get("Import-Package")));
                    ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)"Export-Package", (String)((String)dictionary.get("Export-Package")));
                    if (this.isSupplementerMatching(bundle.getSymbolicName(), manifestElementArray, manifestElementArray2, supplementer)) {
                        if (this.adaptorProvider.getAdaptor(bundle.getBundleId()) != null) {
                            arrayList.add(bundle);
                        } else {
                            supplementer.addSupplementedBundle(bundle);
                            Supplementer[] supplementerArray = this.supplementersByBundle.get(bundle.getBundleId());
                            ArrayList<Object> arrayList2 = null;
                            arrayList2 = supplementerArray != null ? new ArrayList<Supplementer>(Arrays.asList(supplementerArray)) : new ArrayList();
                            if (!arrayList2.contains(supplementer)) {
                                arrayList2.add(supplementer);
                            }
                            this.supplementersByBundle.put(bundle.getBundleId(), arrayList2.toArray(new Supplementer[0]));
                        }
                    }
                }
            }
            catch (BundleException bundleException) {
                bundleException.printStackTrace();
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            Bundle[] bundleArray2 = arrayList.toArray(new Bundle[arrayList.size()]);
            this.refreshBundles(bundleArray2);
        }
    }
}

