/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001i3Q!\u0001\u0002\u0001\u0005\u0019\u0011A\u0002V3tiJ+'/\u001e8oKJT!a\u0001\u0003\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0003\u0002\u0007=\u0014xm\u0005\u0003\u0001\u000f=\u0019\u0002C\u0001\u0005\u000e\u001b\u0005I!B\u0001\u0006\f\u0003\u0011a\u0017M\\4\u000b\u00031\tAA[1wC&\u0011a\"\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005A\tR\"\u0001\u0002\n\u0005I\u0011!\u0001\u0003*feVtg.\u001a:\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t5\u0001\u0011\t\u0011)A\u00059\u0005q1/^5uK\u000ec\u0017m]:OC6,7\u0001\u0001\t\u0003;\u0001r!\u0001\u0006\u0010\n\u0005})\u0012A\u0002)sK\u0012,g-\u0003\u0002\"E\t11\u000b\u001e:j]\u001eT!aH\u000b\t\u0011\u0011\u0002!\u0011!Q\u0001\nq\t\u0001\u0002^3ti:\u000bW.\u001a\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!J#\u0006\u0005\u0002\u0011\u0001!)!$\na\u00019!)A%\na\u00019!)A\u0006\u0001C\u0001[\u0005)\u0011\r\u001d9msRAa&\r\u001c<\u0001\"\u0003V\u000b\u0005\u0002\u0015_%\u0011\u0001'\u0006\u0002\u0005+:LG\u000fC\u00033W\u0001\u00071'\u0001\u0004sKB|'\u000f\u001e\t\u0003!QJ!!\u000e\u0002\u0003\u0011I+\u0007o\u001c:uKJDQaN\u0016A\u0002a\nqa\u001d;paB,'\u000f\u0005\u0002\u0011s%\u0011!H\u0001\u0002\b'R|\u0007\u000f]3s\u0011\u0015a4\u00061\u0001>\u0003\u00191\u0017\u000e\u001c;feB\u0011\u0001CP\u0005\u0003\u007f\t\u0011aAR5mi\u0016\u0014\b\"B!,\u0001\u0004\u0011\u0015!C2p]\u001aLw-T1q!\u0011i2\tH#\n\u0005\u0011\u0013#aA'baB\u0011ACR\u0005\u0003\u000fV\u00111!\u00118z\u0011\u0015I5\u00061\u0001K\u0003-!\u0017n\u001d;sS\n,Ho\u001c:\u0011\u0007QYU*\u0003\u0002M+\t1q\n\u001d;j_:\u0004\"\u0001\u0005(\n\u0005=\u0013!a\u0003#jgR\u0014\u0018NY;u_JDQ!U\u0016A\u0002I\u000bq\u0001\u001e:bG.,'\u000f\u0005\u0002\u0011'&\u0011AK\u0001\u0002\b)J\f7m[3s\u0011\u001516\u00061\u0001X\u0003\u0019aw.\u00193feB\u0011\u0001\u0002W\u0005\u00033&\u00111b\u00117bgNdu.\u00193fe\u0002")
public class TestRerunner
implements Rerunner,
ScalaObject {
    private final String suiteClassName;
    private final String testName;

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(RunStarting$.MODULE$.apply(tracker.nextOrdinal(), 1, configMap));
            suite.run((Option<String>)new Some((Object)this.testName), report, stopper, filter2, configMap, distributor, tracker);
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunCompleted$.MODULE$.apply(tracker.nextOrdinal(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

