/***************************************************************************

        PP-01 driver by Miodrag Milanovic

        08/09/2008 Preliminary driver.

****************************************************************************/


#include "driver.h"
#include "cpu/i8085/i8085.h"
#include "includes/pp01.h"


/* Address maps */
static ADDRESS_MAP_START(pp01_mem, ADDRESS_SPACE_PROGRAM, 8)
	AM_RANGE(0x0000, 0x3fff) AM_READWRITE(SMH_BANK1, SMH_BANK1)
	AM_RANGE(0x4000, 0x7fff) AM_READWRITE(SMH_BANK2, SMH_BANK2)
	AM_RANGE(0x8000, 0xbfff) AM_READWRITE(SMH_BANK3, SMH_ROM)
	AM_RANGE(0xc000, 0xffff) AM_READWRITE(SMH_BANK4, SMH_BANK4)
ADDRESS_MAP_END

static ADDRESS_MAP_START( pp01_io, ADDRESS_SPACE_IO, 8 )
ADDRESS_MAP_END

/* Input ports */
static INPUT_PORTS_START( pp01 )
	PORT_START("LINE0")
	PORT_BIT(0x01, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("U") PORT_CODE(KEYCODE_U)
	PORT_BIT(0x02, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("A") PORT_CODE(KEYCODE_A)
	PORT_BIT(0x04, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("T") PORT_CODE(KEYCODE_T)
	PORT_BIT(0x08, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("L") PORT_CODE(KEYCODE_L)
	PORT_BIT(0x10, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("W") PORT_CODE(KEYCODE_W)
	PORT_BIT(0x20, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("F6") PORT_CODE(KEYCODE_F6)
	PORT_BIT(0x40, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("F") PORT_CODE(KEYCODE_F)
	PORT_BIT(0x80, IP_ACTIVE_HIGH, IPT_KEYBOARD) PORT_NAME("F7") PORT_CODE(KEYCODE_F7)

INPUT_PORTS_END

/* Machine driver */
static MACHINE_DRIVER_START( pp01 )
	/* basic machine hardware */
	MDRV_CPU_ADD("maincpu", 8080, 2000000)
	MDRV_CPU_PROGRAM_MAP(pp01_mem, 0)
	MDRV_CPU_IO_MAP(pp01_io, 0)

	MDRV_MACHINE_START( pp01 )
	MDRV_MACHINE_RESET( pp01 )

    /* video hardware */
	MDRV_SCREEN_ADD("screen", RASTER)
	MDRV_SCREEN_REFRESH_RATE(50)
	MDRV_SCREEN_VBLANK_TIME(ATTOSECONDS_IN_USEC(2500)) /* not accurate */
	MDRV_SCREEN_FORMAT(BITMAP_FORMAT_INDEXED16)
	MDRV_SCREEN_SIZE(256, 256)
	MDRV_SCREEN_VISIBLE_AREA(0, 256-1, 0, 256-1)
	MDRV_PALETTE_LENGTH(8)
	MDRV_PALETTE_INIT(pp01)

	MDRV_VIDEO_START(pp01)
	MDRV_VIDEO_UPDATE(pp01)
MACHINE_DRIVER_END

static SYSTEM_CONFIG_START(pp01)
	CONFIG_RAM_DEFAULT(64 * 1024)
SYSTEM_CONFIG_END

/* ROM definition */

ROM_START( pp01 )
	ROM_REGION( 0x14000, "maincpu", ROMREGION_ERASEFF )
	ROM_LOAD( "pp01.rom", 0x10000, 0x4000, CRC(d6ee4dd6) SHA1(acc162975f255bc8de5ca0fd8da11d1d7bd7fbfc) )
ROM_END


/* Driver */

/*    YEAR  NAME    PARENT  COMPAT  MACHINE     INPUT       INIT     CONFIG COMPANY                  FULLNAME   FLAGS */
COMP( 198?, pp01, 	0, 	 	0,		pp01, 		pp01, 		pp01, 	 pp01,  	"ZVT",					 "PP-01",	 GAME_NOT_WORKING)
