/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.flatfile.recordtype;

import java.io.IOException;

import com.servingxml.app.ServiceContext;
import com.servingxml.util.Name;
import com.servingxml.util.ServingXmlException;
import com.servingxml.util.record.PackedDecimal;
import com.servingxml.util.record.RecordBuilder;
import com.servingxml.util.record.Record;
import com.servingxml.app.Flow;
import com.servingxml.components.flatfile.RecordInput;
import com.servingxml.components.flatfile.options.Delimiter;

public class PackedDecimalFieldReader implements FlatRecordFieldReader {
  private final Name name;
  private final int startPosition;
  private final int fieldWidth;
  private final int digitCount;
  private final int decimalPlaces;

  public PackedDecimalFieldReader(Name name, int startPosition, int fieldWidth, int digitCount, int decimalPlaces) {
    this.name = name;
    this.startPosition = startPosition;
    this.fieldWidth = fieldWidth;
    this.digitCount = digitCount;
    this.decimalPlaces = decimalPlaces;
  }

  public void readField(ServiceContext context, 
                        Flow flow,
                        final RecordInput recordInput, 
                        Delimiter[] recordDelimiters, 
                        int recordDelimiterStart, int recordDelimiterCount, 
                        RecordBuilder recordBuilder) {

    //System.out.println(getClass().getName()+".readField " + name);
    try {
      if (startPosition != -1) {
        recordInput.setPosition(startPosition);
      }

      if (fieldWidth > 0) {
        byte[] value = new byte[fieldWidth];
        int len = recordInput.readBytes(value);
        if (len == fieldWidth) {
          PackedDecimal packedDecimal = new PackedDecimal(value,digitCount,decimalPlaces);
          recordBuilder.setPackedDecimal(name,packedDecimal);
        }
      }
    } catch (IOException e) {
      throw new ServingXmlException(e.getMessage(), e);
    }
  }

  public int getFixedEndPosition(Record parameters, Record currentRecord, int currentPosition) {
    return startPosition >= 0 ? startPosition+fieldWidth : currentPosition+fieldWidth;
  }
}
