/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ReceivingContentHandler
implements ContentHandler,
LexicalHandler,
DTDHandler {
    private NamePool pool;
    private PipelineConfiguration pipe;
    private Receiver receiver;
    private boolean inDTD = false;
    private Locator locator;
    private LocalLocator localLocator = new LocalLocator();
    private char[] buffer = new char[512];
    private int charsUsed = 0;
    private CharSlice slice = new CharSlice(this.buffer, 0, 0);
    private int[] namespaces = new int[20];
    private int namespacesUsed = 0;
    private boolean ignoreIgnorable = false;
    private boolean retainDTDAttributeTypes = false;
    private boolean suppressDTDAttributeDefaults = false;
    private boolean allowDisableOutputEscaping = false;
    private boolean escapingDisabled = false;
    private HashMap cache = new HashMap(10);
    private HashMap noNamespaceMap;
    private static Class attributes2class;
    private static Method isSpecifiedMethod;
    static /* synthetic */ Class class$java$lang$String;

    public void reset() {
        this.pipe = null;
        this.pool = null;
        this.receiver = null;
        this.ignoreIgnorable = false;
        this.retainDTDAttributeTypes = false;
        this.charsUsed = 0;
        this.slice.setLength(0);
        this.namespacesUsed = 0;
        this.locator = null;
        this.allowDisableOutputEscaping = false;
        this.escapingDisabled = false;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        pipe.setLocationProvider(this.localLocator);
        Configuration config = pipe.getConfiguration();
        this.pool = config.getNamePool();
        this.ignoreIgnorable = config.getStripsWhiteSpace() != 0;
        this.retainDTDAttributeTypes = config.isRetainDTDAttributeTypes();
        this.suppressDTDAttributeDefaults = !pipe.isExpandAttributeDefaults();
        Boolean b = (Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/use-pi-disable-output-escaping");
        this.allowDisableOutputEscaping = b;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void setIgnoreIgnorableWhitespace(boolean ignore) {
        this.ignoreIgnorable = ignore;
    }

    public boolean isIgnoringIgnorableWhitespace() {
        return this.ignoreIgnorable;
    }

    public void startDocument() throws SAXException {
        try {
            this.charsUsed = 0;
            this.namespacesUsed = 0;
            this.pipe.setLocationProvider(this.localLocator);
            this.receiver.setPipelineConfiguration(this.pipe);
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush();
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (ValidationException err) {
            err.setLocator(this.locator);
            throw new SAXException(err);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix.equals("xmlns")) {
            return;
        }
        if (this.namespacesUsed >= this.namespaces.length) {
            int[] n2 = new int[this.namespacesUsed * 2];
            System.arraycopy(this.namespaces, 0, n2, 0, this.namespacesUsed);
            this.namespaces = n2;
        }
        this.namespaces[this.namespacesUsed++] = this.pool.allocateNamespaceCode(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localname, String rawname, Attributes atts) throws SAXException {
        try {
            this.flush();
            int nameCode = this.getNameCode(uri, localname, rawname);
            this.receiver.startElement(nameCode, 630, 0, 64);
            for (int n = 0; n < this.namespacesUsed; ++n) {
                this.receiver.namespace(this.namespaces[n], 0);
            }
            for (int a = 0; a < atts.getLength(); ++a) {
                int properties;
                block38: {
                    properties = 64;
                    String qname = atts.getQName(a);
                    if (qname.startsWith("xmlns") && (qname.equals("xmlns") || qname.startsWith("xmlns:"))) continue;
                    if (this.suppressDTDAttributeDefaults && attributes2class == null) {
                        try {
                            attributes2class = this.getConfiguration().getClass("org.xml.sax.ext.Attributes2", false, null);
                            isSpecifiedMethod = attributes2class.getMethod("isSpecified", class$java$lang$String == null ? ReceivingContentHandler.class$("java.lang.String") : class$java$lang$String);
                        }
                        catch (XPathException e) {
                            this.suppressDTDAttributeDefaults = false;
                            attributes2class = null;
                        }
                        catch (NoSuchMethodException e) {
                            this.suppressDTDAttributeDefaults = false;
                            attributes2class = null;
                        }
                        if (this.suppressDTDAttributeDefaults) {
                            if (attributes2class.isAssignableFrom(atts.getClass())) {
                                try {
                                    Boolean specified = (Boolean)isSpecifiedMethod.invoke((Object)atts, qname);
                                    if (!specified.booleanValue()) {
                                        continue;
                                    }
                                    break block38;
                                }
                                catch (IllegalAccessException e) {
                                    this.suppressDTDAttributeDefaults = false;
                                    break block38;
                                }
                                catch (InvocationTargetException e) {
                                    this.suppressDTDAttributeDefaults = false;
                                    break block38;
                                }
                            }
                            this.suppressDTDAttributeDefaults = false;
                        }
                    }
                }
                int attCode = this.getNameCode(atts.getURI(a), atts.getLocalName(a), atts.getQName(a));
                String type = atts.getType(a);
                int typeCode = 631;
                if (this.retainDTDAttributeTypes) {
                    if (!type.equals("CDATA")) {
                        if (type.equals("ID")) {
                            typeCode = 560;
                        } else if (type.equals("IDREF")) {
                            typeCode = 561;
                        } else if (type.equals("IDREFS")) {
                            typeCode = 562;
                        } else if (type.equals("NMTOKEN")) {
                            typeCode = 556;
                        } else if (type.equals("NMTOKENS")) {
                            typeCode = 557;
                        } else if (type.equals("ENTITY")) {
                            typeCode = 563;
                        } else if (type.equals("ENTITIES")) {
                            typeCode = 564;
                        }
                    }
                } else if (!type.equals("CDATA")) {
                    if (type.equals("ID")) {
                        typeCode = 1073742384;
                    } else if (type.equals("IDREF")) {
                        typeCode = 1073742385;
                    } else if (type.equals("IDREFS")) {
                        typeCode = 1073742386;
                    }
                }
                this.receiver.attribute(attCode, typeCode, atts.getValue(a), 0, properties);
            }
            this.receiver.startContent();
            this.namespacesUsed = 0;
        }
        catch (ValidationException err) {
            if (err.getLineNumber() == -1) {
                err.setLocator(this.locator);
            }
            throw new SAXException(err);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    private int getNameCode(String uri, String localname, String rawname) throws SAXException {
        Integer n;
        HashMap<String, Integer> map2;
        if (rawname.length() == 0) {
            throw new SAXException("Saxon requires an XML parser that reports the QName of each element");
        }
        if (localname.length() == 0) {
            throw new SAXException("Parser configuration problem: namespace reporting is not enabled");
        }
        HashMap<String, Integer> hashMap = map2 = uri.length() == 0 ? this.noNamespaceMap : (HashMap)this.cache.get(uri);
        if (map2 == null) {
            map2 = new HashMap<String, Integer>(50);
            this.cache.put(uri, map2);
            if (uri.length() == 0) {
                this.noNamespaceMap = map2;
            }
        }
        if ((n = (Integer)map2.get(rawname)) == null) {
            String prefix = NameChecker.getPrefix(rawname);
            int nc = this.pool.allocate(prefix, uri, localname);
            n = new Integer(nc);
            map2.put(rawname, n);
            return nc;
        }
        return n;
    }

    public void endElement(String uri, String localname, String rawname) throws SAXException {
        try {
            this.flush();
            this.receiver.endElement();
        }
        catch (ValidationException err) {
            err.maybeSetLocation(ExpressionLocation.makeFromSax(this.locator));
            if (!err.hasBeenReported()) {
                try {
                    this.pipe.getErrorListener().fatalError(err);
                }
                catch (TransformerException e) {
                    // empty catch block
                }
            }
            err.setHasBeenReported();
            throw new SAXException(err);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        while (this.charsUsed + length > this.buffer.length) {
            char[] newbuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.charsUsed);
            this.buffer = newbuffer;
            this.slice = new CharSlice(this.buffer, 0, 0);
        }
        System.arraycopy(ch, start, this.buffer, this.charsUsed, length);
        this.charsUsed += length;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.ignoreIgnorable) {
            this.characters(ch, start, length);
        }
    }

    public void processingInstruction(String name, String remainder) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                if (name == null) {
                    this.comment(remainder.toCharArray(), 0, remainder.length());
                } else {
                    if (!this.getConfiguration().getNameChecker().isValidNCName(name)) {
                        throw new SAXException("Invalid processing instruction name (" + name + ')');
                    }
                    if (this.allowDisableOutputEscaping) {
                        if (name.equals("javax.xml.transform.disable-output-escaping")) {
                            this.escapingDisabled = true;
                            return;
                        }
                        if (name.equals("javax.xml.transform.enable-output-escaping")) {
                            this.escapingDisabled = false;
                            return;
                        }
                    }
                    this.receiver.processingInstruction(name, Whitespace.removeLeadingWhitespace(remainder), 0, 0);
                }
            }
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                this.receiver.comment(new CharSlice(ch, start, length), 0, 0);
            }
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    private void flush() throws XPathException {
        if (this.charsUsed > 0) {
            this.slice.setLength(this.charsUsed);
            CharSequence cs = CompressedWhitespace.compress(this.slice);
            this.receiver.characters(cs, 0, this.escapingDisabled ? 1 : 1024);
            this.charsUsed = 0;
            this.escapingDisabled = false;
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        String uri = systemId;
        if (this.locator != null) {
            try {
                String baseURI;
                URI suppliedURI = new URI(systemId);
                if (!suppliedURI.isAbsolute() && (baseURI = this.locator.getSystemId()) != null) {
                    URI absoluteURI = new URI(baseURI).resolve(systemId);
                    uri = absoluteURI.toString();
                }
            }
            catch (URISyntaxException err) {
                uri = systemId;
            }
        }
        try {
            this.receiver.setUnparsedEntity(name, uri, publicId);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    private class LocalLocator
    implements SaxonLocator,
    SourceLocationProvider {
        private LocalLocator() {
        }

        public String getSystemId() {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getSystemId();
        }

        public String getPublicId() {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getPublicId();
        }

        public int getLineNumber() {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber() {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getColumnNumber();
        }

        public int getLineNumber(long locationId) {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber(long locationId) {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getColumnNumber();
        }

        public String getSystemId(long locationId) {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getSystemId();
        }
    }
}

