/**
 *  ServingXML
 *  
 *  Copyright (C) 2006  Daniel Parker
 *    daniel.parker@servingxml.com 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 * 
 **/

package com.servingxml.components.string;

import com.servingxml.components.common.SubstitutionExprValueEvaluator;
import com.servingxml.components.common.XPathEvaluator;
import com.servingxml.components.quotesymbol.QuoteSymbol;
import com.servingxml.ioc.components.ConfigurationContext;
import com.servingxml.util.xml.DomHelper;
import com.servingxml.util.xml.XPathExpressionFactory;
import com.servingxml.expr.substitution.EscapeSubstitutionVariables;

/**
 *  
 * @author Daniel A. Parker (daniel.parker@servingxml.com)
 */

public class PreserveMarkupAssembler {

  public StringFactory assemble(ConfigurationContext context) {

    String s = DomHelper.preserveMarkup(context.getElement());

    return new StringLiteralFactory(s);
  }
}
