/*
 * Shotgun Debugger
 * Copyright 2005 Game Creation Society
 *
 * Programmed by Matt Sarnoff
 * http://www.contrib.andrew.cmu.edu/~msarnoff
 * http://www.gamecreation.org
 *
 * input.cpp - input handler
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "sdb.h"

//Uint8 *keystate;

// sym is the SDLK_* keysym to bind to the action.
void InputHandler::bindKey(int action, int sym1, int sym2)
{
  if (action >= 0 && action < NUM_INPUT_KEYS)
  {
    keysym1[action] = sym1;
    keysym2[action] = sym2;
  }
}  

void InputHandler::defaultBindings()
{
  bindKey(KEY_LEFT, MOUSE_X_NEG, SDLK_LEFT);
  bindKey(KEY_RIGHT, MOUSE_X_POS, SDLK_RIGHT);
  bindKey(KEY_FWD, SDLK_w, NO_KEY);
  bindKey(KEY_BACK, SDLK_s, NO_KEY);
  bindKey(KEY_STRAFE_L, SDLK_a, NO_KEY);
  bindKey(KEY_STRAFE_R, SDLK_d, NO_KEY);  
  bindKey(KEY_JUMP, SDLK_SPACE, NO_KEY); 
  bindKey(KEY_FIRE, MOUSE_BUTTON_1, SDLK_LCTRL); 
  bindKey(KEY_GRENADE, MOUSE_BUTTON_3, SDLK_g); 
  bindKey(KEY_RELOAD, SDLK_r, NO_KEY); 
  bindKey(KEY_SWITCH_WPN, SDLK_TAB, NO_KEY);
  bindKey(KEY_SWITCH_VIEW, SDLK_v, NO_KEY);
  bindKey(KEY_ZOOM_OUT, MOUSE_BUTTON_2, SDLK_z);
}

// Call this only after global keystate and mouse statehas been updated
// with SDL_GetKeyState().
float InputHandler::bindingState(int key)
{
  if (key != NO_KEY)
  {
    if (IS_MOUSE_AXIS(key))
    {
      switch(key)
      {
        case MOUSE_X_POS: 
          if (mouse_dX > config.mthresh)
            return (float)abs(mouse_dX) * ((float)config.msense/1000.0);
          else
            return 0;
          break;
        case MOUSE_X_NEG: 
          if (mouse_dX < -config.mthresh)
            return (float)abs(mouse_dX) * ((float)config.msense/1000.0);
          else
            return 0;
          break;
        case MOUSE_Y_POS: 
          if (mouse_dY > config.mthresh)
            return (float)abs(mouse_dY) * ((float)config.msense/1000.0);
          else
            return 0;
          break;
        case MOUSE_Y_NEG: 
          if (mouse_dY < -config.mthresh)
            return (float)abs(mouse_dY) * ((float)config.msense/1000.0);
          else
            return 0;
          break;                 
      }
    }
    else if (IS_MOUSE_BUTTON(key))
      return (mouseButtons & SDL_BUTTON(-key)) ? 1 : 0;
    else
      return (keystate[key]) ? 1 : 0;
  }
  else
    return 0.0;
}

