/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.TableColumn;
import netscape.javascript.JSObject;

public class Main
extends JApplet
implements MouseListener,
DropTargetListener {
    JTable table;
    JButton add;
    JButton remove;
    JButton upload;
    JButton help;
    TableData tabledata;
    TableColumn sizeColumn;
    File[] files;
    JLabel progCompletion;
    JProgressBar progBar;
    int sentBytes;
    int totalBytes;
    int buttonClicked;
    Color backgroundColour;
    Color columnHeadColourBack;
    Color columnHeadColourFore;
    PostletLabels pLabels;
    boolean javascript;
    URL endPageURL;
    URL helpPageURL;
    URL destinationURL;
    boolean warnMessage;
    boolean autoUpload;
    String language;
    String endpage;
    String helppage;
    int maxThreads;
    String[] fileExtensions;
    DataFlavor uriListFlavor;

    public void init() {
        System.out.println("POSTLET VERSION: 0.10");
        String date = "$Date: 2006-08-30 16:18:02 +0100 (Wed, 30 Aug 2006) $";
        System.out.println(date.substring(7, date.length() - 1));
        try {
            this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            this.errorMessage(System.out, "No class found for DataFlavor");
        }
        this.javascript = false;
        JavascriptListener jsListen = new JavascriptListener(this);
        jsListen.start();
        this.buttonClicked = 0;
        this.getParameters();
        this.pLabels = new PostletLabels(this.language, this.getCodeBase());
        this.layoutGui();
    }

    private void layoutGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException exc) {
        }
        catch (IllegalAccessException exc) {
        }
        catch (ClassNotFoundException exc) {
        }
        catch (InstantiationException exc) {
            // empty catch block
        }
        Container pane = this.getContentPane();
        try {
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(this);
            pane.setDropTarget(dt);
        }
        catch (TooManyListenersException tmle) {
            this.errorMessage(System.out, "Too many listeners to drop!");
        }
        this.tabledata = new TableData(this.pLabels.getLabel(0), this.pLabels.getLabel(1) + " -KB ");
        this.table = new JTable(this.tabledata);
        this.table.setColumnSelectionAllowed(false);
        this.sizeColumn = this.table.getColumn(this.pLabels.getLabel(1) + " -KB ");
        this.sizeColumn.setMaxWidth(100);
        this.table.getColumn(this.pLabels.getLabel(1) + " -KB ").setMinWidth(100);
        if (this.columnHeadColourBack != null && this.backgroundColour != null) {
            this.errorMessage(System.out, "setting the tables colours");
            this.table.getTableHeader().setBackground(this.columnHeadColourBack);
            this.table.getTableHeader().setForeground(this.columnHeadColourFore);
            this.table.setBackground(this.backgroundColour);
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)scrollPane, "Center");
        JPanel rightPanel = new JPanel(new GridLayout(4, 1, 10, 10));
        rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add = new JButton(this.pLabels.getLabel(6));
        this.add.addMouseListener(this);
        rightPanel.add(this.add);
        this.remove = new JButton(this.pLabels.getLabel(7));
        this.remove.addMouseListener(this);
        this.remove.setEnabled(false);
        rightPanel.add(this.remove);
        this.upload = new JButton(this.pLabels.getLabel(8));
        this.upload.addMouseListener(this);
        this.upload.setEnabled(false);
        rightPanel.add(this.upload);
        this.help = new JButton(this.pLabels.getLabel(9));
        this.help.addMouseListener(this);
        rightPanel.add(this.help);
        pane.add((Component)rightPanel, "East");
        JPanel progPanel = new JPanel(new GridLayout(2, 1));
        progPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.progCompletion = new JLabel(this.pLabels.getLabel(10), 0);
        progPanel.add(this.progCompletion);
        this.progBar = new JProgressBar();
        progPanel.add(this.progBar);
        progPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 25));
        if (this.backgroundColour != null) {
            pane.setBackground(this.backgroundColour);
            rightPanel.setBackground(this.backgroundColour);
            scrollPane.setBackground(this.backgroundColour);
            progPanel.setBackground(this.backgroundColour);
        }
        scrollPane.getViewport().setBackground(Color.white);
        pane.add((Component)progPanel, "South");
        if (this.destinationURL == null) {
            this.add.setEnabled(false);
        }
    }

    public void errorMessage(PrintStream out, String message) {
        out.println("***" + message + "***");
    }

    private void getParameters() {
        try {
            this.language = this.getParameter("language");
            if (this.language == "" || this.language == null) {
                this.language = "EN";
            }
        }
        catch (NullPointerException nullLang) {
            this.language = "EN";
            this.errorMessage(System.out, "language is null");
        }
        try {
            this.destinationURL = new URL(this.getParameter("destination"));
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage(System.out, "Badly formed destination:###" + this.getParameter("destination") + "###");
            JOptionPane.showMessageDialog(null, this.pLabels.getLabel(3), this.pLabels.getLabel(5), 0);
        }
        catch (NullPointerException npe) {
            this.errorMessage(System.out, "destination is null");
            JOptionPane.showMessageDialog(null, this.pLabels.getLabel(4), this.pLabels.getLabel(5), 0);
        }
        try {
            Integer bgci = new Integer(this.getParameter("backgroundcolour"));
            this.backgroundColour = new Color(bgci);
        }
        catch (NumberFormatException numfe) {
            this.errorMessage(System.out, "background colour is not a number:###" + this.getParameter("backgroundcolour") + "###");
        }
        catch (NullPointerException nullred) {
            this.errorMessage(System.out, "background colour is null");
        }
        try {
            Integer thfi = new Integer(this.getParameter("tableheadercolour"));
            this.columnHeadColourFore = new Color(thfi);
        }
        catch (NumberFormatException numfe) {
            this.errorMessage(System.out, "table header colour is not a number:###" + this.getParameter("tableheadcolour") + "###");
        }
        catch (NullPointerException nullred) {
            this.errorMessage(System.out, "table header colour is null");
        }
        try {
            Integer thbi = new Integer(this.getParameter("tableheaderbackgroundcolour"));
            this.columnHeadColourBack = new Color(thbi);
        }
        catch (NumberFormatException numfe) {
            this.errorMessage(System.out, "table header back colour is not a number:###" + this.getParameter("tableheaderbackgroundcolour") + "###");
        }
        catch (NullPointerException nullred) {
            this.errorMessage(System.out, "table header back colour is null");
        }
        try {
            this.fileExtensions = this.getParameter("fileextensions").split(",");
        }
        catch (NullPointerException nullfileexts) {
            this.errorMessage(System.out, "file extensions is null");
        }
        try {
            this.warnMessage = this.getParameter("warnmessage").toLowerCase() == "true";
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage(System.out, "warnmessage is null");
            this.warnMessage = false;
        }
        try {
            this.autoUpload = this.getParameter("autoupload").toLowerCase() == "true";
        }
        catch (NullPointerException nullwarnmessage) {
            this.errorMessage(System.out, "autoUpload is null");
            this.autoUpload = false;
        }
        try {
            Integer maxts = new Integer(this.getParameter("maxthreads"));
            this.maxThreads = maxts;
        }
        catch (NullPointerException nullmaxthreads) {
            this.errorMessage(System.out, "maxthreads is null");
        }
        catch (NumberFormatException nummaxthreads) {
            this.errorMessage(System.out, "maxthread is not a number");
        }
        try {
            this.endPageURL = new URL(this.getParameter("endpage"));
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage(System.out, "endpage is badly formed:###" + this.getParameter("endpage") + "###");
        }
        catch (NullPointerException npe) {
            this.errorMessage(System.out, "endpage is null");
        }
        try {
            this.helpPageURL = new URL(this.getParameter("helppage"));
        }
        catch (MalformedURLException malurlex) {
            this.errorMessage(System.out, "helppage is badly formed:###" + this.getParameter("helppage") + "###");
        }
        catch (NullPointerException npe) {
            this.errorMessage(System.out, "helppage is null");
        }
    }

    public void removeClick() {
        if (this.table.getSelectedRowCount() > 0) {
            File[] fileTemp = new File[this.files.length - this.table.getSelectedRowCount()];
            int k = 0;
            for (int i = 0; i < this.files.length - this.table.getSelectedRowCount(); ++i) {
                for (int j = 0; j < this.table.getSelectedRowCount(); ++j) {
                    if (i == this.table.getSelectedRows()[j]) {
                        ++k;
                    }
                    fileTemp[i] = this.files[i + k];
                }
            }
            this.files = fileTemp;
            this.tableUpdate();
        }
        if (this.files.length == 0) {
            this.upload.setEnabled(false);
            this.remove.setEnabled(false);
        }
    }

    public void uploadClick() {
        if (this.files.length > 0) {
            UploadManager u;
            if (this.warnMessage) {
                JOptionPane.showMessageDialog(null, this.pLabels.getLabel(11), this.pLabels.getLabel(12), 1);
            }
            this.add.setEnabled(false);
            this.remove.setEnabled(false);
            this.help.setEnabled(false);
            this.upload.setEnabled(false);
            this.sentBytes = 0;
            this.progBar.setMaximum(this.totalBytes);
            this.progBar.setMinimum(0);
            try {
                u = new UploadManager(this.files, this, this.destinationURL, this.maxThreads);
            }
            catch (NullPointerException npered) {
                u = new UploadManager(this.files, this, this.destinationURL);
            }
            u.start();
        }
    }

    public synchronized void setProgress(int a) {
        this.sentBytes += a;
        this.progBar.setValue(this.sentBytes);
        if (this.sentBytes == this.totalBytes) {
            this.progCompletion.setText(this.pLabels.getLabel(2));
            if (this.endPageURL != null) {
                this.getAppletContext().showDocument(this.endPageURL);
            } else {
                JSObject win = JSObject.getWindow(this);
                win.eval("postletFinished();");
            }
            this.progBar.setValue(0);
            this.files = new File[0];
            this.tableUpdate();
            this.add.setEnabled(true);
            this.help.setEnabled(true);
        }
    }

    public void tableUpdate() {
        int i;
        this.totalBytes = 0;
        String[] filenames = new String[this.files.length];
        int[] fileSize = new int[this.files.length];
        for (i = 0; i < this.files.length; ++i) {
            filenames[i] = this.files[i].getAbsolutePath();
            fileSize[i] = (int)this.files[i].length();
            this.totalBytes += (int)this.files[i].length();
        }
        String[][] rowData = new String[255][2];
        for (i = 0; i < this.files.length; ++i) {
            rowData[i][0] = this.files[i].getName();
            rowData[i][1] = "" + this.files[i].length();
        }
        this.tabledata.formatTable(rowData, i);
        this.sizeColumn.setMaxWidth(100);
        this.sizeColumn.setMinWidth(100);
        this.repaint();
    }

    public void addClick() {
        JFileChooser chooser = new JFileChooser();
        this.progBar.setValue(0);
        if (this.fileExtensions != null) {
            UploaderFileFilter filter = new UploaderFileFilter();
            for (int i = 1; i < this.fileExtensions.length; ++i) {
                filter.addExtension(this.fileExtensions[i]);
            }
            filter.setDescription(this.fileExtensions[0]);
            chooser.addChoosableFileFilter(filter);
        } else {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        chooser.getSelectedFile();
        chooser.setDialogTitle(this.pLabels.getLabel(14));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            int i;
            File[] tempFiles = chooser.getSelectedFiles();
            Vector<File> filesForUpload = new Vector<File>();
            for (i = 0; i < tempFiles.length; ++i) {
                if (tempFiles[i].isDirectory()) {
                    File[] subDirFiles = tempFiles[i].listFiles();
                    for (int j = 0; j < subDirFiles.length; ++j) {
                        if (!subDirFiles[j].isFile()) continue;
                        filesForUpload.add(subDirFiles[j]);
                    }
                    continue;
                }
                filesForUpload.add(tempFiles[i]);
            }
            if (this.files == null) {
                this.files = new File[0];
            }
            tempFiles = new File[filesForUpload.size() + this.files.length];
            for (i = 0; i < this.files.length; ++i) {
                tempFiles[i] = this.files[i];
            }
            for (i = 0; i < filesForUpload.size(); ++i) {
                tempFiles[i + this.files.length] = (File)filesForUpload.elementAt(i);
            }
            this.files = tempFiles;
            this.tableUpdate();
        }
        if (this.files != null && this.files.length > 0) {
            this.upload.setEnabled(true);
            this.remove.setEnabled(true);
        }
        if (this.files != null && this.autoUpload) {
            this.uploadClick();
        }
    }

    public void helpClick() {
        try {
            this.getAppletContext().showDocument(this.helpPageURL, "_blank");
        }
        catch (NullPointerException nohelppage) {
            try {
                this.getAppletContext().showDocument(new URL("http://www.postlet.com/help/"), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String getCookie() {
        try {
            JSObject win = JSObject.getWindow(this);
            String cookie = "" + (String)win.eval("document.cookie");
            return cookie;
        }
        catch (Exception e) {
            return "";
        }
    }

    public void javascriptAddClicked() {
        this.buttonClicked = 0;
        this.javascript = true;
    }

    public void javascriptUploadClicked() {
        this.buttonClicked = 1;
        this.javascript = true;
    }

    public boolean getJavascriptStatus() {
        return this.javascript;
    }

    public void setJavascriptStatus() {
        this.javascript = false;
    }

    public boolean isUploadEnabled() {
        return this.upload.isEnabled();
    }

    public boolean isAddEnabled() {
        return this.add.isEnabled();
    }

    public boolean isRemoveEnabled() {
        return this.remove.isEnabled();
    }

    public int getButtonClicked() {
        return this.buttonClicked;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.add && this.add.isEnabled()) {
            this.addClick();
        }
        if (e.getSource() == this.upload && this.upload.isEnabled()) {
            this.uploadClick();
        }
        if (e.getSource() == this.remove && this.remove.isEnabled()) {
            this.removeClick();
        }
        if (e.getSource() == this.help && this.help.isEnabled()) {
            this.helpClick();
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(3);
        Transferable trans = dtde.getTransferable();
        try {
            int j;
            DataFlavor[] dataFlavour = dtde.getCurrentDataFlavors();
            Vector<File> filesFromDrop = new Vector<File>();
            boolean filesFound = false;
            while (!filesFound) {
                for (int i = 0; i < dataFlavour.length; ++i) {
                    File tempFile;
                    if (dataFlavour[i].isFlavorJavaFileListType()) {
                        System.out.println("Windows");
                        List listOfFiles = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                        Iterator iter = listOfFiles.iterator();
                        while (iter.hasNext()) {
                            tempFile = (File)iter.next();
                            filesFromDrop.add(tempFile);
                        }
                        filesFound = true;
                        continue;
                    }
                    if (!dataFlavour[i].equals(this.uriListFlavor)) continue;
                    BufferedReader in = new BufferedReader(dataFlavour[i].getReaderForText(trans));
                    String line = in.readLine();
                    while (line != null && line != "") {
                        try {
                            tempFile = new File(new URI(line));
                            filesFromDrop.add(tempFile);
                        }
                        catch (URISyntaxException usee) {
                        }
                        catch (IllegalArgumentException iae) {
                            // empty catch block
                        }
                        line = in.readLine();
                    }
                    filesFound = true;
                }
            }
            Object[] tempFiles = new File[filesFromDrop.size()];
            filesFromDrop.copyInto(tempFiles);
            Vector<Object> filesForUpload = new Vector<Object>();
            for (j = 0; j < tempFiles.length; ++j) {
                if (((File)tempFiles[j]).isDirectory()) {
                    File[] subDirFiles = ((File)tempFiles[j]).listFiles();
                    for (int k = 0; k < subDirFiles.length; ++k) {
                        if (!subDirFiles[k].isFile()) continue;
                        filesForUpload.add(subDirFiles[k]);
                    }
                    continue;
                }
                filesForUpload.add(tempFiles[j]);
            }
            if (this.files == null) {
                this.files = new File[0];
            }
            tempFiles = new File[filesForUpload.size() + this.files.length];
            for (j = 0; j < this.files.length; ++j) {
                tempFiles[j] = this.files[j];
            }
            for (j = 0; j < filesForUpload.size(); ++j) {
                tempFiles[j + this.files.length] = (File)filesForUpload.elementAt(j);
            }
            this.files = tempFiles;
            this.tableUpdate();
            if (this.files != null && this.files.length > 0) {
                this.upload.setEnabled(true);
                this.remove.setEnabled(true);
            }
            if (this.files != null && this.autoUpload) {
                this.uploadClick();
            }
        }
        catch (UnsupportedFlavorException usfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dtde.dropComplete(true);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

