/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class TableData
extends AbstractTableModel {
    Vector myTable;
    int colCount = 2;
    String[] headers = new String[]{"Filename", "Size - Kb"};
    int totalFileSize = 0;

    public TableData(String file, String size) {
        this.myTable = new Vector();
        this.headers[0] = file;
        this.headers[1] = size;
    }

    public String getColumnName(int i) {
        if (i == 1 && this.totalFileSize != 0) {
            double totalFileSizeMB = (double)this.totalFileSize / 10485.76;
            totalFileSizeMB = (double)Math.round(totalFileSizeMB) / 100.0;
            return this.headers[i] + " (" + totalFileSizeMB + "Mb)";
        }
        return this.headers[i];
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public int getRowCount() {
        return this.myTable.size();
    }

    public int getTotalFileSize() {
        return this.totalFileSize;
    }

    public Object getValueAt(int row, int col) {
        return ((Object[])this.myTable.elementAt(row))[col];
    }

    public void formatTable(String[][] data, int dataLength) {
        this.totalFileSize = 0;
        this.myTable = new Vector();
        for (int j = 0; j < dataLength; ++j) {
            Object[] row = new Object[this.colCount];
            for (int k = 0; k < this.colCount; ++k) {
                if (k == 1) {
                    try {
                        int thisFileSize = Integer.parseInt(data[j][k]);
                        this.totalFileSize += thisFileSize;
                        thisFileSize = (int)((double)thisFileSize / 102.4);
                        double thisFileKb = (double)thisFileSize / 10.0;
                        row[k] = new Double(thisFileKb);
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                row[k] = data[j][k];
            }
            this.myTable.addElement(row);
        }
        this.fireTableChanged(null);
    }
}

