<?php

//  basic.php -- basic standard functions
//
//  $Id: basic.php,v 1.1 2006/10/03 08:33:55 fstuurman Exp $
//
//  Copyright (C) 2004 Peter Fokker, <peter@berestijn.nl>
//
//  This file is part of Janitor.
//
//  Janitor is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  Janitor is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

// Based on code in MySQL/PHP Database Applications, Jay Greenspan & Brad Bulger, ISBN 0-7645-3537-4

// This file contains some useful standard functions.
// It #includes even more useful functions near the end
//
// string cleanup_text ($value, $preserve, $allowed_tags)
// string get_attlist ($atts, $defaults)
// strinf make_page_title ($title)
// void notimplemented ($module)
// string valid_date($date)

function cleanup_text($value = "", $preserve = "", $allowed_tags = "")
{
	/*-----------------------------------------------------------------------------
	 * This function uses the PHP function htmlspecialchars() to convert
	 * special HTML characters in the first argument (&,",',<, and >) to their 
	 * equivalent HTML entities. If the optional second argument is empty,
	 * any HTML tags in the first argument will be removed. The optional
	 * third argument lets you specify specific tags to be spared from
	 * this cleansing. The format for the argument is "<tag1><tag2>".
	 */
	if (empty ($preserve))
	{
		$value = strip_tags($value, $allowed_tags);
	}
	$value = htmlspecialchars($value);
	return $value;
	/*-----------------------------------------------------------------------------*/
} /* cleanup_text() */

function get_attlist($atts = "", $defaults = "")
{
	/*-----------------------------------------------------------------------------
	 * This function will take an associative array and format as a string
	 * that looks like ' name1="value1" name2="value2"', as is used by HTML tags.
	 * Values for keys in the first argument will override values for the
	 * same keys in the second argument. (For example, if $atts is (color=>red)
	 * and $defaults is (color=>black, size=3), the resulting output will
	 * be 'color="red" size="3"'.) Note the leading space.
	 */
	$localatts = array ();
	$attlist = " ";

	if (is_array($defaults))
	{
		$localatts = $defaults;
	}
	if (is_array($atts))
	{
		$localatts = array_merge($localatts, $atts);
	}

	while (list ($name, $value) = each($localatts))
	{
		if ($value == "")
		{
			$attlist .= "$name ";
		}
		else
		{
			$attlist .= "$name=\"$value\" ";
		}
	}
	return rtrim($attlist);
	/*-----------------------------------------------------------------------------*/
} /* get_attlist() */

function make_page_title($title = "")
{
	/*-----------------------------------------------------------------------------
	 * This function will clean up a string to make it suitable for use
	 * as the value of an HTML <TITLE> tag, removing any HTML tags and
	 * replacing any HTML entities with their literal character equivalents.
	 */
	$title = cleanup_text($title);
	$trans = array_flip(get_html_translation_table(HTML_ENTITIES));
	$title = strtr($title, $trans);
	return $title;
	/*-----------------------------------------------------------------------------*/
} /* make_page_title() */

function notimplemented($module = '')
{
	/*----------------------------------------------------------------------------
	 * This function prints a string "Function ... not implemented"
	 */
	$msg = "<html>\n<head><title>" . APP_NAME . " - " . __("Function Not Implemented") . "</title></head>\n" .
	"<body bgcolor=\"" . APP_BGCOLOR . "\">\n" .
	"<h2>" . sprintf(__("Function '%s' not implemented (yet)"), $module) . "</h2>\n" .
	"<h3>" . anchor_tag($GLOBALS['PHP_SELF'], $GLOBALS['PHP_SELF']) . "</h3>\n" .
	"</body>\n" .
	"</html>\n";
	die($msg);
	/*-----------------------------------------------------------------------------*/
} /* notimplemented() */

function valid_date($d)
{
	/*-----------------------------------------------------------------------------
	 * Validate date $d, return string yyyy-mm-dd if valid, or "" if not
	 * Thanks to the PHPbuilder.Com forum 2001-07-25
	 */
	$output = "";
	if (ereg('([0-9]{4})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})', $d, $v))
	{
		if (checkdate($v[2], $v[3], $v[1]))
		{
			$output = sprintf("%04d-%02d-%02d", $v[1], $v[2], $v[3]);
		}
	}
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* valid_date() */

include ("html.php");
include ("forms.php");
include ("tables.php");

/*----- eof basic.php -----*/
?>
