<?php

###############################################################################
#                    ALLbum-1.0.0: shared.inc.php                             #
#                    (shared functions component)                             #
#                                                                             #
# ALLbum is a module for the Content Management System                        #
# "Site@School"  (http://siteatschool.sourceforge.net).                       #
#                                                                             #
# ALLbum is written by Martin Herrman <m.herrman@student.tue.nl>              #
# ALLbum is copyrighted by OBS Rosa Boekdrukker, Amsterdam, The Netherlands   #
# (http://www.rosaboekdrukker.nl)                                             #
# ALLbum is licenced by GNU General Public Licence                            #
#                                                                             #
###############################################################################
# shared.inc.php: last changed 05/10/2006 2.4.10                              #  
#                    by Fred Stuurman (fc.stuurman@hccnet.nl)
#$Id: shared.inc.php,v 1.2 2006/10/15 19:08:54 fstuurman Exp $                 #
###############################################################################
#                                                                             #
#                            LICENCE INFORMATION                              #
#                                                                             #
# Copyright (c) 2003-2006, OBS Rosa Boekdrukker, Amsterdam, The Netherlands.  #
#                                                                             #
# This program is free software, you can redistribute it and/or               #
# modify it under the terms of the GNU General Public License                 #
# as published by the Free Software Foundation; either version 2              #
# of the License, or (at your option) any later version.                      #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                        #
# See the GNU General Public License for more details.                        #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program; if not, write to the Free Software                 #
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. #
###############################################################################
#                                                                             #
# Change marked YVO: Added category to all links!!                            #
#                                                                             #
###############################################################################
if (!defined('IN_SAS'))
{
	die("Hacking attempt");
}

$site = $_SESSION['site'];

// get Allbum table:
global $table_modules;
$query = "SELECT dbtables FROM " . $table_modules . " WHERE location='sn_allbum'";
$result = mysql_query($query) or die(mysql_error() . $query);
$moduletables = mysql_result($result, 0);
$moduletables = explode(",", $moduletables);
$allbum_table = $moduletables[0];

################################################################################

function db_GetAllbumToPage($pagetitle)
{
	global $allbum_table;
	$query = "SELECT id FROM $allbum_table WHERE title = '$pagetitle' AND ispage = '1'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	$RecordCount = mysql_num_rows($result);
	if ($RecordCount == 1)
	{
		return mysql_result($result, 0);
	}
	else
	{
		return 0;
	}
}

function db_GetHidden($ID)
{
	// Task: return the value of the hidden field for the object
	// with id $ID

	global $allbum_table;

	$query = "SELECT hidden FROM $allbum_table WHERE id = '$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	return mysql_result($result, 0);
}

function ShowPreviousNext($id, $current_page, $numobjects, $maxperpage, $numperrow, $bool)
//ShowPreviousNext(0, 1, 4, 12, 2, false)
{
	// Task: render previous and next images for navigation if previous and next
	// page exists in (sub)-album.
	// $bool indicates if ShowPreviousNext is called from sas_admin or sas_index:
	// $bool = true => sas_index
	// $bool = false => sas_admin

	global $navpath;
	if (IsSet ($_GET['navpath']))
	{
		$navpath = $_GET['navpath'];
	}

	if ($bool)
	{
		global $page, $cmsdir;
		global $section;
		// YVO: added category
		global $category;
	}
	else
	{
		global $module;
		global $sas_lang;
	}

	if ($current_page > 1)
	{
		$previous_exists = "true";
		$prev = $current_page -1;
	}
	else
	{
		$previous_exists = "false";
	}

	if ($current_page * $maxperpage < $numobjects)
	{
		$next_exists = "true";
		$next = $current_page +1;
	}
	else
	{
		$next_exists = "false";
	}

	// Calculate the highest page number:
	$highest = round(ceil($numobjects / $maxperpage));

	echo "<tr><td colspan=\"" . $numperrow . "\" align=\"center\">";

	if ($previous_exists == "true")
	{
		if ($bool)
		{
			// YVO: added category
			echo "<a href=\"index.php?page=" . $page . "&section=" . $section . "&category=" . $category . "&ID=" . $id . "&navpath=" . $navpath . "&gallerypage=" . $prev . "\"><img border=\"0\" src=\"$cmsdir/modules/sn_allbum/nav_prev_icon.gif\"></a>";
		}
		else
		{
			echo "<a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&ID=" . $id . "&navpath=" . $navpath . "&gallerypage=" . $prev . "\"><img border=\"0\" src=\"modules/sn_allbum/nav_prev_icon.gif\"></a>";
		}
	}
	else
	{
		if ($bool)
		{
			echo "<img border=\"0\" src=\"$cmsdir/modules/sn_allbum/nav_dummy.gif\">";
		}
		else
		{
			echo "<img border=\"0\" src=\"modules/sn_allbum/nav_dummy.gif\">";
		}
	}

	$i = 1;
	echo "&nbsp;";
	while ($i <= $highest)
	{
		if ($i == $current_page)
		{
			$showi = "<font color=\"green\">[" . $i . "]</font>";
		}
		else
		{
			$showi = "[" . $i . "]";
		}
		if ($bool)
		{
			// YVO: added category
			echo "<span class=\"link\"><a href=\"index.php?page=" . $page . "&navpath=" . $navpath . "&section=" . $section . "&category=" . $category . "&ID=" . $id . "&gallerypage=" . $i . "\">" . $showi . "</a></span>";
		}
		else
		{
			echo "<span class=\"link\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&ID=" . $id . "&navpath=" . $navpath . "&gallerypage=" . $i . "\">" . $showi . "</a>";
		}
		echo "&nbsp;";
		$i++;
	}

	if ($next_exists == "true")
	{
		if ($bool)
		{
			// YVO: added category
			echo "<a href=\"index.php?page=" . $page . "&section=" . $section . "&category=" . $category . "&ID=" . $id . "&navpath=" . $navpath . "&gallerypage=" . $next . "\">
					<img border=\"0\" src=\"$cmsdir/modules/sn_allbum/nav_next_icon.gif\"></a>";
		}
		else
		{
			echo "<a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=show&ID=" . $id . "&navpath=" . $navpath . "&gallerypage=" . $next . "\">
				<img border=\"0\" src=\"modules/sn_allbum/nav_next_icon.gif\"></a>";
		}
	}
	else
	{
		if ($bool)
		{
			echo "<img border=\"0\" src=\"$cmsdir/modules/sn_allbum/nav_dummy.gif\">";
		}
		else
		{
			echo "<img border=\"0\" src=\"modules/sn_allbum/nav_dummy.gif\">";
		}
	}

	echo "</td></tr>";

}

function db_GetTitle($ID)
{
	// Task: return title for object with id $ID

	global $allbum_table;

	$query = "SELECT title FROM $allbum_table WHERE id='$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	return mysql_result($result, 0);
}

function ShowNavPath($navpath, $bool)
{
	// Task: show navigation path containing links to object
	// id's in $navpath. $navpath is a list, were items are
	// seperated by a ','.
	// $bool indicates if ShowNavPath is called from sas_admin or sas_index:
	// $bool = true => sas_index
	// $bool = false => sas_admin

	global $sas_lang;

	// convert to an array and remove empty elements:
	$navpath = explode(",", $navpath);
	$navpath = array_clean($navpath, "");

	// start output:
	echo "<p><span class=\"link\">" . $sas_lang['sn_allbum_return_to'];

	// show link to main page:
	if ($bool)
	{
		global $page;
		global $section;
		// YVO: added category
		global $category;
		echo "<a href=\"index.php?page=" . $page . "&section=" . $section . "&category=" . $category . "\">" . $sas_lang['sn_allbum_main'] . "</a>";
	}
	else
	{
		global $module;
		echo "<a href=\"index.php?option=modulemanager&module=" . $module . "\">" . $sas_lang['sn_allbum_main'] . "</a>";
	}

	// show other links:
	if (IsSet ($navpath))
	{
		foreach ($navpath AS $key => $value)
		{
			$title = db_GetTitle($value);
			$newnavpath = $navpath;
			$newnavpath = array_clean($newnavpath, "");
			$tmp = array ();
			for ($i = 0; $i == $key -1; $i++)
			{
				array_push($tmp, $newnavpath[$i]);
			}
			if ($tmp != "")
			{
				$newnavpath = implode(",", $tmp);
			}
			if ($bool)
			{
				// YVO: added category
				echo " -> <a href=\"index.php?page=" . $page . "&section=" . $section . "&category=" . $category . "&navpath=" . $newnavpath . "&ID=" . $value . "&gallerypage=1\">" . $title . "</a>";
			}
			else
			{
				echo " -> <a href=\"index.php?option=modulemanager&module=" . $module . "&navpath=" . $newnavpath . "&suboption=show&ID=" . $value . "&gallerypage=1\">" . $title . "</a>";
			}
		}
	}

	// end output:
	echo "</span></p>";
}

function UpdateDatabaseAlbumOrd()
{
	// Task: check parent field for main albums; if the list does not
	// start with 1 and is ascending without gaps, correct this such
	// that the albums are ordered in the same order.

	$mainalbums = db_GetContents(0);
	$albumparentarray = array ();
	foreach ($mainalbums AS $key => $value)
	{
		$albumparentarray[$value] = db_GetParentID($value);
	}
	asort($albumparentarray);
	$i = 1;
	foreach ($albumparentarray AS $key => $value)
	{
		if ($i != $value)
		{
			$albumparentarray[$key] = $i;
		}
		$i++;
	}
	foreach ($albumparentarray AS $key => $value)
	{
		db_PutParent($key, $value);
	}
}

function db_PutIfNeededUpdateParentThumb($parent)
{
	// Task: 
	// $parent must be a (sub-)album.
	// if path./.thumbnail of $parent points to a non-existing
	// image or thumbnail is the empty icon, try to find a new candidate. 
	// If it can't be found, use the empty icon.
	// Make sure this is done for all parents (recursion), until 
	// a parent is found that does not need to be updated.

	$path = db_GetPath($parent);
	$thumb = db_GetThumb($parent);

	if (!file_exists(str_replace("//", "/", $path . "/" . $thumb)))
	{
		// try to find another candidate (might be available in a sub-album, use that sub-albums thumb then):
		// - get contents of this parent:
		$contents_array = db_GetContents($parent);
		if (count($contents_array) != 0)
		{
			// - a candidate exists, use (if it exists) the first one that has not the empty icon :
			$i = 0;
			while ($i < count($contents_array))
			{
				if (db_GetThumb($contents_array[$i]) != "modules/sn_allbum/empty.gif")
				{
					$candidate = $contents_array[$i];
					break;
				}
				$i++;
			}
			// use new candidate:
			$candidate_info = db_GetAllDetails($candidate);

			$fullpath = "";
			// - candidate can be a (sub)album (thumb field contains a path/file):
			if (($candidate_info[0] == "subalbum") OR ($candidate_info[0] == "album"))
			{
				$fullpath = str_replace("//", "/", $candidate_info[3] . "/" . $candidate_info[4]);

				// - candidate can be a picture (thumb field is empty):
			}
			elseif ($candidate_info[0] == "picture")
			{
				$fullpath = str_replace("//", "/", $candidate_info[3] . "/" . $candidate_info[4]);

				// - candidate can be an other object type (thumb field contains an icon):
			}
			else
			{
				db_PutThumb($parent, $candidate_info[4]);
			}
			if ($fullpath != "")
			{
				// * calculate thumb field for parent

				// - put it in an array:
				$fullpath = explode("/", $fullpath);
				// - compare it with parent's path, to calculate what must
				//   be put in parent's thumb field:
				$length_parent_path = count(explode("/", $path));
				for ($i = 1; $i <= $length_parent_path; $i++)
				{
					array_shift($fullpath);
				}
				$fullpath = implode("/", $fullpath);
				db_PutThumb($parent, $fullpath);
			}

		}
		else
		{
			// - no candidate exists, use empty.gif:
			db_PutThumb($parent, "modules/sn_allbum/empty.gif");
		}

		// do the same for parent's parent:
		if (db_GetType($parent) != "album")
		{
			$new_parent = db_GetParentID($parent);
			db_PutIfNeededUpdateParentThumb($new_parent);
		}
	}

}

function DeleteContents($id)
{
	// Task: delete contents of (sub-)album with id $id
	$contents_array = db_GetContents($id);
	$contents_string = implode(",", $contents_array);
	db_PutDeleteObjects($contents_string);
}

function db_GetContents($ID)
{
	// Task: return the id's for all objects that are
	// located in (sub)-album with id $ID.
	// When $ID = 0, -1 or "", return the id's of all main albums

	global $allbum_table;

	if (($ID == 0) OR ($ID == "") OR (ID == -1))
	{
		$query = "SELECT id FROM $allbum_table WHERE type='album' ORDER BY parent";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$array = array ();
		while ($temp = mysql_fetch_array($result))
		{
			array_push($array, $temp[0]);
		}
		return $array;
	}
	else
	{
		$query = "SELECT children FROM $allbum_table WHERE id='$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$result = mysql_result($result, 0);
		$result = explode(",", $result);
		if ($result[0] == "")
		{
			$result = array ();
		}
		return $result;
	}
}

function DeleteDirectory($id)
{
	// Task: delete directory of (sub-)album with object $id
	$path = db_GetPath($id);
	rmdir($path);
}

function RemoveDatabaseEntry($id)
{
	// Task: remove database entry of object with id $id

	global $allbum_table;

	$query = "DELETE FROM $allbum_table WHERE id='$id'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function DeleteFiles($id)
{
	// Task: delete files for object (not a (sub-)album) with id $id

	$file_info = db_GetAllDetails($id);
	// array(type, title, description, path, thumb, parent, children, hidden)

	$file = str_replace("//", "/", $file_info[3] . "/" . $file_info[4]);
	if (file_exists($file))
	{
		unlink($file);
	}

	$tmp = explode(".", $file_info[4]);
	$ext = array_pop($tmp);
	$name = implode(".", $tmp);
	$thumb = str_replace("//", "/", $file_info[3] . "/" . $name . "_t." . $ext);
	if (file_exists($thumb))
	{
		unlink($thumb);
	}
}

function UpdateParentListOfChildren($ID, $parent)
{
	// Task: remove $ID from the list of children from $ID's 
	// parent with id $parent

	$children = db_GetChildren($parent);

	// - remove child from parent's list of children
	$children = explode(",", $children);
	$children = array_clean($children, $ID);
	if (count($children) == 0)
	{
		$children = "";
	}
	else
	{
		$children = implode(",", $children);
	}

	// - update parent's list of children
	db_PutChildren($parent, $children);
}

#### Get Object-information ####

function db_GetThumb($ID)
{
	// Task: return thumb field of object with id $ID

	global $allbum_table;

	$query = "SELECT thumb FROM $allbum_table WHERE id='" . $ID . "'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	return mysql_result($result, 0);
}

function db_GetChildren($ID)
{
	// Task: for object with id $ID, get the list of children,
	// return a string.

	global $allbum_table;

	$query = "SELECT children FROM $allbum_table WHERE id='$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	return mysql_result($result, 0);
}

function db_GetType($ID)
{
	// Task: return type of object with id $ID

	global $allbum_table;

	if (($ID == 0) OR ($ID == ""))
	{
		return 'main';
	}
	else
	{
		$query = "SELECT type FROM $allbum_table WHERE id='$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		return mysql_result($result, 0);
	}
}

function db_GetPath($id)
{
	// Task: for object with id $id, return it's path field

	global $allbum_table;

	$query = "SELECT path FROM $allbum_table WHERE id='$id'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	return mysql_result($result, 0);
}

function db_GetParentID($ID)
{
	// Task: for object with id $ID, return the id of its parent

	global $allbum_table;

	$query = "SELECT parent FROM $allbum_table WHERE id='$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	return mysql_result($result, 0);
}

function db_GetAllDetails($ID)
{
	// Task: return an array with all details of the object with id $ID:
	// array[type, title, description, path, thumb, parent, children, hidden]
	// If $ID == 0, then the details of a main page are requested. In
	// that case, return array[0 => 'main'].

	global $allbum_table, $site;

	if ($ID == 0)
	{
		$result = array (
			'main'
		);
		return $result;
	}
	else
	{
		$query = "SELECT type, title, description, path, thumb, parent, children, hidden, ispage, id, public FROM $allbum_table WHERE id='$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$result = mysql_fetch_array($result);
		return $result;
	}
}

function db_PutChildren($ID, $children)
{
	// Task: for object with id $ID, put the list of children $children

	global $allbum_table;

	$query = "UPDATE $allbum_table SET children = '$children' WHERE id='$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function db_PutParent($ID, $parent)
{
	// Task: for object with id $ID, put the list of parent $parent

	global $allbum_table;

	$query = "UPDATE $allbum_table SET parent = '$parent' WHERE id='$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function db_PutThumb($id, $thumb)
{
	// Task: for object with id $id, update thumb field with $thumb

	global $allbum_table;

	$thumb2 = addslashes($thumb);
	$query = "UPDATE $allbum_table SET thumb = '$thumb2' WHERE id = '$id'";
	mysql_query($query) or die(mysql_error() . $query);
}

#### Other functions ####

function array_clean($input, $delete = false, $caseSensitive = false)
{
	// This function has been posted by redshift@pandora.be at 28-Jun-2003 06:01
	// on the following URL: http://nl.php.net/manual/en/function.array-filter.php
	$i = 0;
	while ($i < count($input))
	{
		if ($delete)
		{
			if ($caseSensitive)
			{
				if (!strstr($input[$i], $delete))
				{
					$return[] = $input[$i];
				}
			}
			else
			{
				if (!stristr($input[$i], $delete))
				{
					$return[] = $input[$i];
				}
			}
		}
		else
		{
			if (!empty ($input[$i]))
			{
				$return[] = $input[$i];
			}
		}
		$i++;
	}
	if (IsSet ($return))
	{
		return $return;
	}
}

function ListThumb($image)
{
	$tmp = explode(".", $image);
	$ext = array_pop($tmp);
	$name = implode(".", $tmp);
	$thumb = $name . "_t." . $ext;
	return $thumb;
}

function MakeThumb($thumb, $image)
{
	global $sas_config;
	if (file_exists($thumb))
	{
		// thumbnail exists
		return $thumb;
	}
	else
	{
		set_time_limit(30);
		// thumbnail does not exist
		if (function_exists('imagecreatetruecolor'))
		{
			// use gdlib to resize images      
			//print "GDlib exists making $thumb";  
			//exit;
			$size = getimagesize($image);
			$x = $size[0];
			$y = $size[1];
			if ($x < $y)
			{
				$newy = $sas_config['allbum_thumbsize_x'];
				$newx = $x / ($y / $newy);
			}
			else
			{
				$newx = $sas_config['allbum_thumbsize_x'];
				$newy = $y / ($x / $newx);
			}
			$tmp = explode(".", $image);
			$ext = array_pop($tmp);

			if (($ext == "jpg") or ($ext == "JPG"))
			{
				$src_img = imagecreatefromjpeg($image);
				$dst_img = ImageCreateTrueColor($newx, $newy);
				imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $newx, $newy, $x, $y);
				imagejpeg($dst_img, $thumb, "100");
				imagedestroy($src_img);
				imagedestroy($dst_img);
				return $thumb;
			}
			elseif (($ext == "png") or ($ext == "PNG"))
			{
				$src_img = imagecreatefrompng($image);
				$dst_img = ImageCreateTrueColor($newx, $newy);
				imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $newx, $newy, $x, $y);
				imagepng($dst_img, $thumb, "9"); //changed for php 5.x from 100 -> 9
				imagedestroy($src_img);
				imagedestroy($dst_img);
				return $thumb;
			}
			else
			{
				return $image;
			}
		}
		elseif (function_exists("imagick_readimage"))
		{
			// use imagemagick to resize images
			$size = getimagesize($image);
			$x = $size[0];
			$y = $size[1];
			if ($x < $y)
			{
				$newy = $sas_config['allbum_thumbsize_x'];
				$newx = $x / ($y / $newy);
			}
			else
			{
				$newx = $sas_config['allbum_thumbsize_x'];
				$newy = $y / ($x / $newx);
			}
			$handle = imagick_readimage($image);
			imagick_scale($handle, $newx, $newy, "!");
			imagick_writeimage($handle, $humb);
			imagick_free($handle);
			return $thumb;
		}
		else
		{
			// can't resize images, use large images instead
			return $image;
		}
	}
}

function db_GetVisibleContents($ID, $mode)
{
	// Task: return the id's for all objects that are
	// located in (sub)-album with id $ID.
	// Objects that are tagged hidden must not be returned.
	// When $ID = 0, return the id's of all main albums
	// Return the result in an array.
	// $mode is 0 when coming from album per page

	global $allbum_table, $site, $sas_config;

	if ($ID == 0)
	{
		if ($site == "protected")
		{
			$where = " AND public = 1"; //only show allbums with public 1
		}
		else
		{
			$where = " AND public = 0"; //only show allbums with public 0
		}

		if ($mode == 0)
		{
			$query = "SELECT id, hidden FROM $allbum_table WHERE type='album' $where ORDER BY parent";
		}
		else
		{
			if ($sas_config[allbum_reverse_order] == 1) //show last added allbum first?
			{
				$query = "SELECT id, hidden FROM $allbum_table WHERE type='album' $where AND ispage = 0 ORDER BY (parent+0) DESC";
			}
			else
			{
				$query = "SELECT id, hidden FROM $allbum_table WHERE type='album' $where AND ispage = 0 ORDER BY (parent+0)";
			}
		}
		$result = mysql_query($query) or die(mysql_error() . $query);
		$array = array ();
		while ($temp = mysql_fetch_array($result))
		{
			if ($temp[1] == 0)
			{
				array_push($array, $temp[0]);
			}
		}
		return $array;
	}
	else
	{
		$query = "SELECT children FROM $allbum_table WHERE id='$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$result = mysql_result($result, 0);
		$result = explode(",", $result);
		$visible_children = array ();
		if ($result[0] == "")
		{
			return $visible_children;
		}
		else
		{
			foreach ($result AS $key => $value)
			{
				if (db_GetHidden($value) == 0)
				{
					array_push($visible_children, $value);
				}
			}
			if ($visible_children[0] == "")
			{
				$visible_children = array ();
			}
			return $visible_children;
		}
	}
}

function ShowContent($ID, $gpage, $mode)
{
	// Task: show object with ID $ID, unless it is a hidden object.
	// - When $ID = 0, then a main page must be shown;
	// - When $ID is a (sub-)album, it's contents must be shown;
	// - When $ID is not a (sub-)album or a main page, $gpage is -1. Otherwise,
	//   $gpage is the page number that must be shown.
	//   $mode is 0 when coming from album per page

	global $sas_lang;
	global $page;
	global $sas_config;
	global $section;
	// YVO: added category
	global $category, $allbum_table;
	global $navpath, $cmsdir;
	if (IsSet ($_GET['navpath']))
	{
		$navpath = $_GET['navpath'];
	}
	// Get all details:
	// array[type, title, description, path, thumb, parent, children, hidden]
	$details = db_GetAllDetails($ID);

	// Check if object is hidden:
	if (IsSet ($details[7]) AND ($details[7] == 1))
	{
		// Show 'object is hidden' page:
		echo "<p><span class=\"heading\">" . $sas_lang['sn_allbum_object_hidden'] . "</span></p>";
		echo "<p><span class=\"text\">" . $sas_lang['sn_allbum_object_hidden_text'] . "</span></p>";
		return 0;
	}
	else
	{
		// show navigation path:
		if (IsSet ($_GET['navpath']))
		{
			ShowNavPath($_GET['navpath'], TRUE);
		}
	}

	$objects = array (
		'sound',
		'movie',
		'doc',
		'unknown',
		'picture'
	);

	if (in_array($details[0], $objects))
	{

		// **sound-file, movie-file, document-file, unknown-file, picture-file**

		// calculate next and previous object in this (sub-)album:
		$albumcontents = array_clean(explode(",", $_GET['contents']), "");
		$i = 0;
		while ($albumcontents[$i] != $ID)
		{
			$i++;
		}
		if ($i == count($albumcontents) - 1)
		{
			$nextobjectid = $albumcontents[0];
		}
		else
		{
			$nextobjectid = $albumcontents[$i +1];
		}
		if ($i == 0)
		{
			$prevobjectid = $albumcontents[count($albumcontents) - 1];
		}
		else
		{
			$prevobjectid = $albumcontents[$i -1];
		}

		// start table
		echo "<table width=\"95%\" align=\"center\" border=\"0\">";

		// show row with buttons for (next object, title, previous object) in this (sub-)album:
		if ($details[0] == "picture")
		{
			// do not show the title's extension:
			$title = explode(".", $details[1]);
			array_pop($title);
			$title = implode(".", $title);
		}
		else
		{
			$title = $details[1];
		}
		echo "<tr>";
		echo "<td align=\"center\">";
		// YVO: added category
		echo "<a href=\"index.php?page=" . $page . "&navpath=" . $_GET['navpath'] . "&contents=" . $_GET['contents'] . "&section=" . $section . "&category=" . $category . "&ID=" . $prevobjectid . "&gallerypage=1\">
		<img border=\"0\" title=\"" . $sas_lang['sn_allbum_previous_object'] . "\" src=\"$cmsdir/modules/sn_allbum/nav_prev_icon.gif\"></a>";
		echo "<span class=\"heading\">" . $title . "</span>";
		echo "&nbsp;&nbsp;<a href=\"index.php?page=" . $page . "&navpath=" . $_GET['navpath'] . "&contents=" . $_GET['contents'] . "&section=" . $section . "&category=" . $category . "&ID=" . $nextobjectid . "&gallerypage=1\">
		<img border=\"0\" title=\"" . $sas_lang['sn_allbum_next_object'] . "\" src=\"$cmsdir/modules/sn_allbum/nav_next_icon.gif\"></a>";
		echo "</td>";
		echo "</tr>";

		// Show (image) or (thumb, download link):
		echo "<tr>";
		echo "  <td>";
		if ($details[0] == "picture")
		{
			// calculate cell-width:
			$width = $sas_config['allbum_picsize_x'];
			//$width = db_GetPicSizeX();
			$image = str_replace("//", "/", "$cmsdir/" . $details[3] . "/" . $details[4]);
			$size = getimagesize($image);
			if ($size[0] < $size[1])
			{
				// portrait
				$width = $width / 1.3;
			}
			// show image
			echo "    <div align=\"center\"><img width=\"" . $width . "\" src=\"" . $image . "\"></div>";
		}
		else
		{
			// show thumb, download link
			$iconpath = str_replace("//", "/", "$cmsdir/" . $details[4]);
			$filepath = str_replace("//", "/", "$cmsdir/" . $details[3] . "/" . $details[1]);
			echo "  <div align=\"center\"><img src=\"" . $iconpath . "\"></div>";
			echo "  <div align=\"center\"><p><span class=\"link\"><a href=\"" . $filepath . "\">" . $sas_lang['sn_allbum_download_file'] . "</a></span></p></div>";
		}
		echo "  </td>";
		echo "</tr>";

		// Show description
		echo "<tr>";
		echo "<td colspan=\"2\" align=\"center\">";
		echo "<span class=\"text\">" . $details[2] . "</span></p>";
		echo "</td>";
		echo "</tr>";
		// YVO: added category
		print "<tr><td align=\"center\">
					<a href=\"index.php?page=" . $page . "&navpath=" . $navpath . "&contents=" . $_GET['contents'] . "&section=" . $section . "&category=" . $category . "&ID=" . $prevobjectid . "&gallerypage=1\">
				  <img border=\"0\" title=\"" . $sas_lang['sn_allbum_previous_object'] . "\" src=\"$cmsdir/modules/sn_allbum/nav_prev_icon.gif\"></a>
				  <a href=\"index.php?page=" . $page . "&navpath=" . $navpath . "&contents=" . $_GET['contents'] . "&section=" . $section . "&category=" . $category . "&ID=" . $nextobjectid . "&gallerypage=1\">
				  <img border=\"0\" title=\"" . $sas_lang['sn_allbum_next_object'] . "\" src=\"$cmsdir/modules/sn_allbum/nav_next_icon.gif\"></a>
				  </td>
				  </tr>";
		// end table
		echo "</table>";

		return 0;
	}

	$objects = array (
		'album',
		'subalbum'
	);

	if (in_array($details[0], $objects))
	{
		// **(sub-)album**
		// Show title and description:
		echo "<table width=\"100%\"><tr><td><span class=\"heading\">" . $details[1] . "</span></td>";
		//see if we have pictures in the album
		$query = "SELECT id FROM $allbum_table WHERE parent = '$ID' and type = 'picture'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$RecordCount = mysql_num_rows($result);
		if ($RecordCount > 0) //if so display the slideshow link.
		{
			echo "<td align=\"right\"><span class=\"text\">
						<a href=\"index.php?page=" . $page . "&section=" . $section . "&category=" . $category . "&option=slideshow&ID=" . $ID . "\" alt=\"Slideshow\" title=\"slideshow\">
						" . $sas_lang['sn_allbum_show_slideshow'] . "</a></span></td></tr>";
		}
		echo "<tr><td colspan=\"2\"><span class=\"text\">" . $details[2] . "</span></td></tr></table>";

		// Start table:
		echo "<table width=\"98%\" border=\"0\">";

		// Get the id's of all objects in (sub-)album with id $ID:
		// (an array is returned)
		$contents = db_GetVisibleContents($ID, $mode);

		// Check if the list of children is empty:
		$num = count($contents);
		if ($num == 0)
		{
			echo "<tr><td colspan=\"2\"><p><span class=\"text\">" . $sas_lang['sn_allbum_empty_album'] . "</span></p></td></tr>";
		}
		else
		{
			// Calculate which children should be shown on page $gpage:
			$show = array ();
			$max_objects_per_page = $sas_config['allbum_max_objects_per_page'];
			for ($i = (($gpage -1) * $max_objects_per_page) + 1;($i <= ($gpage * $max_objects_per_page)) AND ($i <= $num); $i++)
			{
				array_push($show, $contents[$i -1]);
			}

			// make a ?-dimensional array of $show (depending on the configuration option):
			$numperrow = $sas_config['allbum_num_objects_per_row'];
			$showmultipledimensions = array_chunk($show, $numperrow);

			// Show each object:
			$x = $sas_config['allbum_thumbsize_x'];
			$w = 100 / $numperrow;
			foreach ($showmultipledimensions AS $key => $value)
			{

				echo "<tr>";
				$j = $numperrow;
				$i = 0;
				while ($i < $j)
				{
					// Show object (if available):
					if (IsSet ($value[$i]))
					{
						RenderSubAlbumImageCell($value[$i], $x, $numperrow, $navpath . "," . $ID, implode(",", $contents));
					}
					else
					{
						// Show empty cell:
						echo "<td width=\"" . $w . "\">&nbsp;</td>";
					}
					$i++;
				}
				echo "</tr>";

				echo "<tr>";
				$i = 0;
				while ($i < $j)
				{
					// Show object (if available):
					if (IsSet ($value[$i]))
					{
						RenderSubAlbumTitleCell($value[$i]);
					}
					else
					{
						// Show empty cell:
						echo "<td>&nbsp;</td>";
					}
					$i++;
				}
				echo "</tr>";

				// show empty row for some extra space:
				echo "<tr><td colspan=\"" . $numperrow . "\">&nbsp;</td></tr>";

			}

			ShowPreviousNext($ID, $gpage, $num, $max_objects_per_page, $numperrow, true);

		}

		// End table
		echo "</table>";

		return 0;

	}

	if ($details[0] == 'main')
	{

		// **main-page**

		// show page title:
		echo "<p><span class=\"heading\">" . $sas_config['allbum_welcome'] . "</span></p>";

		// start table:
		echo "<table width=\"98%\">";

		// Get list of main albums:
		$contents = db_GetVisibleContents($ID, $mode);

		// Check if list of main albums is empty:
		$num = count($contents);

		if ($num == 0)
		{
			echo "<tr><td colspan=\"2\"><p><span class=\"text\">" . $sas_lang['sn_allbum_no_main_albums_avail'] . "</span></p></td></tr>";
		}
		else
		{
			// Calculate which albums should be shown on page $page:
			$show = array ();
			$max_objects_per_page = $sas_config['allbum_max_allbums_per_page'];
			for ($i = (($gpage -1) * $max_objects_per_page) + 1;($i <= ($gpage * $max_objects_per_page)) AND ($i <= $num); $i++)
			{
				array_push($show, $contents[$i -1]);
			}
			// Show each album:
			$x1 = $sas_config['allbum_thumbsize_x'];
			foreach ($show AS $key => $value)
			{

				// Get all details array(type, title, description, path, thumb, parent, children, hidden):
				$details = db_GetAllDetails($value);
				if (file_exists("$cmsdir/" . $details[4])) //thumb is a sound.gif, winmedia.gif etc
				{
					$path = "$cmsdir/" . $details[4];
				}
				else //thumb is a picture
					{
					$thumb = ListThumb("$cmsdir/" . $details[3] . "/" . $details[4]);
					if (file_exists($thumb))
					{
						$path = $thumb;
					}
					else
					{
						$image = "$cmsdir/" . $details[3] . "/" . $details[4];
						if (file_exists($image))
						{
							$path = MakeThumb($thumb, $image); //create the thumb
						}
						else
						{
							print $sas_lang['sn_allbum_err'] . $sas_lang['sn_allbum_file_not_exists'] . "<b>" . $image . "</b>";
						}
					}
				}
				// Show album:
				echo "<tr>
						        <td align=\"center\" width=\"40%\">
						          <a href=\"index.php?page=" . $page . "&section=" . $section . "&category=" . $category . "&navpath=" . $navpath . "&ID=" . $value . "&gallerypage=1\">
							    <img src=\"" . $path . "\" width=\"" . $x1 . "\"></a>
							    </td>
							    <td width=\"60%\">
							    <span class=\"text\">
							      <STRONG>" . $details[1] . "</STRONG>
							      <BR>" . $details[2] . "</span>
						        </td>
						      </tr>";
			}

			ShowPreviousNext($ID, $gpage, $num, $max_objects_per_page, 2, true);

		}
		// End table:
		echo "</table>";

		return 0;

	}
}

function RenderSubAlbumImageCell($id, $x, $numperrow, $navpath, $contents)
{
	// Task: render image cell for object with id $ID within a row in a (sub)-album.

	global $page;
	global $section, $cmsdir;
	// YVO: added category
	global $category;
	global $sas_lang;

	// Get all details array(type, title, description, path, thumb, parent, children, hidden) for first object:
	$details = db_GetAllDetails($id);
	if (file_exists("$cmsdir/" . $details[4])) //thumb is a sound.gif, winmedia.gif etc
	{
		$image = "$cmsdir/" . $details[4];
	}
	else
	{
		$thumb = ListThumb(str_replace("//", "/", $cmsdir . "/" . $details[3] . "/" . $details[4]));

		if (file_exists($thumb))
		{
			$image = $thumb;
		}
		elseif ($details[4] == "modules/sn_allbum/empty.gif")
		{
			$image = "$cmsdir/" . "modules/sn_allbum/empty.gif"; //empty allbum display empty.gif
		}
		else
		{
			$image = str_replace("//", "/", $cmsdir . "/" . $details[3] . "/" . $details[4]);
			if (file_exists($image))
			{
				$path = MakeThumb($thumb, $image); //create the thumb
			}
			else
			{
				print $sas_lang['sn_allbum_err'] . $sas_lang['sn_allbum_file_not_exists'] . "<b>" . $image . "</b>";
			}
		}
		$w = 100 / $numperrow;
		if (file_exists($image))
		{
			$size = getimagesize($image);
			if ($size[0] < $size[1])
			{
				// portrait image
				$x = $x / 1.3;
			}
		}
	}

	echo "<td align=\"center\" width=\"" . $w . "%\">
		    <a href=\"index.php?page=" . $page . "&navpath=" . $navpath . "&contents=" . $contents . "&section=" . $section . "&category=" . $category . "&ID=" . $id . "&gallerypage=1\">
			<img src=\"" . $image . "\" width=\"" . $x . "\" alt=\"" . $sas_lang['sn_allbum_alt_click'] . "\" title=\"" . $sas_lang['sn_allbum_alt_click'] . "\">
		    </a></td>";
}

function RenderSubAlbumTitleCell($id)
{
	// Task: render cell for object with id $id within a row in a (sub)-album.
	// Only show the title below the thumbnail.

	global $sas_lang;

	// Get some details array(type, title, description, path, thumb, parent, children, hidden) for first object:
	$details = db_GetAllDetails($id);

	echo "<td align=\"center\"><p><span class=\"text\">";
	if ($details[0] == "subalbum")
	{
		echo "<STRONG>" . $sas_lang['sn_allbum_album'] . ": " . $details[1] . "</STRONG>";
	}
	else
	{
		if (strpos($details[1], ".")) //object title has extention?
		{
			$tmp = explode(".", $details[1]);
			array_pop($tmp);
			$tmp = implode(".", $tmp);
			echo $tmp;
		}
		else
		{
			echo $details[1];
		}
	}
	echo "</span></p></td>";
}
?>