<?php

//  config.php -- program specific settings
//
//  $Id: config.php,v 1.1 2006/10/03 08:33:55 fstuurman Exp $
//
//  Copyright (C) 2004,2005 Peter Fokker, <peter@berestijn.nl>
//
//  This file is part of Janitor.
//
//  Janitor is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  Janitor is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// 2005-04-18/PF - updated version number to 0.9.5

define("APP_NAME", "Janitor");
define("APP_VERSION", "0.9.5");
define("APP_DATE", "2005-04-20");
define("APP_BGCOLOR", "#FFFFAF");
define("APP_TEXT", "#000000");
define("APP_LINK", "#0000CF");
define("APP_VLINK", "#0000CF");
define("APP_ALINK", "#FF0000");
define("APP_ERRCOLOR", "#FFAFAF");
define("APP_MSGCOLOR", "#FF3F3F");
define("APP_TITLECOLOR", "#CFCFCF");
define("APP_NAVCOLOR", "#CFCFCF");
define("APP_BUTCOLOR", "#CFCFFF");
define("APP_EDEXOK", "#CFCFFF"); // used in Edex import
define("APP_EDEXWARN1", "#FFFF6F"); // used in Edex import
define("APP_EDEXWARN2", "#FFCF6F"); // used in Edex import
define("APP_EDEXERR", "#FFAFAF"); // used in Edex import
define("PAGE_FOOTER", ""); // displayed on every page, if non-empty, including timestamp

define("ACTION_LOGIN", "login");
define("ACTION_LOGOUT", "logout");
define("ACTION_MENU", "menu");
define("ACTION_SCREEN", "screen");
define("ACTION_PROCESS", "process");
define("PARAM_SRC", "s");
define("PARAM_TGT", "t");
define("PARAM_USER", "u");
define("PARAM_GROUP", "g");
define("PARAM_ACTION", "action");
define("PARAM_BUTTON", "button");

define("BUTTON_SAVE", __(" Save "));
define("BUTTON_CANCEL", __(" Cancel "));
define("BUTTON_YES", __(" Yes "));
define("BUTTON_NO", __(" No "));
define("BUTTON_OK", __(" OK "));
define("BUTTON_DELETE", __(" Delete "));
define("BUTTON_MOVE", __(" Move "));
define("BUTTON_START", __(" Start "));
define("BUTTON_REFRESH", __(" Refresh "));
define("BUTTON_UPLOAD", $sas_lang['uploadfile']);
define("BUTTON_RECALC", $sas_lang['recalculate']);
define("BUTTON_GENERATE", $sas_lang['generate']);

define("ACTION_USERGROUP", "usersgroups");
define("ACTION_SHORTCUTS", "shortcuts");
define("ACTION_REGEDIT", "regedit");
define("ACTION_MAKEISO", "makeiso");
define("ACTION_UG_OVERVIEW", "overview");
define("ACTION_UG_GROUPADD", "groupadd");
define("ACTION_UG_GROUPDEL", "groupdel");
define("ACTION_UG_USERADD", "useradd");
define("ACTION_UG_USERMOD", "usermod");
define("ACTION_UG_USERDEL", "userdel");
define("ACTION_UG_GROUPEDIT", "ugedit");
$tempfile = $sas_config['serverpath'] . $sas_config['user_path'] . "/" . $sas_config['media_dir'];
define("SESSION_SAVEPATH", $tempfile);
define("EXTRA_FIELDS", 5);
define("EXTRA_GROUPS", 32);
define("SPARE_GROUPS", 3);
define("EMAIL_ALIASES", 5);

// See $fileformat and $fieldlist in edex.php for more information
// on $edex_defaults and related parameters.
$edex_defaults = array (
		0 => 1, // default fileformat: 1=Fixed Record Length
	1 => array (
		81,
		5,
		1
		), // unique key
	2 => array (
		51,
		20,
		2
		), // first name
	3 => array (
		41,
		10,
		3
		), // infix
	4 => array (
		1,
		40,
		4
		), // last name
	5 => array (
		86,
		5,
		5
		), // grade (class)
	6 => array (
		0,
		0,
		6
		), // birthday (CSV only)
	7 => array (
		77,
		2,
		0
		), // dob.year (Fixed only)
	8 => array (
		74,
		2,
		0
		), // dob.month (Fixed only)
	9 => array (
		71,
		2,
		0
	)
); // dob.day (Fixed only)
$grade_prefix = $sas_lang['class']; // this variable is used to prefix a non-alpha grade field (field 5)
$grade_pupils = __('Pupils'); // used in generating grade accounts in edex.php
$grade_passwd = 1; // 0=none at all,1='NO PASSWORD',2=same as userid

//  eof
?>
