<?php

// html.php -- basic standard functions relating to html code
//
//  $Id: html.php,v 1.1 2006/10/03 08:33:55 fstuurman Exp $
//
//  Copyright (C) 2004 Peter Fokker, <peter@berestijn.nl>
//
//  This file is part of Janitor.
//
//  Janitor is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  Janitor is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

// Based on code in MySQL/PHP Database Applications, Jay Greenspan & Brad Bulger, ISBN 0-7645-3537-4

/*
 * This file is included from basic.php.
 * It contains useful functions relating to html tags.

 * string font_tag ($size, $typeface, $attributes)
 * string anchor_tag ($href, $text, $attributes)
 * string image_tag ($src, $attributes)
 * string subtitle ($text)
 * string paragraph ($attributes, ...)
 * string ul_list ($values)
 */

function font_tag($size = "2", $face = "sans-serif", $atts = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML <font> tag. The default font size is
	 * 2, and the default font typeface is sans-serif. Additional attributes
	 * for the tag may be supplied as an array in the third argument.
	 */
	$attlist = get_attlist($atts, array (
		"size" => $size,
		"face" => $face
	));
	$output = "<font $attlist>";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* font_tag() */

function anchor_tag($href = "", $text = "", $atts = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML anchor tag (<a>).  The first argument
	 * be the URL to which the tag points, and the second argument will
	 * be the text of the tag. Additional attributes may be supplied as
	 * an array in the third argument.
	 */
	$attlist = get_attlist($atts, array (
		"href" => $href
	));
	$output = "<a$attlist>$text</a>";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* anchor_tag() */

function image_tag($src = "", $atts = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML image tag (<img>). The first argument
	 * gives the URL of the image to be displayed. Additional attributes
	 * may be supplied as an array in the third argument.
	 */
	$attlist = get_attlist($atts, array (
		"src" => $src
	));
	$output = "<img $attlist>";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* image_tag() */

function subtitle($what = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML <h3> tag. It is used for the titles
	 * of secondary areas within pages in our examples. The reason to 
	 * display these via a function, rather than just literal <h3> tags,
	 * is to enable you to change the format of these subtitles in one
	 * place, instead of in each script.
	 */
	return "<h3>$what</h3>\n";
	/*-----------------------------------------------------------------------------*/
} /* subtitle() */

function paragraph($atts = "")
{
	/*-----------------------------------------------------------------------------
	 * This function will return a string inside HTML paragraph (<p>) tags.
	 * Attributes for the <p> tag may be supplied in the first argument.
	 * Any additional arguments will be included inside the opening and
	 * closing <p> tags, separated by newlines.
	 */
	$output = "<p";
	$i = 0;
	$attlist = get_attlist($atts);
	if ($attlist > "")
	{
		$output .= " $attlist";
		$i++;
	}
	$output .= ">\n";
	$args = func_num_args();
	while ($i < $args)
	{
		$x = func_get_arg($i);
		$output .= $x . "\n";
		$i++;
	}
	$output .= "</p>\n";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* paragraph() */

function ul_list($values = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML unordered (bulleted) list (<ul> tags). 
	 * If the argument is an array, then each value from the array will be
	 * included as a list item (<li>) in the list. Otherwise, the
	 * argument will simply be included inside the <ul> tags as is.
	 */
	$output .= "<ul>\n";
	if (is_array($values))
	{
		while (list (, $value) = each($values))
		{
			$output .= " <li>$value\n";
		}
	}
	else
	{
		$output .= $values . "\n";
	}
	$output .= "</ul>\n";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* ul_list() */

/*----- eof html.php -----*/
?>
