<?php

// tables.php -- basic standard functions relating to tables
//
//  $Id: tables.php,v 1.1 2006/10/03 08:33:55 fstuurman Exp $
//
//  Copyright (C) 2004 Peter Fokker, <peter@berestijn.nl>
//
//  This file is part of Janitor.
//
//  Janitor is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  Janitor is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

//  Based on code in MySQL/PHP Database Applications, Jay Greenspan & Brad Bulger, ISBN 0-7645-3537-4

/* This file contains some useful standard functions relating to tables.
 *
 * string start_table ($attributes)
 * string end_table (void)
 * string table_cell ($value, $attributes)
 * string table_row (...)
 *
 */

function start_table($atts = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an opening HTML <table> tag. 
	 * Attributes for the table may be supplied as an array.
	 */
	$attlist = get_attlist($atts);
	$output = "<table$attlist>\n";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* start_table() */

function end_table()
{
	/*-----------------------------------------------------------------------------
	 * This function returns a closing <table> tag.
	 */
	$output = "</table>\n";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* end_table() */

function table_cell($value = "", $atts = "")
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML table cell (<td>) tag. The first
	 * argument will be used as the value of the tag. Attributes for the
	 * <td> tag may be supplied as an array in the second argument.
	 * By default, the table cell will be aligned left horizontally,
	 * and to the top vertically.
	 */
	$attlist = get_attlist($atts, array (
		"align" => "left",
		"valign" => "top"
	));
	$output = "<td$attlist>$value</td>\n";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* table_cell() */

function table_row()
{
	/*-----------------------------------------------------------------------------
	 * This function returns an HTML table row (<tr>) tag, enclosing a variable
	 * number of table cell (<td>) tags. If any of the arguments to the function
	 * is an array, it will be used as attributes for the <tr> tag. All other
	 * arguments will be used as values for the cells of the row. If an
	 * argument begins with a <td> tag, the argument is added to the row as is.
	 * Otherwise it is passed to the table_cell() function and the resulting
	 * string is added to the row.
	 */
	$attlist = "";
	$cellstring = "";

	$cells = func_get_args();
	while (list (, $cell) = each($cells))
	{
		if (is_array($cell))
		{
			$attlist .= get_attlist($cell);
		}
		else
		{
			if (!eregi("<td", $cell))
			{
				$cell = table_cell($cell);
			}
			$cellstring .= "  " . trim($cell) . "\n";
		}
	}
	$output = "<tr$attlist>\n" . $cellstring . "</tr>\n";
	return $output;
	/*-----------------------------------------------------------------------------*/
} /* table_row() */

/*----- eof tables.php -----*/
?>
