<?php

#############################################################################
#                              Site@School
# Site@School is a website management system designed for schools.
#
# About Site@School:
# Original Idea: Mark de Haan (mark@starwave.nl)
# PHP coding & Design: Mark de Haan (mark@starwave.nl)
# Comissioned by: Stadsdeel de Baarsjes, Amsterdam, Netherlands
############################################################################
# install.php: last changed 04/10/2006  , version: 2.4.10
#              by Fred Stuurman
#$Id: install.php,v 1.2 2006/10/15 19:08:53 fstuurman Exp $
#
# Modified 2006-05-30 by Peter Fokker <peter@berestijn.nl>
# - changed permissions of database.inc.php twice: first to 0644 (before)
#   then to 0440 (after writing the file)
# - changed permissions on a few directories from 0777 to 0755
#   (nevermind that there seems to be an error in the path to 'media',
#   'studentpages' and 'languages')
# - removed three trailing spaces in tablenames in database.inc.php
#   (sections, studentpages, classes).
# - we now properly close the file database.inc.php after writing to it
# - changed default value for 'file_permissions' from 0777 to 0755 when
#   filling configuration table
#
############################################################################
#                        LICENSE INFORMATION
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##############################################################################
define('IN_SAS', true);

if (IsSet ($_GET['language']))
{
	$language = $_GET['language'];
}
$valid_langs = array (
	"NL",
	"EN",
	"DE",
	"ES",
	"DA",
	"FR"
);
$language = strtoupper($language);

if ((in_array($language, $valid_langs)) AND (file_exists($language . ".php")))
{
	include ($language . ".php");
}
else
{
	include ("EN.php");
}

include ("../core/common.inc.php");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>
<HEAD>
<meta http-equiv="Content-Language" content="nl">
<TITLE><?php print $sas_lang['lang_install_1'] ?></TITLE>
<META http-equiv=Content-Type content="text/html; charset=windows-1252">
<STYLE>A:link {
	BACKGROUND: none transparent scroll repeat 0% 0%; COLOR: #638ab9; TEXT-DECORATION: none
}
A:active {
	BACKGROUND: none transparent scroll repeat 0% 0%; COLOR: #638ab9; TEXT-DECORATION: none
}
A:visited {
	BACKGROUND: none transparent scroll repeat 0% 0%; COLOR: #638ab9; TEXT-DECORATION: none
}
A:hover {
	BACKGROUND: none transparent scroll repeat 0% 0%; COLOR: #ff0000; TEXT-DECORATION: none
}
TEXTAREA {
	COLOR: #000000; FONT-FAMILY: verdana, arial; BACKGROUND-COLOR: #ccdaec
}

SELECT {
	BORDER-RIGHT: #ccdaec 1px inset; BORDER-TOP: #ccdaec 1px inset; BORDER-LEFT: #ccdaec 1px inset; COLOR: #000000; BORDER-BOTTOM: #ccdaec 1px inset; FONT-FAMILY: verdana, arial; BACKGROUND-COLOR: #ccdaec
}
.text {
	FONT-SIZE: 10pt; FONT-FAMILY: Verdana, Arial
}
.link {
	FONT-WEIGHT: bold; FONT-SIZE: 10pt; COLOR: #000000; FONT-FAMILY: Verdana, Arial
}
.heading {
	FONT-WEIGHT: bold; FONT-SIZE: 13pt; COLOR: #000000; FONT-FAMILY: Verdana, Arial
}


INPUT.textfield {
	BORDER-RIGHT: #ccdaec 1px inset; BORDER-TOP: #ccdaec 1px inset; BORDER-LEFT: #ccdaec 1px inset; BORDER-BOTTOM: #ccdaec 1px inset; BACKGROUND-COLOR: #ccdaec
}
</STYLE>
<script language="JavaScript" type="text/javascript">
function checkinput ( form )
{  
  if (form.username.value == "") {
    alert( "<?php print $sas_lang['lang_install_error1'] ?>" );
    form.username.focus();
    return false ;
    }
  if (form.password.value == "") {
    alert( "<?php print $sas_lang['lang_install_error2'] ?>" );
    form.password.focus();
    return false ;
    }
  if (form.email.value == "") {
    alert( "<?php print $sas_lang['lang_install_error3'] ?>" );
    form.email.focus();
    return false ;
    }
  return true ;
}
</script>

</HEAD>
<BODY style="FONT-SIZE: 10pt; FONT-FAMILY: Verdana, Arial, Helvetica" bottomMargin=0 vLink=#000000 aLink=#466c9b link=#000000 bgColor=#ffffff leftMargin=0 topMargin=0 rightMargin=0>


<TABLE style="BORDER-COLLAPSE: collapse" borderColor=#111111 height=45 bgcolor="#13528c" cellSpacing=0 cellPadding=0 width="100%" border=0>
  <TBODY>
  <TR>
    <TD align=left width="5%"></TD>
    <TD width="5%">&nbsp;</TD>
    <TD align=right width="90%">
    <b><font size="6" color="#FFFFFF"><?php print $sas_lang['lang_install_2'] ?></font></b></TD>
    <TD align=right width="3%"></TD></TR></TBODY></TABLE> 
<TABLE id=AutoNumber3 style="BORDER-COLLAPSE: collapse" borderColor=#111111
cellSpacing=0 cellPadding=0 width="100%" border=0>
  <TBODY>
  <TR>
    <TD vAlign=top>
      <TABLE cellPadding=5 width="100%" border="0">
        <TBODY>
        <TR>
          <TD>
          <TABLE style="BORDER-COLLAPSE: collapse" borderColor=#111111 cellSpacing=0 cellPadding=4 width="100%" border=0>
              <TBODY>
              <TR>
                <TD align=center width="20%" rowspan="3"><img border="0" src="../graphics/install_banner.jpg">
                </TD>
<?php

$url = "http://" . $_SERVER['HTTP_HOST'] . "/";
if ($_GET["step"] == "" AND $step == "")
{
?>                        
                <TD vAlign=top align=left width="65%">
                <SPAN class=heading><?php print $sas_lang['lang_install_5'] ?><BR></SPAN><span class="text"><?php print $sas_lang['lang_install_3'] ?></span></TD>
                <TD vAlign=top align=middle width="10%" rowspan="3">&nbsp;</TD>
              </TR>
              <TR>
                <TD vAlign=top align=middle width="65%">
                <form method="POST" action="install.php?language=<?php echo $language ?>&step=1">
                <table border="1" height="300" cellpadding="5" cellspacing="0" style="border-collapse: collapse" bordercolor="#E5E5E5" width="100%" id="AutoNumber4" bgcolor="#F7F7F7">
                  <tr>
                    <td width="100%" valign="top"><span class=text><?php print $sas_lang['lang_install_4'] ?></span></td>
                  </tr>
                </table>
                </TD></TR>
              <TR>
                <TD vAlign=top align=right width="65%">
                <input type="submit" value="<?php print $sas_lang['lang_install_continue'] ?>" name="B1" class="BUTTON">
                  </p>
                </form>
<?php
}

if ($_GET["step"] == "1" OR $step == "1")
{
	$installdir = $_SERVER["DOCUMENT_ROOT"] . "/";
	$installdir = str_replace("//", "/", $installdir);
?>                          
                <TD vAlign=top align=left width="65%">
                <SPAN class=heading><?php print $sas_lang['lang_install_step1'] ?><BR></SPAN><span class="text"><?php print $sas_lang['lang_install_6'] ?></span></TD>
                <TD vAlign=top align=middle width="10%" rowspan="3">&nbsp;</TD>
              </TR>
              <TR>
                <TD vAlign=top align=middle width="65%">
                <table border="1" height="300" cellpadding="5" cellspacing="0" style="border-collapse: collapse" bordercolor="#E5E5E5" width="100%" id="AutoNumber4" bgcolor="#F7F7F7">
                  <tr>
                    <td width="100%" valign="top"><span class=text>
<form method="POST" action="install.php?language=<?php echo $language ?>&step=2">
<table border=0 cellpadding=3 cellspacing=0>
<tr>
	<td valign=top width=120><span class=link><?php print $sas_lang['lang_install_7'] ?></span></td>
	<td colspan="2"><input type=text name="sitename" size=36 value=""><br>
	<font size=1><?php print $sas_lang['lang_install_8'] ?></font></td>
</tr>
<tr><td colspan="3">&nbsp;</td></tr>
<tr>
	<td valign=top width=120><span class=link><?php print $sas_lang['lang_install_9'] ?></span></td>
	<td><input type=text name="serverpath" size=50 value="<?php print "$installdir"; ?>"></td>
  <td><input type=text name="userpath" size=20 value="starnet"><br></td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td valign="top"><font size=1>
  <?php print $sas_lang['lang_install_10'] ?></font></td> 
  <td><font size=1><?php print $sas_lang['lang_install_11'] ?></font></td>
</tr>
<tr><td colspan="3">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_12'] ?></span></td>
	<td colspan="2"><input type=text name="serverurl" size=36 value="<?php echo $url ?>"><br>
	<font size=1><?php print $sas_lang['lang_install_13'] ?> </font></td>
</tr>
<tr><td colspan="3">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_14'] ?></span></td>
	<td colspan="2"><input type=password name="sessioncode" size=36 value="siteatschool"><br>
	<font size=1><?php print $sas_lang['lang_install_15'] ?></font></td>
</tr>
</table><br><br></td>
                  </tr>
                </table>
                </TD>
                </TR>
              <TR>
                <TD vAlign=top align=right width="65%">
                <p>
                  <input type="submit" value="<?php print $sas_lang['lang_install_continue'] ?>" name="B1" class="BUTTON">
                  <input type="reset" value="<?php print $sas_lang['lang_install_reset'] ?>" name="B2" class="BUTTON"></p>
                </form>
<?php

}
if ($_GET["step"] == "2" OR $step == "2")
{
	@ rename("../configuration/database.inc.org", "../configuration/database.inc.php");
	@ chmod("../configuration/database.inc.php", 0644);
	// Nevertheless changed permissions to 0755 (IMHO it should NOT be 0777!) 2006-05-30/PF
	@ chmod("../media", 0755);
	@ chmod("../configuration/studentpages", 0755);
	@ chmod("../configuration/languages", 0755);
	$sitename = $_POST[sitename];
	$serverurl = $_POST[serverurl];
	$serverpath = $_POST[serverpath];
	$userpath = $_POST[userpath];
	$sessioncode = $_POST[sessioncode];

	if (strrpos($serverurl, '/') != strlen($serverurl) - 1)
	{
		$serverurl .= '/';
	} //add last slash if not present
	if (strrpos($serverpath, '/') != strlen($serverpath) - 1)
	{
		$serverpath .= '/';
	} //add last slash if not present

	if (is_dir("$serverpath$userpath") == FALSE)
	{
		print "<TD vAlign=top align=left width=\"65%\">
		      <SPAN class=\"heading\">" . $sas_lang['lang_install_step1'] . "<BR></SPAN><span class=\"text\">" . $sas_lang['lang_install_6'] . "</span></TD>
		      <TD vAlign=top align=\"middle\" width=\"10%\" rowspan=\"3\">&nbsp;</TD>
		      </TR>
		      <TR>
		      <TD vAlign=top align=middle width=\"65%\">
		      <table border=\"1\" height=\"300\" cellpadding=\"5\" cellspacing=\"0\" style=\"border-collapse: collapse\" bordercolor=\"#E5E5E5\" width=\"100%\" id=\"AutoNumber4\" bgcolor=\"#F7F7F7\">
		      <tr>
		         <td width=\"100%\" valign=\"top\"><span class=text><br><font color=red><b>" . $serverpath . $userpath . $sas_lang['lang_install_46'] . "</td>
		      </tr>
		      </table>
		      </TD></TR>
		      <TR>
		         <TD vAlign=top align=right width=\"65%\">
		      <input type=button value=\"" . $sas_lang['lang_install_return'] . "\" onClick=javascript:history.go(-1) class=BUTTON>
		      </TD>
		        </TR>
		              </TBODY></TABLE></TD></TR></TBODY></TABLE></TD>
		    </TR></TBODY></TABLE></BODY></HTML>";
		exit;
	}
	if (is_writable("$serverpath$userpath/configuration/database.inc.php") == FALSE)
	{
		print "<TD vAlign=top align=left width=\"65%\">
		      <SPAN class=\"heading\">Step 1<BR></SPAN><span class=\"text\">" . $sas_lang['lang_install_6'] . "</span></TD>
		      <TD vAlign=top align=\"middle\" width=\"10%\" rowspan=\"3\">&nbsp;</TD>
		      </TR>
		      <TR>
		      <TD vAlign=top align=middle width=\"65%\">
		      <table border=\"1\" height=\"300\" cellpadding=\"5\" cellspacing=\"0\" style=\"border-collapse: collapse\" bordercolor=\"#E5E5E5\" width=\"100%\" id=\"AutoNumber4\" bgcolor=\"#F7F7F7\">
		      <tr>
		         <td width=\"100%\" valign=\"top\">";
		if (file_exists("$serverpath$userpath/configuration/database.inc.php") == FALSE)
		{
			print "<span class=text><br><font color=red>" . $sas_lang['lang_install_47'];
		}
		else
		{
			print "<span class=text><br><font color=red><b>$serverpath$userpath/configuration/database.inc.php " . $sas_lang['lang_install_48'];
		}
		print "<p> " . $sas_lang['lang_install_49'] . "</td>
		      </tr>
		      </table>
		      </TD></TR>
		      <TR>
		         <TD vAlign=top align=right width=\"65%\">
		         <input type=button value=\"" . $sas_lang['lang_install_return'] . "\" onClick=javascript:history.go(-1) class=BUTTON>
		         </TD>
		        </TR>
		              </TBODY></TABLE></TD></TR></TBODY></TABLE></TD>
		    </TR></TBODY></TABLE></BODY></HTML>";
		exit;
	}
?>
		<TD vAlign=top align=left width="65%">
		<SPAN class=heading><?php print $sas_lang['lang_install_step2'] ?><BR></SPAN>
		<span class="text"><?php print $sas_lang['lang_install_16'] ?></span></TD>
		<TD vAlign=top align=middle width="10%" rowspan="3">&nbsp;</TD>
	  </TR>
	  <TR>
		<TD vAlign=top align=middle width="65%">
		<form method="POST" action="install.php?language=<?php echo $language ?>&step=3">
		<table border="1" height="300" cellpadding="5" cellspacing="0" style="border-collapse: collapse" bordercolor="#E5E5E5" width="100%" id="AutoNumber4" bgcolor="#F7F7F7">
		  <tr>
			<td width="100%" valign="top"><span class=text>

<table border=0 cellspacing=0 cellpadding=3>
<tr>
	<td valign=top width=180><span class=link><?php print $sas_lang['lang_install_17'] ?></span></td>
	<td><input type=text name="dbserver" value="localhost" size=25><br>
	<font size=1><?php print $sas_lang['lang_install_18'] ?></font></td>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_19'] ?></span></td>
	<td><input type=text name="dbuser" value="" size=25><br>
	<font size=1><?php print $sas_lang['lang_install_20'] ?></font></td>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_21'] ?></span></td>
	<td><input type=password name="dbpassword" value="" size=25><br>
	<font size=1><?php print $sas_lang['lang_install_22'] ?></font></td>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
	<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_23'] ?></span></td>
	<td><input type=text name="dbname" value="sas" size=25><br>
	<font size=1><?php print $sas_lang['lang_install_24'] ?></font></td>
<?php

	print "<input type=\"hidden\" name=\"sitename\" value=\"$sitename\">";
	print "<input type=\"hidden\" name=\"serverurl\" value=\"$serverurl\">";
	print "<input type=\"hidden\" name=\"serverpath\" value=\"$serverpath\">";
	print "<input type=\"hidden\" name=\"userpath\" value=\"$userpath\">";
	print "<input type=\"hidden\" name=\"sessioncode\" value=\"$sessioncode\">";
?>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
	<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_25'] ?></span></td>
	<td><input type=text name="dbprefix" value="sn_" size=25><br>
	<font size=1><?php print $sas_lang['lang_install_26'] ?></b></font></td>
</tr>
</table><br><br></td>
                  </tr>
                </table>
                </TD></TR>
              <TR>
                <TD vAlign=top align=right width="65%">
                  <input type="submit" value="<?php print $sas_lang['lang_install_continue'] ?>" name="B1" class="BUTTON">
                  <input type="reset" value="<?php print $sas_lang['lang_install_reset'] ?>" name="B2" class="BUTTON"></p>
                </form>

<?php

}
if ($_GET["step"] == "3" OR $step == "3")
{
	if (IsSet ($serverpath))
	{}
	else
	{
		$sitename = $_POST[sitename];
		$serverurl = $_POST[serverurl];
		$serverpath = $_POST[serverpath];
		$userpath = $_POST[userpath];
		$dbserver = $_POST[dbserver];
		$dbname = $_POST[dbname];
		$dbuser = $_POST[dbuser];
		$dbprefix = $_POST[dbprefix];
		$dbpassword = $_POST[dbpassword];
		$sessioncode = $_POST[sessioncode];
	}

	$table_sections = "$dbprefix" . "sections";
	$table_pages = "$dbprefix" . "pages";
	$table_users = "$dbprefix" . "users";
	$table_modules = "$dbprefix" . "modules";
	$table_editors = "$dbprefix" . "editors";
	$table_classes = "$dbprefix" . "classes";
	$table_configuration = "$dbprefix" . "configuration";
	$table_prot_pages = $dbprefix . "prot_pages";
	$table_prot_sections = $dbprefix . "prot_sections";
	$table_sessions = $dbprefix . "sessions";

	$table_studentpages = "$dbprefix" . "m_studentpages";
	$modtable_news_categories = "$dbprefix" . "m_news_cat";
	$modtable_news_articles = "$dbprefix" . "m_news_articles";

	$modtable_ads = "$dbprefix" . "adtext";
	$modtable_guestbook = "$dbprefix" . "m_gbook";

	$dbsettings = "<script language=\"php\">\n";
	$dbsettings = $dbsettings . '$db_server = "';
	$dbsettings = $dbsettings . "$dbserver";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$db_name = "';
	$dbsettings = $dbsettings . "$dbname";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$db_username = "';
	$dbsettings = $dbsettings . "$dbuser";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$db_password = "';
	$dbsettings = $dbsettings . "$dbpassword";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$dbprefix = "';
	$dbsettings = $dbsettings . "$dbprefix";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_configuration = "';
	$dbsettings = $dbsettings . "$table_configuration";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_editors = "';
	$dbsettings = $dbsettings . "$table_editors";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_modules = "';
	$dbsettings = $dbsettings . "$table_modules";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_users = "';
	$dbsettings = $dbsettings . "$table_users";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_pages = "';
	$dbsettings = $dbsettings . "$table_pages";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_sections = "';
	$dbsettings = $dbsettings . "$table_sections";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_studentpages = "';
	$dbsettings = $dbsettings . "$table_studentpages";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . '$table_classes = "';
	$dbsettings = $dbsettings . "$table_classes";
	$dbsettings = $dbsettings . '";';
	$dbsettings = $dbsettings . "\n";
	$dbsettings = $dbsettings . "</script>";

	// This include file should NOT be 0777! It can be changed to 0440 or even 0400
	// after the file is properly closed (!). 2006-05-30/PF
	@ chmod("$serverpath$userpath/configuration/database.inc.php", 0640);
	$dbconfig = fopen("$serverpath$userpath/configuration/database.inc.php", "w");
	fwrite($dbconfig, "$dbsettings");
	fclose($dbconfig);
	@ chmod("$serverpath$userpath/configuration/database.inc.php", 0440);

	$link = @ mysql_connect("$dbserver", "$dbuser", "$dbpassword"); // connecting to database
	if (!$link)
	{
		print "<TD vAlign=top align=left width=\"65%\">
		      <SPAN class=\"heading\">Step 1<BR></SPAN><span class=\"text\">" . $sas_lang['lang_install_6'] . "</span></TD>
		      <TD vAlign=top align=\"middle\" width=\"10%\" rowspan=\"3\">&nbsp;</TD>
		      </TR>
		      <TR>
		      <TD vAlign=top align=middle width=\"65%\">
		      <table border=\"1\" height=\"300\" cellpadding=\"5\" cellspacing=\"0\" style=\"border-collapse: collapse\" bordercolor=\"#E5E5E5\" width=\"100%\" id=\"AutoNumber4\" bgcolor=\"#F7F7F7\">
		      <tr>
		         <td width=\"100%\" valign=\"top\"><span class=text><br><font color=red>
		         <b>" . $sas_lang['lang_install_51'] . "<br>" . mysql_error() . "</b></font>
		        <p><b>" . $sas_lang['lang_install_52'] . "</b></td>
		      </tr>
		      </table>
		      </TD></TR>
		      <TR>
		         <TD vAlign=top align=right width=\"65%\">
		         <input type=button value=\"" . $sas_lang['lang_install_return'] . "\" onClick=javascript:history.go(-1) class=BUTTON>
		         </TD>
		        </TR>
		        </TBODY></TABLE></TD></TR></TBODY></TABLE></TD>
		    </TR></TBODY></TABLE></BODY></HTML>";
		exit;
	}
	mysql_query("CREATE DATABASE IF NOT EXISTS $dbname");
	mysql_select_db("$dbname");
	if (mysql_errno() != 0)
	{
		print "<TD vAlign=top align=left width=\"65%\">
		      <SPAN class=\"heading\">" . $sas_lang['lang_install_step1'] . "<BR></SPAN><span class=\"text\">" . $sas_lang['lang_install_6'] . "</span></TD>
		      <TD vAlign=top align=\"middle\" width=\"10%\" rowspan=\"3\">&nbsp;</TD>
		      </TR>
		      <TR>
		      <TD vAlign=top align=middle width=\"65%\">
		      <table border=\"1\" height=\"300\" cellpadding=\"5\" cellspacing=\"0\" style=\"border-collapse: collapse\" bordercolor=\"#E5E5E5\" width=\"100%\" id=\"AutoNumber4\" bgcolor=\"#F7F7F7\">
		      <tr>
		         <td width=\"100%\" valign=\"top\"><span class=text><br><font color=red><b>Mysql error: " . mysql_error() . "</b></font>
		        <p>" . $sas_lang['lang_install_50'] . "</td>
		      </tr>
		      </table>
		      </TD></TR>
		      <TR>
		         <TD vAlign=top align=right width=\"65%\">
		         <input type=button value=\"" . $sas_lang['lang_install_return'] . "\" onClick=javascript:history.go(-1) class=BUTTON>
		         </TD>
		        </TR>
		        </TBODY></TABLE></TD></TR></TBODY></TABLE></TD>
		    </TR></TBODY></TABLE></BODY></HTML>";
		exit;
	}

	mysql_query("CREATE TABLE $table_sessions (ses_id varchar(32) NOT NULL default '', ses_time int(11) NOT NULL default 0, ses_start int(11) NOT NULL default 0, ses_value text NOT NULL, PRIMARY KEY  (ses_id))");
	mysql_query("CREATE TABLE $table_configuration (config_key varchar(64) not NULL,config_value text not NULL, description varchar(255), PRIMARY KEY (config_key))");
	mysql_query("INSERT INTO $table_configuration VALUES ('serverpath', '$serverpath', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('user_path', '$userpath', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('url', '$serverurl', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('sessioncode', '$sessioncode', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('theme', 'editable', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('protected_theme', 'editable', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('sitename', '$sitename', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('startsection', '1', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('protected_startsection', '1', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('highvisual', '0', '')");
	//mysql_query("INSERT INTO $table_configuration VALUES ('securitymethod', 'sessions', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('dateformat', '%d-%m-%Y', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('htmlarea_editor_rows', '20', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('number_pupilpages', '3', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('edex_file_name' , '' , '')");
	# change by AGJ 30/06/2004
	mysql_query("INSERT INTO $table_configuration VALUES ('media_dir', 'media', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('studentpages_dir', 'studentpages', '')");
	$today = time();
	mysql_query("INSERT INTO $table_configuration VALUES ('last_backup_date', '$today', '')");

	mysql_query("CREATE TABLE $table_editors (id int(11) NOT NULL auto_increment, name varchar(40) NOT NULL default '', location varchar(40) NOT NULL default '', description text NOT NULL, PRIMARY KEY  (id))");
	mysql_query("INSERT INTO $table_editors VALUES (1, 'FCKEditor', 'fckeditor/editor.php', '')");
	mysql_query("INSERT INTO $table_editors VALUES (2, 'HTMLarea Editor', 'htmlarea/editor.php', '')");
	mysql_query("INSERT INTO $table_editors VALUES (3, 'Plain text Editor', 'sn_plain/editor.php', '')");

	mysql_query("CREATE TABLE $table_modules (id int(11) NOT NULL auto_increment, name varchar(60) NOT NULL default '', location varchar(60) NOT NULL default '', options text NOT NULL, admin varchar(40) NOT NULL default '', dbtables text NOT NULL, PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $table_pages (id int(11) NOT NULL auto_increment, section varchar(10) NOT NULL default '', name varchar(80) NOT NULL default '', invisible varchar(10) NOT NULL default '', content text NOT NULL, module varchar(80) NOT NULL default '', sort TINYINT(4) NOT NULL default 0, count int(11), createdate date, lastvisitdate date, category char(20) NOT NULL, lastupdate DATETIME, history varchar(20), locked_by int(11) default null, PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $table_sections (id int(11) NOT NULL auto_increment, name varchar(80) NOT NULL default '', invisible varchar(20) NOT NULL default '', frontpage int(11) NOT NULL default 0, parent varchar(120) NOT NULL default '', sort tinyint(4) NOT NULL default 0, PRIMARY KEY  (id))");

	mysql_query("CREATE TABLE $table_users (id int(11) NOT NULL auto_increment, name varchar(60) NOT NULL default '', username varchar(20) NOT NULL default '', password varchar(40) NOT NULL default '', email varchar(80) NOT NULL default '', access varchar(50) NOT NULL default '', highvisibility tinyint(4) NOT NULL default 0, editor varchar(40) NOT NULL default 1, type tinyint(4), class varchar(80), sections varchar(80) NOT NULL default '', project varchar(80), initial tinyint(1) default 0, code varchar(20) default NULL, invalid_logins tinyint(1) default 0, PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $table_studentpages (studentid int(11) NOT NULL auto_increment, content text NOT NULL, newcontent text NOT NULL, pcheck tinyint(4) NOT NULL default 1, approved tinyint(4) NOT NULL default 0, send_email tinyint NOT NULL default 0, title varchar(50) NOT NULL, dir_number int(11) NOT NULL, change_date DATE NOT NULL, sort tinyint(4) not null default 0, invisible tinyint(1) not null default 0, PRIMARY KEY  (studentid))");
	mysql_query("CREATE TABLE $table_classes (id int(11) NOT NULL auto_increment, name varchar(40) NOT NULL default '', teachers text NOT NULL, project tinyint(4) NOT NULL DEFAULT 0, PRIMARY KEY (id))");
	//mysql_query("INSERT INTO $table_classes VALUES ('', '--------', '0')");
	// version 2.0
	mysql_query("CREATE TABLE $table_prot_pages (id int(11) NOT NULL auto_increment, section varchar(10) NOT NULL default '', name varchar(80) NOT NULL default '', invisible varchar(10) NOT NULL default '', content text NOT NULL, module varchar(80) NOT NULL default '', sort TINYINT(4) NOT NULL default 0, count int(11), createdate date, lastvisitdate date, category char(20) NOT NULL, lastupdate DATETIME, history varchar(20), locked_by int(11) default null, PRIMARY KEY (id))");
	mysql_query("CREATE TABLE $table_prot_sections (id int(11) NOT NULL auto_increment, name varchar(80) NOT NULL default '', invisible varchar(20) NOT NULL default '', frontpage int(11) NOT NULL default 0, parent varchar(120) NOT NULL default '', sort tinyint(4) NOT NULL default 0, PRIMARY KEY (id))");

	//alerts 
	$table_alerts = $dbprefix . "alerts";
	mysql_query("INSERT INTO $table_configuration VALUES ('send_alerts', '0', '')");
	mysql_query("CREATE TABLE $table_alerts (id int(11) NOT NULL auto_increment, email varchar(80) NOT NULL default '', sections varchar(50) NOT NULL default '', name char(40) NOT NULL default '', PRIMARY KEY (id))");
	mysql_query("INSERT INTO $table_configuration VALUES ('send_alerts_per_section', '0', '')");

	//stats
	$table_stats = $dbprefix . "stats";
	mysql_query("CREATE TABLE $table_stats (id int(11) NOT NULL auto_increment, ip varchar(15) not null, received date not null, 
	pageid varchar(10) not null, sectionid varchar(10) not null, count int(11) NOT NULL default 0, public tinyint(4), primary key (id) )");
	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}
	mysql_query("INSERT INTO $table_configuration VALUES ('stats_ip_filter', '127.0.0.1', '')");
	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	//agenda
	$agenda_table_events = $dbprefix . "m_agenda_events";
	$agenda_table_names = $dbprefix . "m_agenda_names";

	mysql_query("CREATE TABLE $agenda_table_names (id int(11) NOT NULL auto_increment, name varchar(75) not null, sort tinyint(4) NOT NULL, username varchar(20) not null, PRIMARY KEY (id))");
	mysql_query("CREATE TABLE $agenda_table_events (id int(11) NOT NULL auto_increment, adate date, timeslot tinyint, descr text not null, agenda int(11) NOT NULL, PRIMARY KEY (id))");
	$result = mysql_query("SELECT id FROM $table_modules WHERE location = 'sn_agenda'");
	$RecordCount = mysql_num_rows($result);
	if ($RecordCount == 0)
	{
		mysql_query("INSERT INTO $table_modules VALUES (NULL, 'Agenda', 'sn_agenda', 'view_agenda.php,View agenda', 'admin.php', '$agenda_table_events,$agenda_table_names')");
	}
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time01', '08:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time02', '08:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time03', '08:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time04', '08:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time05', '09:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time06', '09:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time07', '09:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time08', '09:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time09', '10:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time10', '10:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time11', '10:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time12', '10:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time13', '11:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time14', '11:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time15', '11:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time16', '11:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time17', '12:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time18', '12:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time19', '12:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time20', '12:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time21', '13:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time22', '13:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time23', '13:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time24', '13:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time25', '14:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time26', '14:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time27', '14:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time28', '14:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time29', '15:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time30', '15:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time31', '15:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time32', '15:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time33', '16:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time34', '16:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time35', '16:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time36', '16:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time37', '17:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time38', '17:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time39', '17:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time40', '17:45', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time41', '18:00', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time42', '18:15', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time43', '18:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_time44', '18:30', '' )");
	mysql_query("INSERT INTO $table_configuration (config_key, config_value, description) VALUES( 'agenda_options', '#9AD894,#D80000,#B29D78,#0080F0,#FFFFFF,#B5D7EF,#BBBBBB,#B5D7EF,#E7E3E7,#E7E3E7,#FFCC33,#00CCFF', '' )");

	//ads module
	mysql_query("CREATE TABLE $modtable_ads (ad_id int(11) NOT NULL auto_increment, email varchar(40) NOT NULL default '', ad_text text NOT NULL, date date, name varchar(45), initial tinyint(1) default 0, PRIMARY KEY (ad_id))");
	mysql_query("INSERT INTO $table_configuration VALUES ('ads_email', '', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('ads_expiration_days', '30', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('ads_check_before_post', '0', '')");

	//album module
	$table_module_allbum = $dbprefix . 'm_allbum';
	mysql_query("Create Table $table_module_allbum(id int not null auto_increment, type enum('album','subalbum','picture','sound','movie','doc', 'existing_object', 'unknown' ), title 
	LONGTEXT, description LONGTEXT, path LONGTEXT, thumb LONGTEXT, parent LONGTEXT, children LONGTEXT, hidden bool, ispage tinyint(4) NOT NULL DEFAULT 0, public tinyint(4) NOT NULL default 0, primary key (id))");
	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_thumbsize_x','150','max hor thumb size (px)')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_picsize_x','600','max hor pic size (px)')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_max_objects_per_page','10','max objects per page')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_max_allbums_per_page','10','max albums per page')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_num_objects_per_row','3','number of objects shown per row')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_gallery_dir','media/gallery/','relative path (w.r.t. starnet/) to gallery')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('allbum_num_files','5','Number of files that can be selected for object upload')");

	if (mysql_errno() != 0)
	{
		echo mysql_errno() . ": " . mysql_error() . "\n";
	}
	//chat
	$chat_userstable = $dbprefix . "m_chat_users";
	$chat_table = $dbprefix . "m_chat";
	$chat_messagetable = $dbprefix . "m_chat_log";

	mysql_query("CREATE TABLE $chat_userstable (
	        id int(11) NOT NULL auto_increment,
	        ip varchar(255) NOT NULL default '',
	        user varchar(255) NOT NULL default '',
	        status varchar(6) NOT NULL default '',
	        joined datetime NOT NULL default '0000-00-00 00:00:00',
	        room int(11) default NULL,
	        PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $chat_messagetable (
	        id int(11) NOT NULL auto_increment,
	        user varchar(255) NOT NULL default '',
	        color varchar(255) NOT NULL default 'black',
	        font varchar(255) NOT NULL default 'arial',
	        size int(2) NOT NULL default 2,
	        text varchar(255) NOT NULL default '',
	        posted datetime NOT NULL default '0000-00-00 00:00:00',
	        toperson varchar(16) NOT NULL default '0',
	        system int(1) NOT NULL default '0',
	         room int(11) default NULL,
	        ip varchar(255) NOT NULL default '',
	        PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $chat_table (
	        id int(11) NOT NULL auto_increment,
	        name varchar(50) default NULL,
	        title text,
	        welcome text,
	        width int(5) default NULL,
	        height int(5) default NULL,
	        public tinyint(4) default NULL,
	        password varchar(15) default NULL,
	        refresh int(11) NOT NULL default 2,
	        options varchar(255) NOT NULL default '1',
	        PRIMARY KEY  (id)) ");

	//calendar
	$calendar_table = $dbprefix . "m_calendar_events";
	$calendars_table = $dbprefix . "m_calendars";

	mysql_query("CREATE TABLE $calendars_table (id int(11) NOT NULL auto_increment, name varchar(50) NOT NULL, options text NOT NULL, title text, PRIMARY KEY (id))");
	mysql_query("CREATE TABLE $calendar_table (id int(11) NOT NULL auto_increment,	month tinyint(4) NOT NULL, year int(8), description text, calendar int(11) NOT NULL, PRIMARY KEY (id))");

	//Up/download
	$downloadstable = $dbprefix . "m_downloads";
	$downloadcategorytable = $dbprefix . "m_downloads_cat";
	mysql_query("CREATE TABLE $downloadcategorytable (id int(11) NOT NULL auto_increment, title varchar(40) NOT NULL default '', ispage tinyint NOT NULL default 0, public tinyint(4) NOT NULL default 0, KEY  (id))");
	mysql_query("CREATE TABLE $downloadstable (id int(11) NOT NULL auto_increment, description text NOT NULL, category int(11) NOT NULL default 0, creator varchar(80) NOT NULL default '', filename varchar(80) NOT NULL default '', date datetime, counter tinyint(11) default 0, stored_file varchar(40), last_download date, PRIMARY KEY  (id))");

	//forms module
	$forms_table = $dbprefix . "m_forms";
	$forms_config_table = $dbprefix . "m_forms_config";
	//$forms_data_table = $dbprefix . "m_forms_data";

	mysql_query("CREATE TABLE $forms_table (id int(11) NOT NULL auto_increment,	name text NOT NULL, length varchar(5), form_id tinyint(4) NOT NULL, sort tinyint(4), required tinyint(4) NOT NULL default 0,  PRIMARY KEY (id))");
	mysql_query("CREATE TABLE $forms_config_table (id int(11) NOT NULL auto_increment, welcome text, email_text text, form_name varchar(60), email text, email_subject varchar(50),	send_copy tinyint(4), thank_you text, PRIMARY KEY (id))");
	//mysql_query("CREATE TABLE $forms_data_table (form_id tinyint(4) NOT NULL, field_id tinyint(4) NOT NULL, field_content text, data_index int(11) NOT NULL)");
	//mysql_query("ALTER TABLE $forms_config_table ADD mode tinyint( 4 )");
	//mysql_query("ALTER TABLE $forms_table ADD export tinyint( 1 )");

	//forum
	$table_users = "$dbprefix" . "m_forumuser";
	$table_topics = "$dbprefix" . "m_forumtopics";
	$table_replies = "$dbprefix" . "m_forumreplies";
	$table_cat = "$dbprefix" . "m_forumcat";

	mysql_query("CREATE TABLE $table_users(user_index int not null auto_increment, username varchar(50), firstname varchar(20), surname varchar(50), email varchar(50), password varchar(10), showemail tinyint, weburl varchar(100), joindate datetime, lastcontribution datetime, lastlogin datetime, topics int(11), replies int(11), cat_index int(11), primary key (user_index))");
	mysql_query("CREATE TABLE $table_topics(topic_index int not null auto_increment, topictitle varchar(100), topicbody mediumtext, userid varchar(50), date datetime, replies int(11), topic_reads int(11), cat_index int(11), send_email varchar(1), primary key (topic_index))");
	mysql_query("CREATE TABLE $table_replies(reply_index int not null auto_increment, topicindex int, replybody mediumtext, userid varchar(50), date datetime, cat_index int, primary key (reply_index))");
	mysql_query("CREATE TABLE $table_cat(cat_index int not null auto_increment, name varchar(50), type tinyint(1), email varchar(100), primary key (cat_index))");
	mysql_query("INSERT INTO $table_configuration VALUES ('forum_header_font_color', '#000000', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('forum_subtitle_background_color', '#638ABD', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('forum_odd_background_color', '#FFFFFF', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('forum_even_background_color', '#C0C0FF', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('forum_max_reply_char', '900', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('forum_max_topic_char', '900', '')");

	//guestbook
	mysql_query("CREATE TABLE $modtable_guestbook (id int(11) NOT NULL auto_increment, name varchar(45) NOT NULL default '',email varchar(80) NOT NULL default '' ,homepage varchar(50) NOT NULL default '',date datetime, message text NOT NULL, initial tinyint(1) default 0, PRIMARY KEY (id))");
	mysql_query("INSERT INTO $table_configuration VALUES ('gbook_email', '', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('gbook_max_items', '15', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('gbook_check_before_post', '0', '')");

	//mail
	$table_email = $dbprefix . "m_mail_address";
	mysql_query("CREATE TABLE $table_email (id int(11) NOT NULL auto_increment, name varchar(60) NOT NULL default '', description text, email varchar(80) NOT NULL default '', welcometext text, thankyoutext text, sort tinyint(4) NOT NULL default 0, PRIMARY KEY  (id))");
	mysql_query("INSERT INTO $table_configuration VALUES ('email_picture', 'starnet/graphics/email3.gif', '')");

	//message
	$message_table = $dbprefix . "m_message";

	mysql_query("CREATE TABLE $message_table (
	              id int(11) NOT NULL auto_increment,
	              message text NOT NULL,
	              date datetime default NULL,
	              name varchar(45) default NULL,
				  days int(11) default 0,
				  todate date,
				  public tinyint(4) DEFAULT 0,
	              PRIMARY KEY (id))");

	//links
	$links_table = $dbprefix . "m_links";
	$links_cat_table = $dbprefix . "m_links_cat";

	mysql_query("CREATE TABLE $links_table (
				  id int(11) NOT NULL auto_increment,
				  title varchar(50) NOT NULL default '',
				  url varchar(100) NOT NULL default '',
				  description text NOT NULL,
				  pagename int(11) NOT NULL default '0',
				  initial tinyint(1) NOT NULL default '1',
				  sort tinyint(4) NOT NULL default '0',
				  category varchar(30) NOT NULL default '',
				  PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $links_cat_table (
				  id int(11) NOT NULL auto_increment,
				  pagename varchar(50) NOT NULL default '',
				  owner_email varchar(80) NOT NULL default '',
				  row_count tinyint(4) NOT NULL default '0',
				  welcome text NOT NULL,
				  icon varchar(50) NOT NULL default '',
				  propose tinyint(1) NOT NULL default '0',
				  propose_welcome text,
				  showlink tinyint(1) NOT NULL default '0',
				  PRIMARY KEY  (id))");

	$result = mysql_query("SELECT id FROM $table_modules WHERE location = 'sn_links'");
	$RecordCount = mysql_num_rows($result);
	if ($RecordCount == 0)
	{
		mysql_query("INSERT INTO $table_modules VALUES (NULL, 'Links', 'sn_links', 'view_links.php,Show Links on page', 'admin.php', '')");
		mysql_query("INSERT INTO $table_configuration VALUES ('links_module_row_count', '1', '')");
		mysql_query("INSERT INTO $table_configuration VALUES ('links_module_icon', '/starnet/modules/sn_links/link.gif', '')");
	}

	//news
	mysql_query("CREATE TABLE $modtable_news_categories (id int(11) NOT NULL auto_increment, title varchar(40) NOT NULL default '', ispage tinyint(4) NOT NULL default 0, header text NOT NULL, PRIMARY KEY  (id))");
	mysql_query("CREATE TABLE $modtable_news_articles (id int(11) NOT NULL auto_increment, title varchar(80) NOT NULL default '', date varchar(20) NOT NULL default '', category varchar(40) NOT NULL default '', content text NOT NULL, archive tinyint(1) NOT NULL default 0, public tinyint(4) NOT NULL default 0, PRIMARY KEY  (id))");
	mysql_query("INSERT INTO $table_configuration VALUES ('news_template', 'standard', '')");

	//newsletter module
	$table_newsletter_content = $dbprefix . "m_newsletters";
	$table_newsletters = $dbprefix . "m_newsletter_cat";
	$table_email_adresses = $dbprefix . "m_newsletter_emails";

	mysql_query("CREATE TABLE $table_email_adresses (id int(11) NOT NULL auto_increment,name varchar(100) not null, email varchar(80),remarks varchar(100),newsletter_id varchar(30), date date,
	enable tinyint(4), surename varchar(35) not null, code varchar(12), PRIMARY KEY (id))");
	mysql_query("CREATE TABLE $table_newsletter_content (id int(11) NOT NULL auto_increment, title text, archive tinyint(4) default 0, content text, newsletter_id tinyint(4), date date, published tinyint(4) not null default 0, sent tinyint(4) not null default 0, header text, footer text, public tinyint(4) NOT NULL default 0 , locked_by int(11) default null, PRIMARY KEY (id))");
	mysql_query("CREATE TABLE $table_newsletters (id int(11) NOT NULL auto_increment, name varchar(50) , title text, link tinyint(4),email varchar(80) not null, confirm tinyint(4) not null, register_text text
	,decline_text text , contribute_text text, contribute tinyint(4), extra_info varchar(40), contribute_thanks text, public tinyint(4) NOT NULL default 0, template text default null, sender_email varchar(80) not null, PRIMARY KEY (id))");

	//search
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_results', '10', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_name1', 'sn_news,m_news_articles,1,0,0', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_name2', 'sn_newsletter,m_newsletters,1,0,0', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_name3', 'sn_studentpages,m_studentpages,0,0,0', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_name4', 'sn_allbum,m_allbum,1,0,0', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_searchfield1', 'title, content', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_searchfield2', 'title, content', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_searchfield3', 'content,title', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_searchfield4', 'title,description', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_returnfield1', 'id, title, content', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_returnfield2', 'id, title, content', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_returnfield3', 'studentid,title,content', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_returnfield4', 'parent,title,description', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_url1', '&article=@0@', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_url2', '&option=view&newsletter_id=@0@', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_url3', '&student=@0@', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_url4', '&ID=@0@&gallerypage=1', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_pageid1', '2,4,1,1', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_pageid2', '4,11,1,2', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_pageid3', '3,7,1,3', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_pageid4', '5,10,1,4', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_extra_select1', 'AND archive = 0', 'Only search in non archived news')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_extra_select2', 'AND published = 1', 'Only search in public/published newsletters')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_extra_select3', '', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_extra_select4', '', ' ')");
	mysql_query("INSERT INTO $table_configuration VALUES ('search_module_invisible', '0', ' ')");

	//template editor
	$template_table = $dbprefix . "m_template";
	mysql_query("CREATE TABLE $template_table (script varchar(20) NOT NULL default '', descr text NOT NULL default '',
	  type1 char(1) default NULL, name1 varchar(100) default '',
	  type2 char(1) default NULL, name2 varchar(100) default '',
	  type3 char(1) default NULL, name3 varchar(100) default '',
	  type4 char(1) default NULL, name4 varchar(100) default '',
	  type5 char(1) default NULL, name5 varchar(100) default '',
	  type6 char(1) default NULL, name6 varchar(100) default '',
	  type7 char(1) default NULL, name7 varchar(100) default '',
	  type8 char(1) default NULL, name8 varchar(100) default '')");
	$result = mysql_query("SELECT id FROM $table_modules WHERE location = 'sn_templates'");
	$RecordCount = mysql_num_rows($result);
	if ($RecordCount == 0)
	{
		mysql_query("INSERT INTO $table_modules VALUES ('', 'Template editor', 'sn_templates', '', 'admin.php', '')");
	}

	//TV module
	$table_scripts = $dbprefix . "m_scripts";
	mysql_query("CREATE TABLE $table_scripts (id int(11) NOT NULL auto_increment,
	  name varchar(50) NOT NULL default '',
	  script varchar(30) NOT NULL default '',
	  active tinyint(4) default NULL,
	  varname1 varchar(15) default NULL,
	  value1 text default NULL,
	  varname2 varchar(15) default NULL,
	  value2 text default NULL,
	  varname3 varchar(15) default NULL,
	  value3 text default NULL,
	  welcome text,
	  loc_id tinyint(11),
	  PRIMARY KEY  (id))");

	mysql_query("INSERT INTO $table_scripts VALUES (1, 'Scrollscript', 'scroll_page.php', 1, 'Page number', '1', 'Speed', '2', NULL, '', '', '1')");
	mysql_query("INSERT INTO $table_scripts VALUES (2, 'Slideshow', 'slideshow_full.php', 0, 'Album name', 'slideshow', 'Speed', '5', 'Width', '300', '', '1')");
	mysql_query("INSERT INTO $table_scripts VALUES (3, 'Showpage', 'show_page.php', 0, 'Page number', '1', NULL, '', NULL, '', '', '1')");
	mysql_query("INSERT INTO $table_scripts VALUES (4, 'Page slideshow', 'page_slideshow.php', 0, 'Pages', '1', NULL, '', NULL, '', '', '1')");

	$result = mysql_query("SELECT id FROM $table_modules WHERE location = 'sn_tvmodule'");
	$RecordCount = mysql_num_rows($result);
	if ($RecordCount == 0)
	{
		mysql_query("INSERT INTO $table_modules VALUES (NULL, 'TV Module', 'sn_tvmodule', '', 'admin.php', '')");
	}

	if (file_exists("mysql_" . $language . ".php"))
	{
		include ("mysql_" . $language . ".php");
	}
	else
	{
		include ("mysql_EN.php");
	}

	mysql_query("INSERT INTO $table_configuration VALUES ('use_encryption', '1', 'Encrypt passwords 1=yes 0=no')");
	mysql_query("INSERT INTO $table_configuration VALUES ('sas_version', '2.4', 'Sas main version')");
	mysql_query("INSERT INTO $table_configuration VALUES ('sas_patch_version', '10', 'Sas patch version')");
	mysql_query("INSERT INTO $table_configuration VALUES ('file_permissions', '0755', 'File permissions for upload')");

	//check if all tables are created.
	$sas_tables[0] = $dbprefix . "configuration";
	$sas_tables[1] = $dbprefix . "users";
	$sas_tables[2] = $dbprefix . "editors";
	$sas_tables[3] = $dbprefix . "pages";
	$sas_tables[4] = $dbprefix . "sections";
	$sas_tables[5] = $dbprefix . "prot_pages";
	$sas_tables[6] = $dbprefix . "prot_sections";
	$sas_tables[7] = $dbprefix . "classes";
	$sas_tables[8] = $dbprefix . "modules";
	$sas_tables[9] = $dbprefix . "stats";
	$sas_tables[10] = $dbprefix . "alerts";
	$sas_tables[11] = $dbprefix . "m_studentpages";
	$sas_tables[12] = $dbprefix . "sessions";

	$sas_mod_tables[0] = $dbprefix . "m_gbook";
	$sas_mod_tables[1] = $dbprefix . "adtext";
	$sas_mod_tables[2] = $dbprefix . "m_mail_address";
	$sas_mod_tables[3] = $dbprefix . "m_agenda_events";
	$sas_mod_tables[4] = $dbprefix . "m_agenda_names";
	$sas_mod_tables[5] = $dbprefix . "m_allbum";
	$sas_mod_tables[6] = $dbprefix . "m_template";
	$sas_mod_tables[7] = $dbprefix . "m_downloads";
	$sas_mod_tables[8] = $dbprefix . "m_downloads_cat";
	$sas_mod_tables[9] = $dbprefix . "m_news_articles";
	$sas_mod_tables[10] = $dbprefix . "m_news_cat";
	$sas_mod_tables[11] = $dbprefix . "m_calendars";
	$sas_mod_tables[12] = $dbprefix . "m_calendar_events";
	$sas_mod_tables[13] = $dbprefix . "m_newsletters";
	$sas_mod_tables[14] = $dbprefix . "m_newsletter_cat";
	$sas_mod_tables[15] = $dbprefix . "m_newsletter_emails";
	$sas_mod_tables[16] = $dbprefix . "m_forumcat";
	$sas_mod_tables[17] = $dbprefix . "m_forumuser";
	$sas_mod_tables[18] = $dbprefix . "m_forumreplies";
	$sas_mod_tables[19] = $dbprefix . "m_forumtopics";
	$sas_mod_tables[20] = $dbprefix . "m_chat";
	$sas_mod_tables[21] = $dbprefix . "m_chat_log";
	$sas_mod_tables[22] = $dbprefix . "m_chat_users";
	$sas_mod_tables[23] = $dbprefix . "m_scripts";
	$sas_mod_tables[24] = $dbprefix . "m_template";
	$sas_mod_tables[25] = $dbprefix . "m_message";

	$sas_mod_tables_name[0] = "sn_gbook";
	$sas_mod_tables_name[1] = "sn_ads";
	$sas_mod_tables_name[2] = "sn_mailpage";
	$sas_mod_tables_name[3] = "sn_agenda";
	$sas_mod_tables_name[4] = "sn_agenda";
	$sas_mod_tables_name[5] = "sn_allbum";
	$sas_mod_tables_name[6] = "sn_template";
	$sas_mod_tables_name[7] = "sn_downloads";
	$sas_mod_tables_name[8] = "sn_downloads";
	$sas_mod_tables_name[9] = "sn_news";
	$sas_mod_tables_name[10] = "sn_news";
	$sas_mod_tables_name[11] = "sn_calendar";
	$sas_mod_tables_name[12] = "sn_calendar";
	$sas_mod_tables_name[13] = "sn_newsletter";
	$sas_mod_tables_name[14] = "sn_newsletter";
	$sas_mod_tables_name[15] = "sn_newsletter";
	$sas_mod_tables_name[16] = "sn_forum";
	$sas_mod_tables_name[17] = "sn_forum";
	$sas_mod_tables_name[18] = "sn_forum";
	$sas_mod_tables_name[19] = "sn_forum";
	$sas_mod_tables_name[20] = "sn_chat";
	$sas_mod_tables_name[21] = "sn_chat";
	$sas_mod_tables_name[22] = "sn_chat";
	$sas_mod_tables_name[23] = "sn_tvmodule";
	$sas_mod_tables_name[24] = "sn_template";
	$sas_mod_tables_name[25] = "sn_message";

	$error = 0;
	$count = count($sas_tables);
	for ($k = 0; $k < $count; $k++)
	{
		$check = mysql_query("SELECT * FROM $sas_tables[$k] LIMIT 0,1");

		if (!$check)
		{
			$error++;
			$check_result[$error] = "Table NOT installed! <b>" . $sas_tables[$k] . "</b>";
		}
	}

	$count = count($sas_mod_tables);
	for ($j = 0; $j < $count; $j++)
	{
		$check = mysql_query("SELECT * FROM $sas_mod_tables[$j] LIMIT 0,1");

		if (!$check)
		{
			$error++;
			$check_result[$error] = str_replace("%tablename%", $sas_mod_tables[$j], $sas_lang['lang_install_312']);
			$check_result[$error] = $check_result[$error] . $sas_mod_tables_name[$j];
		}
	}

	if ($error == 0) //do we have errors?
	{
		$msg = $sas_lang['lang_install_311'];
	}
	else
	{
		$msg = "<font color=\"red\">";
		for ($j = 0; $j <= $error; $j++)
		{
			$msg .= $check_result[$j] . "<br>";
		}
		$msg .= "</font>";
	}
?>
                <TD vAlign=top align=left width="65%">
                <SPAN class=heading><?php print $sas_lang['lang_install_step3'] ?><BR></SPAN><span class="text"><?php print $sas_lang['lang_install_27'] ?></span></TD>
                <TD vAlign=top align=middle width="10%" rowspan="3">&nbsp;</TD>
              </TR>
              <TR>
                <TD vAlign=top align=middle width="65%">
                <form method="POST" action="<?php print "install.php?language=$language&step=4" ?>">
                <table border="1" height="300" cellpadding="5" cellspacing="0" style="border-collapse: collapse" bordercolor="#E5E5E5" width="100%" id="AutoNumber4" bgcolor="#F7F7F7">
                  <tr>
				   <td><span class=text><?php print $msg ?></span></td>
				  </tr>
				  <tr>
                    <td width="100%" valign="top"><span class=text><p><?php print $sas_lang['lang_install_28'] ?></span>
                    <span class=text><?php print $sas_lang['lang_install_29'] ?>&nbsp;
                    <input type="radio" value="1" name="q" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php print $sas_lang['lang_install_30'] ?>&nbsp;
                    <input type="radio" value="0" name="q" checked></span></td>
                  </tr>
                </table>
                </TD></TR>
              <TR>
                <TD vAlign=top align=right width="65%">
                  <input type="submit" value="<?php print $sas_lang['lang_install_continue'] ?>" name="B1" class="BUTTON">
                  <input type="reset" value="<?php print $sas_lang['lang_install_reset'] ?>" name="B2" class="BUTTON"></p>
                </form>
<?php

}
if ($_GET["step"] == "4" OR $step == "4")
{
	$q = $_POST[q];
	include ("../configuration/database.inc.php"); // connecting to database
	mysql_connect("$db_server", "$db_username", "$db_password");
	mysql_select_db("$db_name");

	if (file_exists("demodata_" . $language . ".php"))
	{
		include ("demodata_" . $language . ".php");
	}
	else
	{
		include ("demodata_EN.php");
	}
?>
                <TD vAlign=top align=left width="65%">
                <SPAN class=heading><?php echo $sas_lang['lang_install_step4'] ?><BR></SPAN><span class="text"><?php print $sas_lang['lang_install_31'] ?></span></TD>
                <TD vAlign=top align=middle width="10%" rowspan="3">&nbsp;</TD>
              </TR>
              <TR>
                <TD vAlign=top align=middle width="65%">
                <form method="POST" enctype="multipart/form-data" action="install.php?language=<?php echo $language ?>&step=5&q=<?php echo $q ?>" onsubmit="return checkinput(this);">
                <table border="1" height="300" cellpadding="5" cellspacing="0" style="border-collapse: collapse" bordercolor="#E5E5E5" width="100%" id="AutoNumber4" bgcolor="#F7F7F7">
                  <tr>
                    <td width="100%" valign="top"><span class=text>

<table border=0 cellspacing=0 cellpadding=3>
<tr>
	<td valign=top width=180><span class=link><?php print $sas_lang['lang_install_32'] ?></span></td>
	<td><input type=text name="fullname" value="" size=35><br>
	<font size=1><?php print $sas_lang['lang_install_33'] ?></font></td>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_34'] ?></span></td>
	<td><input type=text name="username" value="" size=35><br>
	<font size=1><?php print $sas_lang['lang_install_35'] ?></font></td>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_36'] ?></span></td>
	<td><input type=password name="password" value="" size=35><br>
	<font size=1><?php print $sas_lang['lang_install_37'] ?></font></td>
</tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr>
	<td valign=top><span class=link><?php print $sas_lang['lang_install_38'] ?></span></td>
	<td><input type=text name="email" value="" size=35><br>
	<font size=1><?php print $sas_lang['lang_install_39'] ?>

</b></font></td>
</tr>
</table><br><br></td>
                  </tr>
                </table>
                </TD></TR>
              <TR>
                <TD vAlign=top align=right width="65%">
                  <input type="submit" value="<?php print $sas_lang['lang_install_continue'] ?>" name="B1" class="BUTTON">
                  <input type="reset" value="<?php print $sas_lang['lang_install_reset'] ?>" name="B2" class="BUTTON"></p>
                </form>
<?php

}
if ($_GET["step"] == "5" OR $step == "5")
{
	$fullname = $_POST['fullname'];
	$username = $_POST['username'];
	$password_encr = md5($_POST['password']);
	$email = $_POST['email'];
	$q = $_GET['q'];

	include ("../configuration/database.inc.php"); // connecting to database
	mysql_connect("$db_server", "$db_username", "$db_password");
	mysql_select_db("$db_name");

	mysql_query("INSERT INTO $table_users (name, username, password, email, access, highvisibility, editor, type, class, sections, project, initial, code) 
	VALUES ('$fullname', '$username', '$password_encr', '$email', '11111111111111,1111111111111111111', '0', '1', '20' , '', '', '', '0', '')");
	mysql_query("INSERT INTO $table_configuration VALUES ('newsletter_admin_email', '$email', 'Email address of newsletter module administrator')");
	mysql_query("INSERT INTO $table_configuration VALUES ('email', '$email', 'Site Email address')");

	$query = "SELECT config_value FROM $table_configuration WHERE config_key='url'"; // getting the url
	$result = mysql_query($query) or die_script($query, mysql_error());
	$site_url = mysql_result($result, 0);
	unset ($query);
	unset ($result);
	$query = "SELECT config_value FROM $table_configuration WHERE config_key='user_path'";
	$result = mysql_query($query) or die_script($query, mysql_error());
	$userpath = mysql_result($result, 0); //get the directoryname of the cms
	unset ($query);
	unset ($result);

	if (file_exists($language . ".php"))
	{
		include ($language . ".php");
	}
	else
	{
		include ("EN.php");
	}
?>
                <TD vAlign=top align=left width="65%">
                <SPAN class=heading><?php print $sas_lang['lang_install_step5'] ?><BR></SPAN><span class="text"><?php print $sas_lang['lang_install_40'] ?></span></TD>
                <TD vAlign=top align=middle width="10%" rowspan="3">&nbsp;</TD>
              </TR>
              <TR>
                <TD vAlign=top align=middle width="65%">
                <form method="POST" action="<?php print "../index.php"; ?>">
                <table border="1" height="300" cellpadding="5" cellspacing="0" style="border-collapse: collapse" bordercolor="#E5E5E5" width="100%" id="AutoNumber4" bgcolor="#F7F7F7">
                  <tr>
                    <td width="100%" valign="top"><span class=text>
<?php print $sas_lang['lang_install_41']."<a href=../index.php>here</a>"; ?><br>
<?php print $sas_lang['lang_install_42']." <b>$username</b><br> ".$sas_lang['lang_install_43']." <b>".$_POST['password']."</b>"; ?><br><br>
<?php

	if ($q == 1)
	{
		$path = substr($userpath, 0, strlen($userpath) - 8);
		print $sas_lang['lang_install_44'];
	}
	print $sas_lang['lang_install_45']
?><br>
                    </span></td>
                  </tr>
                </table>
                </TD></TR>
              <TR>
                <TD vAlign=top align=right width="65%">
                  <input type="submit" value="Login" name="B1" class="BUTTON">
                </form>
<?php
 }
?>
</TD>
</TR>
</TBODY></TABLE></TD></TR></TBODY></TABLE></TD>
</TR></TBODY></TABLE></BODY></HTML>