<?php
if (!defined('IN_SAS'))
{
	die("Hacking attempt");
}

/*
** DGS Search
** db.php written by James Sella and Max Spaulding
** Copyright (c) 2000-2001 Digital Genesis Software, LLC. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
// last changed 21/05/2005 to search Site@school modules  Fred Stuurman (fc.stuurman@hccnet.nl)
#$Id: db.php,v 1.1 2006/10/03 08:54:49 fstuurman Exp $
*/

function db($retVal, $q, $r, $o, $s, $timer)
{
	global $config, $database;

	$matchCount = count($retVal);
	$maxSearchTime = 25;
	$debug = $config['debug'];

	if ($debug)
		printf("->Debug: db() [Module]<BR>\n");

	if ($s > 0 && $matchCount >= $r + $o) //If we know the size already and have enough matches, return.
		return $retVal;

	$tm = getTime();

	reset($database);

	while (list (, $db) = each($database))
	{
		if (getTime() - $timer > $maxSearchTime)
		{
			if ($debug)
				printf("->Debug: db() - <B>Exceeded Max Search Time of %.1f secs. Currently %.1f secs. - Exiting db module early.</B><BR>\n", $maxSearchTime, getTime() - $timer);
			break;
		}
		$result = searchMySQL($db, $q, $r, $o, $s, $matchCount);
		reset($result);

		while (list (, $match) = each($result))
		{
			/* Do URL substitutions where needed. */
			$matchCount++;

			if ($matchCount < $o || $matchCount > $r + $o) //Only build the desc if we need them.
			{
				$retVal[] = array (
					0
				); //Place holder, since this is outside of the displayed results.
			}
			else
			{
				$link = $db['link'];
				$url = $db['url'];
				$descArray = $db['desc'];
				$descWidth = 140;
				$rfields = $db['returnField'];
				$i = 0;
				if (!is_array($descArray))
					$descArray = array ();
				reset($rfields);
				while (list (, $field) = each($rfields))
				{
					$matchField = trim($match[$field]);
					$var = sprintf('@%d@', $i);
					$link = str_replace($var, $matchField, $link);
					$url = str_replace($var, $matchField, $url);
					reset($descArray);
					while (list ($idx, $desc) = each($descArray))
					{
						$descArray[$idx] = str_replace($var, $matchField, $desc);
					}
					$i++;
				}

				if ($descWidth > 0)
				{
					reset($descArray);
					while (list ($idx, $desc) = each($descArray))
					{
						$desc = processWindow($desc, $descWidth, 1, $q, $matchCount);
						//if(IsSet($desc[0]))
						//{
						$descArray[$idx] = $desc[0]; /* processWindow() sets the index to 0 for the first item. */
						//}
					}
				}

				$retVal[] = array (
					'link' => $link,
					'url' => $url,
					'description' => $descArray,
					'source' => 'db'
				);
			}

			if ($s > 0 && $matchCount > $r + $o) //If we know the size already and have enough matches, break.
				break;
		}
	}

	if ($debug) //Time taken to process db
	{
		printf("->Debug: db() - Module Search Time: %.1f sec<BR>\n", getTime() - $tm);
		flush();
	}

	return $retVal;
}

function searchMySQL($db, $q, $r, $o, $s, $c)
{
	global $config;

	$tables = $db['table'];
	$rfields = $db['returnField'];
	$sfields = $db['searchField'];
	$select = $db['select'];
	$orderByDepth = -1;
	$debug = $config['debug'];
	$retVal = array ();
	// by JG begin
	// could be extended for other languages
	$q = str_replace('&auml;', '', $q);
	$q = str_replace('&Auml;', 'A', $q); // strtolower() does not work for noASCII-Charakters
	$q = str_replace('&ouml;', '', $q);
	$q = str_replace('&Ouml;', '', $q);
	$q = str_replace('&uuml;', '', $q);
	$q = str_replace('&Uuml;', '', $q);
	$q = str_replace('&szlig;', '', $q);
	//printf("----- LIKE statement $q: ------> %s <br> \n",$q);
	// by JG end
	$keywords_array = explode(" ", $q);

	if ($debug)
		printf("-->Debug: searchMySQL()<BR>\n");

	//if ($port > 0)
	//	$server = sprintf("%s:%d", trim($server), $port);

	if ($debug)
		printf("-->Debug: searchMySQL() - server: '%s', username: '%s', password: '%s'<BR>\n", $server, $username, $password);

	$statement = 'SELECT ';
	$orderBy = ' ORDER BY ';
	$offset = $c - $o;

	$i = 0;
	reset($rfields);
	while (list (, $entry) = each($rfields))
	{
		$statement .= $entry;
		if ($i < $orderByDepth || $orderByDepth < 0)
			$orderBy .= $entry;
		$i++;
		if ($i < count($rfields))
		{
			$statement .= ', ';
			if ($i < $orderByDepth || $orderByDepth < 0)
				$orderBy .= ', ';
		}
	}

	$statement .= ' FROM ';

	$i = 0;
	reset($tables);
	while (list (, $entry) = each($tables))
	{
		$i++;
		$statement .= $entry;
		if ($i < count($tables))
			$statement .= ', ';
	}

	$statement .= ' WHERE (';

	$i = 0;
	reset($sfields);

	while (list (, $entry) = each($sfields))
	{
		$i++;

		foreach ($keywords_array as $value)
		{
			$statement .= $entry . ' LIKE \'%' . $value . '%\' AND ';
		}
		$statement = substr($statement, 0, -4); //strip last AND
		if ($i < count($sfields))
			$statement .= ' OR ';
	}
	$statement .= ")"; //if extra select exists for a module add it.

	if ($select[0] != "")
	{
		$statement .= " " . $select . " ";
	}
	$statement .= $orderBy;

	if ($debug)
	{
		printf("-->Debug: searchMySQL() - MySQL statement: %s<BR>\n", $statement);
		flush();
	}
	$result = mysql_query($statement);
	if (!$result)
	{
		printf("Error: MySQL query '%s' failed.<BR>\n>%s: %s<BR>\n", $statement, @ mysql_errno($con), @ mysql_error($con));
		return $retVal;
	}

	$width = count($rfields);
	$row = 0;
	while ($line = mysql_fetch_row($result))
	{
		for ($i = 0; $i < $width; $i++)
		{
			$retVal[$row][$rfields[$i]] = $line[$i];
		}
		$row++;
	}
	return $retVal;

}
?>