<?php

###############################################################################
#                    ALLbum-1.0.0: admin.inc.php                              #
#                    (admin functions component)                              #
#                                                                             #
# ALLbum  is a module for the Content Management System                       #
# "Site@School"  (http://siteatschool.sourceforge.net).                       #
#                                                                             #
# ALLbum is written by Martin Herrman <m.herrman@student.tue.nl>              #
# ALLbum is copyrighted by OBS Rosa Boekdrukker, Amsterdam, The Netherlands   #
# (http://www.rosaboekdrukker.nl)                                             #
# ALLbum is licenced by GNU General Public Licence                            #
#                                                                             #
###############################################################################
# admin.inc.php: last changed 05/10/2006 2.4.10                               #  
#                    by Fred Stuurman (fc.stuurman@hccnet.nl)
#$Id: admin.inc.php,v 1.2 2006/10/15 19:08:54 fstuurman Exp $                 														  #
###############################################################################
#                            LICENCE INFORMATION                              #
#                                                                             #
# Copyright (c) 2003-2006, OBS Rosa Boekdrukker, Amsterdam, The Netherlands.  #
#                                                                             #
# This program is free software, you can redistribute it and/or               #
# modify it under the terms of the GNU General Public License                 #
# as published by the Free Software Foundation; either version 2              #
# of the License, or (at your option) any later version.                      #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                        #
# See the GNU General Public License for more details.                        #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program; if not, write to the Free Software                 #
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. #
###############################################################################
if (!defined('IN_SAS'))
{
	die("Hacking attempt");
}

function UseFileFromMedia($file, $parentID)
{
	// Task: puts file $file in allbum with id $parentID

	$parent = db_GetPath($parentID);
	// copy file to it's destination
	# Remove spaces, apostrophe, exclamation marks etc.
	$str_from = " \'@!,\t\*?`\"";
	$str_to = str_repeat("_", strlen($str_from));
	$filename = strtr($file, $str_from, $str_to);
	$filename = explode("/", $filename);
	$filename = array_reverse($filename);
	$filename = $filename[0];
	$dest = $parent . "/" . $filename;

	if (file_exists($dest)) //if file already exists, skip it
	{
		$succes = "nok";
		$exists_error = true;
		return;
	}

	$src = stripslashes($file);
	//print "copy($src,$dest)";
	copy($src, $dest);
	$thumb = ListThumb($dest);
	$path = MakeThumb($thumb, $dest); //create the thumb
	// update database
	$fileext = explode(".", $filename);
	$fileext = array_reverse($fileext);
	$fileext = strtolower($fileext[0]);
	if (($fileext == "jpg") OR ($fileext == "gif") OR ($fileext == "jpeg"))
	{
		$type = "picture";
		$thumb = $filename;
	}
	elseif (($fileext == "mp3") OR ($fileext == "wav") OR ($fileext == "real"))
	{
		$type = "sound";
		$thumb = "modules/sn_allbum/sound.gif";
	}
	elseif (($fileext == "asx") OR ($fileext == "mid"))
	{
		$type = "sound";
		$thumb = "modules/sn_allbum/winmedia.gif";
	}
	elseif ($fileext == "doc")
	{
		$type = "doc";
		$thumb = "modules/sn_allbum/document.gif";
	}
	elseif ($fileext == "mov")
	{
		$type = "movie";
		$thumb = "modules/sn_allbum/mov.gif";
	}
	elseif (($fileext == "avi") OR ($fileext == "ram"))
	{
		$type = "movie";
		$thumb = "modules/sn_allbum/mov.gif";
	}
	elseif (($fileext == "avi") OR ($fileext == "ram"))
	{
		$type = "movie";
		$thumb = "modules/sn_allbum/movie.gif";
	}
	elseif (($fileext == "mpg") OR ($fileext == "wmv"))
	{
		$type = "movie";
		$thumb = "modules/sn_allbum/movie.gif";
	}
	elseif ($fileext == "pdf")
	{
		$type = "doc";
		$thumb = "modules/sn_allbum/pdf.gif";
	}
	elseif ($fileext == "swf")
	{
		$type = "movie";
		$thumb = "modules/sn_allbum/swf.gif";
	}
	else
	{
		$type = "unknown";
		$thumb = "modules/sn_allbum/unknown.gif";
	}

	$title = $filename;

	if ((strpos($title, ".")) AND ($type == "picture")) //object title has extention?
	{
		$tmp = explode(".", $title);
		array_pop($tmp);
		$title = implode(".", $tmp);
	}

	$description = NULL;
	$hidden = 0;
	$path = str_replace("//", "/", $parent);
	$parent_ID = $parentID;
	$children = NULL;
	$is_public = db_GetPublic($parent_ID);
	db_PutCreateObject($type, $title, $description, addslashes($path), $thumb, $parent_ID, $children, $hidden, '0', $is_public);
}

function UseDirFromMedia($dir, $parentID)
{
	// Task: inside object with id $parentID, a sub-album with title
	// '$dir' is created. Inside this sub-album, all files and directories
	// inside directory $dir are added. Using this function recursively.
	// $parentID can be -1, 0 or "", which indicates a main album must be
	// created.

	global $sas_lang;

	if (($parentID == 0) OR ($parentID == -1) OR ($parentID == ""))
	{
		// create main album
		$parent = db_GetPath($parentID);
		$type = "subalbum";
		$thumb = "modules/sn_allbum/empty.gif";
		$description = NULL;
		$hidden = 0;
		$title = $dir;
		$path = str_replace("//", "/", $parent . "/" . $dir);
		$parent_ID = $parentID;
		$children = NULL;
	}
	else
	{
		// create sub-album
		$parent = db_GetPath($parentID);
		$parent_ID = $parentID;
		// get list of contents from $dir
		$list = array ();
		$handle = opendir($dir);
		while (false !== ($item = readdir($handle)))
		{
			if ($item != "." && $item != "..")
			{
				array_push($list, $item);
			}
		}

		// foreach in list:
		//   if file: UseFileFromMedia, if dir: UseDirFromMedia,
		foreach ($list AS $key => $value)
		{
			$value2 = str_replace("//", "/", $dir . "/" . $value);
			if (is_dir($value2) === true)
			{
				UseDirFromMedia($value2, $parentID);
			}
			elseif (is_file($value2) === true)
			{
				UseFileFromMedia($value2, $parentID);
			}
		}
	}
}

function db_PutHideObject($ID)
{
	// Task: set hidden field for object with id $ID to 1
	global $allbum_table;
	$query = "UPDATE $allbum_table SET hidden = 1 WHERE id = '$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function db_PutUnhideObject($ID)
{
	// Task: set hidden field for object with id $ID to 0
	global $allbum_table;
	$query = "UPDATE $allbum_table SET hidden = 0 WHERE id = '$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function db_PutDeleteObjects($list)
{
	// Task: $list is a list which contains id's of objects that must
	// be deleted. Items in the list are seperated by a "," and the list
	// might start with a ",".
	// If an object is a (sub-)album and is not empty, all it's contents
	// must be deleted too.
	// Deletion = delete file(s) and/or directorie(s) and delete database
	// entrie(s). Don't forget to update the parent!
	// Note: a main album does not have a parent.

	$list = explode(",", $list);

	foreach ($list AS $key => $value)
	{
		if ($value != "")
		{
			$type = db_GetType($value);
			$parent = db_GetParentID($value);

			if ($type == "album")
			{
				DeleteContents($value);
				DeleteDirectory($value);
				RemoveDatabaseEntry($value);
				UpdateDatabaseAlbumOrd();
			}
			elseif ($type == "subalbum")
			{
				UpdateParentListOfChildren($value, $parent);
				DeleteContents($value);
				DeleteDirectory($value);
				RemoveDatabaseEntry($value);
				db_PutIfNeededUpdateParentThumb($parent);
			}
			else
			{
				UpdateParentListOfChildren($value, $parent);
				DeleteFiles($value);
				RemoveDatabaseEntry($value);
				db_PutIfNeededUpdateParentThumb($parent);
			}
		}
	}
}

function db_GetEmpty($id)
{
	// Task: for object with id $id, return "yes" if the object is empty,
	// return "no" otherwise. $id might be the id of an object that is not
	// a (sub-)album, in that case, return "yes".

	$type = db_GetType($id);

	if (($type != "subalbum") AND ($type != "album"))
	{
		return "yes";
	}
	else
	{
		if (count(db_GetContents($id)) == 0)
		{
			return "yes";
		}
		else
		{
			return "no";
		}
	}
}

function db_GetAlbumExists($title, $id)
{
	// Task: return true if sub-album with title $title exists in sub-album
	// with id $id.
	// When $id = -1, 0 or "" return true if a main album with title $title exists.

	global $allbum_table;

	if (($id == -1) or ($id == 0) or ($id == ""))
	{
		$query = "SELECT title FROM $allbum_table WHERE type='album'";
	}
	else
	{
		$query = "SELECT title FROM $allbum_table WHERE type='subalbum' AND parent LIKE '%" . trim($id) . "%'";
	}
	$result = mysql_query($query) or die(mysql_error() . $query);
	$array1 = array ();
	while ($array2 = mysql_fetch_row($result))
	{
		array_push($array1, $array2[0]);
	}
	$result = in_array($title, $array1);
	return $result;
}

function db_UpdateParentPublic($ID, $is_public)
{
	// Task: for object with id $id, change puplic to 1 for parents with $ID

	global $allbum_table;

	$query = "UPDATE $allbum_table SET public = '$is_public' WHERE parent = '$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function db_PutTitleDescriptionObject($ID, $title, $description, $ispage, $picture, $is_public)
{
	// Task: update title and description of object with id $ID to
	// $title and $description, return "ok" if no errors occured,
	// "nok" otherwise.

	if (!get_magic_quotes_gpc())
	{
		$title = addslashes($title);
		$description = addslashes($description);
	}

	global $allbum_table;
	$query = "UPDATE $allbum_table SET title = '$title' WHERE id = '$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	$query = "UPDATE $allbum_table SET description = '$description' WHERE id = '$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	if ($ispage != "")
	{
		$query = "UPDATE $allbum_table SET ispage = '$ispage' WHERE id = '$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
	}
	if ($picture != "")
	{
		$query = "UPDATE $allbum_table SET thumb = '$picture' WHERE id = '$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
	}
	if ($is_public != "")
	{
		$query = "UPDATE $allbum_table SET public = '$is_public' WHERE id = '$ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		db_UpdateParentPublic($ID, $is_public);

		$query = "SELECT id FROM $allbum_table WHERE parent = '$ID' AND type = 'subalbum'"; //get the ids of the subalbums
		$result = mysql_query($query) or die(mysql_error() . $query);

		while ($allbum_list = mysql_fetch_array($result))
		{
			db_UpdateParentPublic($allbum_list[0], $is_public);
		}
	}
}

function db_PutPathObject($id, $path)
{
	// Task: for object with id $id, change path field to $path
	// return "ok" if no errors occured, "nok" otherwise.

	global $allbum_table;

	$query = "UPDATE $allbum_table SET path = '$path' WHERE id = '$id'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function db_GetLevel($id)
{
	// Task: for (sub-)album with id $id, return it's 'level' in the tree

	global $allbum_table;

	$query = "SELECT path FROM $allbum_table WHERE id = '$id'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	$result = mysql_result($result, 0);
	$path = explode("/", $result);
	return count($path) - 2;
}

function db_GetPublic($parent_ID)
{
	// Task: get the public bit of the parent allbum

	global $allbum_table;

	$query = "SELECT public FROM $allbum_table WHERE id = '$parent_ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	$result = mysql_result($result, 0);
	return $result;
}

function db_PutChildrenPath($id, $newdir, $level, $type)
{
	// Task: for all children (and their children etc.) of the (sub-)album
	// with id $id and level $level, update the path field with the new 
	// directory of their (grand grand ..)parent.
	// Return "ok" if no errors occured, "nok" otherwise.

	global $allbum_table;

	if (($type == "subalbum") OR ($type == "album"))
	{
		$query = "SELECT children FROM $allbum_table WHERE id='$id'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$result = mysql_result($result, 0);
		$children = explode(",", $result);
		foreach ($children AS $key => $value)
		{
			$query = "SELECT path FROM $allbum_table WHERE id='$value'";
			$result = mysql_query($query) or die(mysql_error() . $query);
			$result = mysql_result($result, 0);

			$path = explode("/", $result);
			$path[$level +1] = $newdir;
			$path = implode("/", $path);
			$path = stripslashes(addslashes($path));
			$query = "UPDATE $allbum_table SET path = '$path' WHERE id = '$value'";
			$result = mysql_query($query) or die(mysql_error() . $query);
			$type = db_GetType($value);
			db_PutChildrenPath($value, $newdir, $level, $type);
		}
	}
}

function db_PutParentPath($id, $newdir, $level, $type)
{
	// Task: for all parents (and their parents etc.) of the sub-album
	// with id $id and level $level, update the path field with the new 
	// directory of their (grand grand) child.
	// Return "ok" if no errors occured, "nok" otherwise.

	global $allbum_table;

	if ($type == "subalbum")
	{
		$query = "SELECT parent FROM $allbum_table WHERE id = '$id'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$result = mysql_result($result, 0);
		$parent = explode(",", $result);
		foreach ($parent AS $key => $value)
		{
			$query = "SELECT path, thumb FROM $allbum_table WHERE id = '$value'";
			$result = mysql_query($query) or die(mysql_error() . $query);
			$image = mysql_result($result, 0, 0) . "/" . mysql_result($result, 0, 1);
			if (!file_exists($image))
			{
				$path = explode("/", $image);
				$path[$level] = $newdir;
				$path = implode("/", $path);
				//$query = "UPDATE $allbum_table SET thumb = '$path' WHERE id = '$value'";
				//$result = mysql_query($query) or die(mysql_error().$query);
				$type = db_GetType($value);
				db_PutParentPath($value, $newdir, $level +1, $type);
			}
		}
	}
}

function db_PutCreateObject($type, $title, $description, $path, $thumb, $parent_ID, $children, $hidden, $ispage, $is_public)
{
	// Task: create new object in database, make directory if creating (sub-)album.
	// Return an array with 0 => "ok" if no error occured, 0 => "nok" otherwise.
	// array[1] is used for the ID of the new object if it is a (sub-)album.

	global $sas_lang, $sas_config;
	global $allbum_table;
	$perm = $sas_config['file_permissions'];
	# Remove spaces, apostrophe, exclamation marks for the path.
	$str_from = " \'@!,\t\*?`\"";
	$str_to = str_repeat("_", strlen($str_from));
	$path = strtr(stripslashes($path), $str_from, $str_to);

	if (!get_magic_quotes_gpc())
	{
		$title = addslashes($title);
		$description = addslashes($description);
	}

	if ($type == 'album')
	{
		// Make directory:
		umask(0);
		mkdir(stripslashes($path), 0755);
		chmod($path, octdec($perm)); //chmod it with permissions stored in configuration table.

		// Insert table entry:
		$query = "INSERT INTO $allbum_table VALUES (NULL, '$type', '$title', '$description', '$path', '$thumb', '$parent_ID', '$children', '0', '$ispage', $is_public)";
		$result = mysql_query($query) or die(mysql_error() . $query);
		return mysql_insert_id();
	}

	if ($type == 'subalbum')
	{
		// Make directory:
		umask(0);
		mkdir(stripslashes($path), 0755);
		chmod($path, octdec($perm)); //chmod it with permissions stored in configuration table.

		// Insert table entry:
		$query = "INSERT INTO $allbum_table VALUES (NULL, '$type', '$title', '$description', '$path', '$thumb', '$parent_ID', '$children', '0', '$ispage', $is_public)";
		$result = mysql_query($query) or die(mysql_error() . $query);

		// Save auto-increment id from previous query:
		$child_id = mysql_insert_id();

		// Update parent:
		//Get the ids of the children sorted by the title
		$query = "SELECT id FROM $allbum_table WHERE parent='$parent_ID' AND id !='$parent_ID' ORDER BY title";
		$result = mysql_query($query) or die(mysql_error() . $query);
		$children = "";
		while ($id_list = mysql_fetch_array($result))
		{
			if ($children == "")
			{
				$children = $id_list[0];
			}
			else
			{
				$children = $children . "," . $id_list[0];
			}
		}
		$query = "UPDATE $allbum_table SET children = '$children' WHERE id = '$parent_ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);
		return $child_id;
	}

	$objects = array (
		'picture',
		'sound',
		'movie',
		'doc',
		'unknown'
	);

	if (in_array($type, $objects))
	{

		// Insert table entry:
		$query = "INSERT INTO $allbum_table VALUES (NULL, '$type', '$title', '$description', '$path', '$thumb', '$parent_ID', '$children', '$hidden', '$ispage', $is_public)";
		$result = mysql_query($query) or die(mysql_error() . $query);

		// Save auto-increment id from previous query:
		$child_id = mysql_insert_id();

		// **Update parent:	
		// * children:

		//Get the ids of the children sorted by the title
		$query = "SELECT id FROM $allbum_table WHERE parent='$parent_ID' AND id != '$parent_ID' ORDER BY title";
		$result = mysql_query($query) or die(mysql_error() . $query);

		$children = "";
		while ($id_list = mysql_fetch_array($result))
		{
			if ($children == "")
			{
				$children = $id_list[0];
			}
			else
			{
				$children = $children . "," . $id_list[0];
			}
		}
		$query = "UPDATE $allbum_table SET children = '$children' WHERE id = '$parent_ID'";
		$result = mysql_query($query) or die(mysql_error() . $query);

		// * thumb (not for direct parent only; for all parents back to main album):
		db_PutIfNeededUpdateParentThumb($parent_ID);
	}
}

function db_GetConfigOptions()
{
	// Task: return a two dimensional array with for each configuration option
	// (config_key, config_value, description)
	global $table_configuration;
	$query = "SELECT config_key, config_value, description FROM $table_configuration WHERE config_key LIKE 'allbum_%'";
	$result = mysql_query($query) or die(mysql_error() . $query);
	for ($i = 0; $array = mysql_fetch_row($result); $i++)
	{
		if ($array[0] != "allbum_gallery_dir")
		{
			$array2[$i] = $array;
		}
	}
	return $array2;
}

function db_PutConfigOption($config_key, $config_value)
{
	// Task: update configuration key $config_key with value
	// $config_value
	global $table_configuration;
	$query = "UPDATE $table_configuration SET config_value = '$config_value' WHERE config_key = '$config_key'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}

function alert($ID)
{
	//will call the standard alert function from S@S.
	global $table_pages, $dbprefix, $sas_lang, $site_url, $allbum_table, $sas_config;
	//send an alert 
	$result = mysql_query("SELECT title FROM $allbum_table WHERE id = '$ID'"); //find the title of album
	$page_name = mysql_result($result, 0, 0);
	$result2 = mysql_query("SELECT id, section, lastupdate, name FROM $table_pages 
									WHERE module = 'sn_allbum/sas_index2.php' AND name = '$page_name' ");
	if (mysql_num_rows($result2) == 0)
	{
		$result2 = mysql_query("SELECT id, section, lastupdate, name FROM $table_pages 
											WHERE module = 'sn_allbum/sas_index.php' ");
	}
	if (mysql_num_rows($result2) > 0)
	{
		$d = date("Y-m-d"); //todays date
		$change_date = mysql_result($result2, 0, 2);
		$savepage = mysql_result($result2, 0, 0);
		$section = mysql_result($result2, 0, 1);
		$title = mysql_result($result2, 0, 3);

		if ($change_date < $d)
		{ //send alerts only the first time on a date 
			include ("core/send_alerts.php"); //check to see if need to send alerts  
		}
		// mysql_query("UPDATE $table_pages SET lastupdate='$d' WHERE id='$savepage'");   // set the last update date for the page
	}
}

function ShowMove()
{
	// Task: show a page with a list of items that will be moved. Below that,
	// let the user select a (sub-)album where the items will be moved to.
	// At the bottom a move and cancel button. 
	// Move the selected objects.

	global $ID;
	global $gallerypage;
	global $sas_lang;
	global $module;
	global $ID3;
	global $candidate;
	global $move;

	$contents = explode(",", $_GET[ID3]);
	$contents = array_clean($contents, "");

	foreach ($contents AS $key => $value)
	{
		$type = db_GetType($value);
		if (($type == "subalbum") or ($type == "album"))
		{
			$contents = array_clean($contents, $value);
		}
	}

	// Check if the list has become empty (only (sub-)albums have been selected):
	if (!IsSet ($contents[0]))
	{

		echo "<form action=\"index.php\" method=\"get\">";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"show\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
		echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"" . $_GET[gallerypage] . "\">";
		echo "<p><span class=\"heading\">" . $sas_lang[sn_allbum_move_heading] . "</span></p>";
		echo "<table>";
		echo "<tr><td colspan=\"2\"><p><span class=\"text\">" . $sas_lang[sn_allbum_move_empty] . "</span></p></td></tr>";
		echo "<tr><td colspan=\"2\"><p><BR>
							<input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" 
							onClick=\"javascript:history.go(-1)\" class=\"backbutton\"></td></tr>";
		echo "</table>";

	}
	elseif ((!IsSet ($_GET[move])) OR (!IsSet ($_GET[candidate])) OR ($_GET[candidate] == ""))
	{

		// Show heading and text:
		echo "<p><span class=\"heading\">" . $sas_lang[sn_allbum_move_heading] . "</span></p>";

		if (IsSet ($_GET[move]) AND ((!IsSet ($_GET[candidate])) OR ($_GET[candidate] == "")))
		{
			echo "<p><span class=\"text\"><font color=\"red\">" . $sas_lang[sn_allbum_move_not_main] . "</font></span></p>";
		}

		echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_move_text] . "</span></p>";

		// List objects that will be moved:
		echo "<UL>";
		foreach ($contents AS $key => $value)
		{
			echo "<LI><span class=\"text\">";
			echo db_GetTitle($value);
			echo " (" . db_GetType($value) . ")";
			echo "</LI></span>";
		}
		echo "</UL>";

		// Show second text:
		echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_move_text2] . "</span></p>";

		// Show requested destination candidate:
		if ((!IsSet ($_GET[candidate])) OR ($_GET[candidate] == ""))
		{
			$candidate = 0;
			$candidate_title = $sas_lang[sn_allbum_main];
		}
		else
		{
			$candidate = $_GET[candidate];
			$candidate_title = $sas_lang[sn_allbum_main];
			$path = db_GetPath($candidate);
			$path = explode("/", $path);
			foreach ($path AS $key => $value)
			{
				if (($value == "media") OR ($value == "gallery"))
				{
					// skip
				}
				else
				{
					$candidate_title = $candidate_title . " -> " . $value;
				}
			}
		}
		echo "<UL><span class=\"text\"><b>" . $candidate_title . "</b></span><BR><BR>";
		$candidate_contents = db_GetContents($candidate);
		foreach ($candidate_contents AS $key => $value)
		{
			$type = db_GetType($value);
			if (($type == "album") OR ($type == "subalbum"))
			{
				echo "<LI><span class=\"text\"><a href=\"index.php?option=modulemanager&module=" . $module . "&suboption=move&ID3=" . $_GET[ID3] .
				"&ID=" . $_GET[ID] . "&gallerypage=" . $_GET[gallerypage] . "&candidate=" . $value . "\">" . db_GetTitle($value) . "</a></span></LI>";
			}
		}
		echo "</UL>";
		echo "<form action=\"index.php\" method=\"get\">";
		echo "<INPUT type=\"hidden\" name=\"option\" value=\"modulemanager\">";
		echo "<INPUT type=\"hidden\" name=\"module\" value=\"" . $module . "\">";
		echo "<INPUT type=\"hidden\" name=\"suboption\" value=\"move\">";
		echo "<INPUT type=\"hidden\" name=\"candidate\" value=\"" . $_GET[candidate] . "\">";
		echo "<INPUT type=\"hidden\" name=\"ID\" value=\"" . $_GET[ID] . "\">";
		echo "<INPUT type=\"hidden\" name=\"ID3\" value=\"" . implode(",", $contents) . "\">";
		echo "<INPUT type=\"hidden\" name=\"gallerypage\" value=\"" . $_GET[gallerypage] . "\">";
		echo "\n<p><input type=\"button\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang['goback'] . "\" name=\"backbutton\" onClick=\"javascript:history.go(-1)\" class=\"backbutton\">";
		echo "&nbsp;&nbsp;<INPUT type=\"submit\" name=\"move\" class=\"savebutton\" value=\"&nbsp;&nbsp;&nbsp;" . $sas_lang[sn_allbum_move] . "\">";

	}
	elseif (IsSet ($_GET[move]))
	{

		// what objects must be moved?
		$move_objects = array_clean(explode(",", $_GET[ID3]), "");

		// Let's move them!
		$result[0] = "ok";
		foreach ($move_objects AS $key => $value)
		{
			$result = MoveObject($value, $_GET[candidate]);
			if ($result[0] == "nok")
			{
				echo "<p><span class=\"heading\">" . $sas_lang[sn_allbum_move_error] . "</span></p>";
				echo "<p><span class=\"text\">" . $sas_lang[sn_allbum_move_error_text] . "</span></p>";
				echo "<p><span class=\"text\">" . $result[1] . "</span></p>";
				break;
			}
		}
		if ($result[0] == "ok")
		{
			echo $sas_lang[sn_allbum_no_errors];
			echo "<script language='javascript'>
									  window.location = 'index.php?option=modulemanager&module=" . $module . "&suboption=show&ID=" . $_GET[ID] . "&gallerypage=1'
									  </script>";
			echo $sas_lang[sn_allbum_error_redirect];
		}
	}
}
function MoveObject($objectid, $destinationid)
{
	// Task: move object with id $objectid, including all it's
	// contents to (sub-)album with id $destinationid
	// Return array(succes,message), where success is "ok" in
	// case no error has occured, "nok" otherwise. In case of
	// "nok", an error message must be put in 'message'.
	// Note: moving (sub-)albums has not been implemented.

	global $sas_lang;

	$type = db_GetType($objectid);
	$objects = array (
		'picture',
		'sound',
		'movie',
		'doc',
		'unknown'
	);

	if (in_array($type, $objects))
	{
		// *file*
		// - get full path to file of $objectid
		$objectpath = db_GetPath($objectid);
		$name = db_GetThumb($objectid);
		// - get path to directory of $destinationid  
		$source = str_replace("//", "/", $objectpath . "/" . $name);
		$destinationidpath = db_GetPath($destinationid);
		$destination = str_replace("//", "/", $destinationidpath . "/" . $name);

		// - check if a file with that name does already exists:
		if (file_exists($destination))
		{
			$succes = "nok";
			$message = $sas_lang[sn_allbum_move_file_error_exists];
			return array (
				$succes,
				$message
			);
		}

		// - move file to destination:
		$tmp = explode(".", $name);
		$ext = array_pop($tmp);
		$name = implode(".", $tmp);
		$thumbsrc = str_replace("//", "/", $objectpath . "/" . $name . "_t." . $ext);
		$thumbdest = str_replace("//", "/", $destinationidpath . "/" . $name . "_t." . $ext);
		if (file_exists($thumbsrc))
		{
			rename($thumbsrc, $thumbdest); //move thumb as well
		}
		if (rename($source, $destination))
		{
			$succes = "ok";
			$message = "";
		}
		else
		{
			$succes = "nok";
			$message = $sas_lang[sn_allbum_move_file_error];
		}

		// - update the children field of the old parent of $objectid:
		$objectidparentid = db_GetParentID($objectid);
		UpdateParentListOfChildren($objectid, $objectidparentid);

		// - update $objectid's parents field:
		db_PutParents($objectid, $destinationid);

		// - update $objectid's path:
		db_PutPathObject($objectid, $destinationidpath);

		// - update $destinationid's children field:
		$children = db_GetChildren($destinationid);
		if ($children == "")
		{
			$children = array ();
		}
		else
		{
			$children = explode(",", $children);
			$children = array_clean($children, "");
		}
		array_push($children, $objectid);
		db_PutChildren($destinationid, implode(",", $children));

		// - the thumbnail of $objectid's previous parent might be 
		//   empty now, try to find a new one:
		db_PutIfNeededUpdateParentThumb($objectidparentid);

		// - the thumbnail of $destinationid might be empty,
		//   we have a candidate now, so we might need to update it:
		db_PutIfNeededUpdateParentThumb($destinationid);

		return array (
			$succes,
			$message
		);
	}

	$objects = array (
		'album',
		'subalbum'
	);

	if (in_array($type, $objects))
	{
		// *(sub-)album*

		$succes = "nok";
		$message = "Moving (sub-)albums has not yet been implemented.";

		// - get path of $objectid
		//$source = db_GetPath($objectid);

		// - get path to directory of $destinationid
		//$destination = db_GetPath($destinationid);

		// - move directory to destination:
		//if (rename($source,$destination)) {
		//$succes = "ok";
		//$message = "";
		//} else {
		//$succes = "nok";
		//$message = $sas_lang[sn_allbum_move_dir_error];
		//}

		// update database: children (recursive): path

		// update database: own entry: path, parent OR path, parent, type (in case moved to main page)

		// update database: old parent: children

		// update database: new parent: children

		// - the thumbnail of $objectid's previous parent might be 
		//   empty now, try to find a new one:
		//db_PutIfNeededUpdateParentThumb($objectidparentid);

		// - the thumbnail of $destinationid might be empty,
		//   we have a candidate now, so we might need to update it:
		//db_PutIfNeededUpdateParentThumb($destinationid);

		return array (
			$succes,
			$message
		);
	}

}
function db_PutParents($ID, $parents)
{
	// Task: for object with id $ID, put the list of parents $parents

	global $allbum_table;

	$query = "UPDATE $allbum_table SET parent = '$parents' WHERE id='$ID'";
	$result = mysql_query($query) or die(mysql_error() . $query);
}
?>