/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998-2002  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc;

import java.util.*;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.text.*;
import jp.gr.java_conf.jaba2.j2fw.J2Config;
import jp.gr.java_conf.jaba2.j2fw.generator.*;
import jp.gr.java_conf.jaba2.util.ParameterInfo;
import jp.gr.java_conf.jaba2.util.AppParameterInfo;
import jp.gr.java_conf.jaba2.util.LocaleMap;
import jp.gr.java_conf.jaba2.util.MessageMap;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.IProcessor;
import jp.gr.java_conf.jaba2.xml.sax.EmacsErrorHandler;
import jp.gr.java_conf.jaba2.SmartDoc.pure.PureConfig;
import jp.gr.java_conf.jaba2.SmartDoc.plain.PlainConfig;
import jp.gr.java_conf.jaba2.SmartDoc.html3.HTML3Config;
import jp.gr.java_conf.jaba2.SmartDoc.html4.HTML4Config;
import jp.gr.java_conf.jaba2.SmartDoc.cdf.CDFConfig;
import jp.gr.java_conf.jaba2.SmartDoc.latex2e.LaTeX2eConfig;
import jp.gr.java_conf.jaba2.SmartDoc.javahelp.JavaHelpConfig;
import jp.gr.java_conf.jaba2.SmartDoc.dvi.DVIConfig;
import jp.gr.java_conf.jaba2.SmartDoc.postscript.PostScriptConfig;

/**
 * SmartDocConfig
 *
 * @since   Sep. 23, 1998
 * @version Feb.  2, 2002
 * @author  ASAMI, Tomoharu (asami@XMLSmartDoc.org)
 */
public class SmartDocConfig extends GeneratorConfig {
    // LocaleMap<Locale, MessageMap>
    protected LocaleMap messagesByLocale_ = new LocaleMap();
    protected LocaleMap resources_ = new LocaleMap();
    protected URL source_;
    protected String project_;
    protected File dir_;
    protected String deploy_;
    protected boolean toc_;
    protected boolean index_;
//    protected SmartDocGenerator generator_;
    protected String[] formats_;
    protected BibliographyDatabase bibDB_;
//    protected PackagerFactory packagerFactory_;
    // Map<String, SmartDocFormatConfig>
    protected Map configs_ = new HashMap();
    protected Locale[] locales_;
    protected Locale masterLocale_;
    protected String key_;
    protected URL header_;
    protected URL footer_;
    protected ClassLoader classloader_;
    protected boolean bigDocument_;

    public SmartDocConfig(String[] args)
	throws IOException, MalformedURLException {

	ParameterInfo info = new AppParameterInfo(
	    "jp.gr.java_conf.jaba2.SmartDoc",
	    args,
	    "jp.gr.java_conf.jaba2.SmartDoc.SmartDocResource",
	    new File("SmartDoc.properties")
	);
	info.addPackage("jp.gr.java_conf.jaba2.SmartDoc.adapter");
	_setup(info);
	URL baseUrl = getClass().getResource(
	    info.getParameterAsString("messageBase")
	);
	source_ = info.getArgumentAsURLFromFileOrURL(0);
/*
	if (source_.lastIndexOf(".sdoc") == -1) {
	    source_ = source_ + ".sdoc";
	}
*/
	if (source_ != null) {
	    project_ = _getProject(source_.getFile());
	    dir_ = _getProjectDirectory(source_.getFile());
	}
	deploy_ = info.getParameterAsString("split");
	if (deploy_ == null) {
	    deploy_ = info.getParameterAsString("deploy");
	}
	toc_ = info.getParameterAsBoolean("toc");
	index_ = info.getParameterAsBoolean("index");
//	generator_ = null;	// XXX
	formats_ = info.getParameterAsStringList("format");
	if (formats_ == null) {
	    USmartDoc.error("formats not configured");
	}
	URL bibFile = info.getParameterAsURLFromFileOrURL("bibdb");
	URL[] bibFiles;
	if (bibFile != null) {
	    bibFiles = new URL[1]; // XXX : more dbs
	    bibFiles[0] = bibFile;
	} else {
	    bibFiles = new URL[0];
	}
	try {
	    bibDB_ = new BibliographyDatabase(bibFiles);
	} catch (IOException e) {
	    USmartDoc.warningMessage(e.getMessage());
	}
	packagerFactory_.append(getClass().getResource(
	    "/jp/gr/java_conf/jaba2/SmartDoc/Packager.xml"
	));
	IGeneratorConfig[] configs = getConfigs();
	for (int i = 0;i < configs.length;i++) {
	    SmartDocFormatConfig formatConfig
		= (SmartDocFormatConfig)configs[i];
	    formatConfig.setup(this, args);
	    configs_.put(formatConfig.getID(), formatConfig);
	}
	locales_ = info.getParameterAsLocaleList("locale");
	masterLocale_ = info.getParameterAsLocale("masterLocale");
	key_ = info.getParameterAsString("key");
	if (isDebug()) {
	    USmartDoc.setDebug(true);
	}
	header_ = info.getParameterAsURLFromFileOrURL("header");
	footer_ = info.getParameterAsURLFromFileOrURL("footer");
	classloader_ = info.getParameterAsURLClassLoader("classpath");
	bigDocument_ = info.getParameterAsBoolean("bigDocument");
    }

    // J2Config
    public String getName() {
	return ("SmartDoc");
    }

    // J2Config
    public String getVersion() {
	return ("1.0");
    }

    // J2Config
    public String getBuild() {
	return ("20020202");
    }

    // J2Config
    public String[] getVersionMessage() {
	String[] message = {
	    "Copyright(c) 1998-2002 ASAMI,Tomoharu. All rights reserved.",
	    "SmartDoc Version " + getVersion() +
	    " (" + getBuild() + ") by asami@XMLSmartDoc.org",
	};
	return (message);
    }

    // J2Config
    public String[] getUsageMessage() {
	String[] message = {
	    "Usage: sdoc [-options] [args...]",
	    "  for more information, use -help option"
	};
	return (message);
    }

    // J2Config
    public String[] getHelpMessage() {
	String[] message = {
	    "Usage: sdoc [-options] [args...]",
	    "",
	    "where options include:",
	    "[common]",
	    "  -version",
	    "\tshow version",
	    "  -help",
	    "  -?",
	    "\tshow help. (this message)",
	    "  -verbose[:true|false]",
	    "\tenbale verbose output",
	    "  -toc[:true|false]",
	    "\tmake table of contents",
	    "  -index[:true|false]",
	    "\tmake index",
	    "  -locale:locale_list",
	    "\tavailable locales",
	    "  -masterLocale:locale",
	    "\tmaster locale",
	    "  -format:format_list",
	    "\tformats to generate",
	    "  -key:key_regex",
	    "\tselect context by the key regular expression",
	    "\t\t[pure]",
	    "\t\t[html3]",
	    "\t\t[html4]",
	    "\t\t[latex2e]",
	    "\t\t[javahelp]",
//	  "[dvi]"
//        "[postscript]"
//        "[pdf]"
//        "[plain]"
//        "[seetext]"
	    "  -packager:package_method",
	    "\tpackage method",
	    "\t\t[file]",
	    "\t\t[dir]",
	    "\t\t[jar]",
	    "\t\t[dirjar]"
	};
	return (message);
    }

    // J2Config
    public IProcessor getXMLProcessor() {
	IProcessor processor = super.getXMLProcessor();
	processor.setErrorHandler(new EmacsErrorHandler());
	return (processor);
    }

    // GeneratorConfig
    public IGenerator[] getGenerators() {
	int size = formats_.length;
	IGenerator[] generators = new IGenerator[size];
	for (int i = 0;i < size;i++) {
	    SmartDocFormatConfig fconfig
		= (SmartDocFormatConfig)configs_.get(formats_[i]);
	    if (fconfig == null) {
		USmartDoc.error("invalid format : " + formats_[i]);
	    }
	    generators[i] = fconfig.getGenerator();
	}
	return (generators);
    }

    public Locale[] getLocales() {
	return (locales_);
    }

    public Locale getMasterLocale() {
	return (masterLocale_);
    }

    public String getKey() {
	return (key_);
    }

    public URL getSource() {
	return (source_);
    }

    public String getProject() {
	return (project_);
    }

    public File getProjectDirectory() {
	return (dir_);
    }

    public String getDeploy() {
	return (deploy_);
    }

    public boolean makeToc() {
	return (toc_);
    }

    public boolean makeIndex() {
	return (index_);
    }

    public String[] getFormats() {
	return (formats_);
    }

    public BibliographyDatabase getBibliographyDatabase() {
	return (bibDB_);
    }

    public URL getHeader() {
	return (header_);
    }

    public URL getFooter() {
	return (footer_);
    }

    public ClassLoader getClassLoader() {
	return (classloader_);
    }

    public boolean isBigDocument() {
	return (bigDocument_);
    }

    public SmartDocFormatConfig getFormatConfig(String format) {
	return ((SmartDocFormatConfig)configs_.get(format));
    }

    public String getLabel(String key, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getLabel(key));
    }

    public String[] getLabelParts(String key, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getLabelParts(key));
    }

    public String getPartLabel(int number, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getPartLabel(number));
    }

    public String getChapterLabel(int number, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getChapterLabel(number));
    }

    public String getSectionLabel(int number, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getSectionLabel(number));
    }

    public String getSubSectionLabel(
	int section,
	int subSection,
	Locale locale
    ) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getSubSectionLabel(section, subSection));
    }

    public String getSubSubSectionLabel(
	int section,
	int subSection,
	int subSubSection,
	Locale locale
    ) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (
	    resource.getSubSubSectionLabel(section, subSection, subSubSection)
	);
    }

    public String getYearLabel(int year, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getYearLabel(year));
    }

    public String getMonthLabel(int month, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getMonthLabel(month));
    }

    public String getEditionLabel(int edition, Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getEditionLabel(edition));
    }

    public String getEditorLabel(Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getEditorLabel());
    }

    public String getEditorsLabel(Locale locale) {
	ISmartDocResource resource = _getResource(locale);
	if (resource == null) {
	    throw (new InternalError());
	}
	return (resource.getEditorsLabel());
    }

/*
    public String getLabel(String key, Locale locale) {
	if (locale == null) {
	    throw (new InternalError());
	}
	String message;
	MessageMap messageMap = (MessageMap)messagesByLocale_.get(locale);
	if (messageMap != null) {
	    if ((message = messageMap.getMessage(key)) != null) {
		return (message);
	    }
	}
	return (getLabel(key));
    }

    public String getYearLabel(int year, Locale locale) {
	if (locale == null) {
	    locale = Locale.getDefault();
	}
	if (locale.getLanguage().equals("ja")) { // XXX
	    return (year + "N"); // XXX
	} else {
	    return (Integer.toString(year));
	}
    }

    public String getMonthLabel(int month, Locale locale) {
	if (locale == null) {
	    locale = Locale.getDefault();
	}
	if (locale.getLanguage().equals("ja")) { // XXX
	    return (month + ""); // XXX
	} else {
	    DateFormatSymbols symbols = new DateFormatSymbols(locale);
	    return (symbols.getShortMonths()[month - 1] + ".");
	}
    }

    public String getEditionLabel(int edition, Locale locale) {
	if (locale == null) {
	    locale = Locale.getDefault();
	}
	String lang = locale.getLanguage();
	if ("en".equals(lang)) {
	    switch (edition) {
	    case 1:
		return ("1st");
	    case 2:
		return ("2nd");
	    case 3:
		return ("3rd");
	    default:
		return (edition + "th");
	    }
	} else if ("ja".equals(lang)) {
	    return ("" + edition + ""); // XXX
	} else {
	    return (String.valueOf(edition));
	}
    }

    public String getEditorLabel(Locale locale) {
	if (locale == null) {
	    locale = Locale.getDefault();
	}
	String lang = locale.getLanguage();
	if ("en".equals(lang)) {
	    return ("(ed.)");
	} else if ("ja".equals(lang)) {
	    return ("()"); // XXX
	} else {
	    return ("(ed.)");
	}
    }
*/

    protected ISmartDocResource _getResource(Locale locale) {
	ISmartDocResource resource
	    = (ISmartDocResource)resources_.get(locale);
	if (resource == null) {
	    resource = (ISmartDocResource)ResourceBundle.getBundle(
		"jp.gr.java_conf.jaba2.SmartDoc.SmartDocResource",
		locale
	    );
	    if (resource == null) {
		return (null);
	    }
	}
	resources_.put(locale, resource);
	return (resource);
    }

    // XXX : UString
    protected String _getProject(String filename) {
	int first;
	int last;
	first = filename.lastIndexOf("/");
	if (first == -1) {
	    first = 0;
	} else {
	    first++;
	}
	last = filename.lastIndexOf(".");
	if (last == -1) {
	    return (filename.substring(first));
	} else {
	    return (filename.substring(first, last));
	}
    }

    // XXX : UString
    protected File _getProjectDirectory(String filename) {
	int index = filename.lastIndexOf("/");
	if (index == -1) {
	    return (null);
	} else {
	    return (new File(filename.substring(0, index)));
	}
    }
}
