/*
 * SmartDoc : Ultimate document format based on XML
 *  Copyright (C) 1998,1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.SmartDoc.postscript;

import java.io.*;
import jp.gr.java_conf.jaba2.util.CommandAgent;
import jp.gr.java_conf.jaba2.io.FilePath;
import jp.gr.java_conf.jaba2.text.UString;
import jp.gr.java_conf.jaba2.SmartDoc.*;

/**
 * LaTeX2eAgent
 *
 * @since   May. 24, 1999
 * @version May. 30, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.com)
 */
public class LaTeX2eAgent {
    protected File dir_;
    protected String target_;
    protected String latexCommand_ = "jlatex $input";
    protected String dvipsCommand_ = "dvi2ps $input >$output";

    public LaTeX2eAgent(File target) {
	dir_ = target.getParentFile();
	target_ = target.getName();
    }

    public File generateDVIFile() throws IOException {
	int retries = 3;
	for (;;) {
	    boolean needRetry = _runLaTeXCommand(target_, dir_);
	    if (needRetry && --retries > 0) {
		continue;
	    }
	    break;
	}
	FilePath path = new FilePath(dir_, target_);
	FilePath newPath = path.changeSuffix("dvi");
	return (newPath.getFile());
    }

    protected boolean _runLaTeXCommand(String target, File dir)
	throws IOException {

	CommandAgent agent = new CommandAgent(
	    latexCommand_,
	    target,
	    dir
	);
	agent.addInputHandler(new CommandAgent.Handler() {
	    public CommandAgent.HandlerResult handle(String input) {
		CommandAgent.HandlerResult result
		    = new CommandAgent.HandlerResult();
		System.out.println(input);
		if (input.indexOf("LaTeX Error:") != -1) {
		    result.message = input;
		    result.state = CommandAgent.FINISH;
		}
		if (input.indexOf("LaTeX Waring:") != -1) {
		    result.message = input;
		}
		if (input.indexOf("No file") != -1) {
		    result.message = input;
		}
		if (input.indexOf("Output written") != -1) {
		    result.state = CommandAgent.FINISH;
		}
		return (result);
	    }
	});
	agent.start();
	agent.waitFinish();
	String[] messages = agent.getMessages();
	for (int i = 0;i < messages.length;i++) {
	    String message = messages[i];
// No file pre.aux.
	    if (message.indexOf("No file") != -1) {
		return (true);
	    }
// LaTeX Warning: Label(s) may have changed. Rerun to get cross-references right.
	    if (message.indexOf("changed") != -1) {
		return (true);
	    }
	    if (message.indexOf("LaTeX Error:") != -1) {
		throw (new SmartDocErrorException(message));
	    }
	}
	return (false);
    }

    public File generatePostScriptFile() throws IOException {
	File dviFile = generateDVIFile();
	String filename = dviFile.getName();
	CommandAgent agent = new CommandAgent(
	    dvipsCommand_,
	    filename,
	    UString.changeSuffix(filename, "ps"),
	    dir_
	);
	agent.start();
	agent.waitFinish();
	String[] messages = agent.getMessages();
	for (int i = 0;i < messages.length;i++) {
	    String message = messages[i];
	}
	FilePath path = new FilePath(dir_, target_);
	FilePath newPath = path.changeSuffix("ps");
	return (newPath.getFile());
    }

    // test driver
    public static void main(String[] args) throws Exception {
	String file = args[0];
	String dir = args[1];
	LaTeX2eAgent agent = new LaTeX2eAgent(new File(dir, file));
	File dviFile = agent.generateDVIFile();
	System.out.println(dviFile);
//	File psFile = agent.generatePostScriptFile();
//	System.out.println(psFile);
	System.exit(0);
    }
}
