package jp.gr.java_conf.jaba2.awt;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import jp.gr.java_conf.jaba2.awt.ExitWhenWindowClosing;

/**
 * JTreeTest is a test driver for the TreeNode.
 * This class display a tree structure using the JTree Widget.
 *
 * @since   Mar. 31, 1998
 * @version Nov. 20, 1998
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class JTreeTest extends JFrame {
    public JTree jtree;

    public JTreeTest(TreeNode root) {
	_init("JTreeTest", root);
    }

    public JTreeTest(String title, TreeNode root) {
	_init(title, root);
    }

    public void _init(String title, TreeNode root) {
	setTitle(title);
	jtree = new JTree(root);
	addWindowListener(new ExitWhenWindowClosing());
	getContentPane().add(new JScrollPane(jtree));
	pack();
	show();
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
	jtree.addTreeSelectionListener(tsl);
    }
}
