/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.awt;

import java.util.*;
import java.awt.*;
import jp.gr.java_conf.jaba2.util.ArrayMap;
import jp.gr.java_conf.jaba2.awt.lwlayout.*;

/**
 * LightWeightMasterLayout
 *
 * @since   Dec. 25, 1998
 * @version Feb. 17, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class LightWeightMasterLayout extends AbstractLayoutManager {
    protected MetaLayoutManager metaLayout_;
    // Map<String, LightWeightLayoutManager>
    protected ArrayMap layouts_ = new ArrayMap();

    // AbstractLayoutManager
    public void addLayoutComponent(Component comp, Object constraints) {
	if (constraints == null) {
	    throw (new IllegalArgumentException("no constraints"));
	}
	if (!(constraints instanceof LightWeightLayoutConstraints)) {
	    throw (new IllegalArgumentException(
		"not LightWeightLayoutConstraints"));
	}
	LightWeightLayoutConstraints param
	    = (LightWeightLayoutConstraints)constraints;
	String lwName = param.name;
	Object lwConstraints = param.constraints;
	LightWeightLayoutManager layout
	    = (LightWeightLayoutManager)layouts_.get(lwName);
	if (layout == null) {
	    throw (new IllegalArgumentException(
		"invalid layout manager name"));
	}
	layout.addLayoutComponent(comp, lwConstraints);
    }

    // AbstarctLayoutManager
    public void removeLayoutComponent(Component comp) {
	int nLayouts = layouts_.size();
	for (int i = 0;i < nLayouts;i++) {
	    LightWeightLayoutManager layout
		= (LightWeightLayoutManager)layouts_.get(i);
	    layout.removeLayoutComponent(comp);
	}
    }

    // LayoutManager
    public void layoutContainer(Container parent) {
	Dimension size = parent.getSize();
	metaLayout_.layoutComponents(size);
    }

    // LayoutManager
    public Dimension preferredLayoutSize(Container parent) {
	return (metaLayout_.preferredLayoutSize());
    }

    public void setMetaLayoutManager(MetaLayoutManager metaLayout) {
	metaLayout_ = metaLayout;
    }

    public void addLightWeightLayoutManager(
	String name,
	LightWeightLayoutManager layout,
	Object constraints
    ) {
	layouts_.put(name, layout);
	metaLayout_.addLightWeightLayoutManager(layout, constraints);
    }
}
